/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Schema {
    private final ImmutableList<ProtoFile> protoFiles;
    private final ImmutableMap<String, Type> typesIndex;
    private final ImmutableMap<String, Service> servicesIndex;

    Schema(Iterable<ProtoFile> protoFiles) {
        this.protoFiles = ImmutableList.copyOf(protoFiles);
        this.typesIndex = Schema.buildTypesIndex(protoFiles);
        this.servicesIndex = Schema.buildServicesIndex(protoFiles);
    }

    public ImmutableList<ProtoFile> protoFiles() {
        return this.protoFiles;
    }

    public Schema retainRoots(Collection<String> roots) {
        return new Pruner().retainRoots(this, roots);
    }

    public Service getService(String name) {
        return (Service)this.servicesIndex.get((Object)name);
    }

    public Service getService(Type.Name name) {
        return this.getService(name.toString());
    }

    public Type getType(String name) {
        return (Type)this.typesIndex.get((Object)name);
    }

    public Type getType(Type.Name name) {
        return this.getType(name.toString());
    }

    private static ImmutableMap<String, Type> buildTypesIndex(Iterable<ProtoFile> protoFiles) {
        LinkedHashMap<String, Type> result = new LinkedHashMap<String, Type>();
        for (ProtoFile protoFile : protoFiles) {
            for (Type type : protoFile.types()) {
                Schema.index(result, type);
            }
        }
        return ImmutableMap.copyOf(result);
    }

    private static void index(Map<String, Type> typesByName, Type type) {
        typesByName.put(type.name().toString(), type);
        for (Type nested : type.nestedTypes()) {
            Schema.index(typesByName, nested);
        }
    }

    private static ImmutableMap<String, Service> buildServicesIndex(Iterable<ProtoFile> protoFiles) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ProtoFile protoFile : protoFiles) {
            for (Service service : protoFile.services()) {
                result.put((Object)service.name().toString(), (Object)service);
            }
        }
        return result.build();
    }
}

