/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.protoparser.FieldElement;
import com.squareup.wire.internal.protoparser.OneOfElement;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;

public final class OneOf {
    private final String packageName;
    private final OneOfElement element;
    private final ImmutableList<Field> fields;

    OneOf(String packageName, OneOfElement element) {
        this.packageName = packageName;
        this.element = element;
        ImmutableList.Builder fields = ImmutableList.builder();
        for (FieldElement field : element.fields()) {
            fields.add((Object)new Field(packageName, field));
        }
        this.fields = fields.build();
    }

    public String packageName() {
        return this.packageName;
    }

    public String name() {
        return this.element.name();
    }

    public String documentation() {
        return this.element.documentation();
    }

    public ImmutableList<Field> fields() {
        return this.fields;
    }

    void link(Linker linker) {
        for (Field field : this.fields) {
            field.link(linker);
        }
    }

    void linkOptions(Linker linker) {
        for (Field field : this.fields) {
            field.linkOptions(linker);
        }
    }
}

