/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal.protoparser;

import com.google.common.base.Preconditions;
import com.squareup.wire.internal.Util;
import com.squareup.wire.internal.protoparser.AutoValue_OptionElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class OptionElement {
    public static OptionElement create(String name, Kind kind, Object value) {
        return OptionElement.create(name, kind, value, false);
    }

    public static OptionElement create(String name, Kind kind, Object value, boolean isParenthesized) {
        return new AutoValue_OptionElement(name, kind, value, isParenthesized);
    }

    public abstract String name();

    public abstract Kind kind();

    public abstract Object value();

    public abstract boolean isParenthesized();

    public final String toSchema() {
        Object value = this.value();
        switch (this.kind()) {
            case STRING: {
                return this.formatName() + " = \"" + value + '\"';
            }
            case BOOLEAN: 
            case NUMBER: 
            case ENUM: {
                return this.formatName() + " = " + value;
            }
            case OPTION: {
                StringBuilder builder = new StringBuilder();
                OptionElement optionValue = (OptionElement)value;
                optionValue = OptionElement.create(optionValue.name(), optionValue.kind(), optionValue.value());
                builder.append(this.formatName()).append('.').append(optionValue.toSchema());
                return builder.toString();
            }
            case MAP: {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formatName()).append(" = {\n");
                Map valueMap = (Map)value;
                OptionElement.formatOptionMap(builder, valueMap);
                builder.append('}');
                return builder.toString();
            }
            case LIST: {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formatName()).append(" = [\n");
                List optionList = (List)value;
                OptionElement.formatOptionList(builder, optionList);
                builder.append(']');
                return builder.toString();
            }
        }
        throw new AssertionError();
    }

    public final String toSchemaDeclaration() {
        return "option " + this.toSchema() + ";\n";
    }

    static void formatOptionList(StringBuilder builder, List<OptionElement> optionList) {
        int count = optionList.size();
        for (int i = 0; i < count; ++i) {
            String endl = i < count - 1 ? "," : "";
            Util.appendIndented(builder, optionList.get(i).toSchema() + endl);
        }
    }

    static void formatOptionMap(StringBuilder builder, Map<String, ?> valueMap) {
        ArrayList entries = new ArrayList(valueMap.entrySet());
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            String endl = i < count - 1 ? "," : "";
            Util.appendIndented(builder, (String)entry.getKey() + ": " + OptionElement.formatOptionMapValue(entry.getValue()) + endl);
        }
    }

    static String formatOptionMapValue(Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value == null");
        if (value instanceof String) {
            return "\"" + value + '\"';
        }
        if (value instanceof Map) {
            StringBuilder builder = new StringBuilder().append("{\n");
            Map map = (Map)value;
            OptionElement.formatOptionMap(builder, map);
            return builder.append('}').toString();
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder().append("[\n");
            List list = (List)value;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                String endl = i < count - 1 ? "," : "";
                Util.appendIndented(builder, OptionElement.formatOptionMapValue(list.get(i)) + endl);
            }
            return builder.append("]").toString();
        }
        return value.toString();
    }

    private String formatName() {
        return this.isParenthesized() ? '(' + this.name() + ')' : this.name();
    }

    public static enum Kind {
        STRING,
        BOOLEAN,
        NUMBER,
        ENUM,
        MAP,
        LIST,
        OPTION;

    }
}

