/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import java.io.Closeable;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.fakefilesystem.FakeFileSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/squareup/wire/SchemaBuilder;", "", "()V", "fileSystem", "Lokio/FileSystem;", "sourcePath", "Lokio/Path;", "add", "name", "protoFile", "", "build", "Lcom/squareup/wire/schema/Schema;", "wire-schema-tests"})
public final class SchemaBuilder {
    @NotNull
    private final Path sourcePath = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/source", (boolean)false, (int)1, null);
    @NotNull
    private final FileSystem fileSystem = (FileSystem)new FakeFileSystem(null, 1, null);

    public SchemaBuilder() {
        this.fileSystem.createDirectories(this.sourcePath);
    }

    @NotNull
    public final SchemaBuilder add(@NotNull Path name, @NotNull String protoFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        if (!StringsKt.endsWith$default((String)name.toString(), (String)".proto", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-SchemaBuilder$add$22 = false;
            String $i$a$-require-SchemaBuilder$add$22 = "unexpected file extension for " + name + ". Proto files should use the '.proto' extension";
            throw new IllegalArgumentException($i$a$-require-SchemaBuilder$add$22.toString());
        }
        try {
            Path resolvedPath = this.sourcePath.resolve(name);
            Path parent = resolvedPath.parent();
            if (parent != null) {
                this.fileSystem.createDirectories(parent);
            }
            FileSystem this_$iv = this.fileSystem;
            boolean mustCreate$iv = false;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(resolvedPath, mustCreate$iv));
            boolean $i$f$use = false;
            BufferedSink result$iv$iv = null;
            Throwable thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$add_u24lambda_u2d1 = it$iv;
                boolean bl3 = false;
                result$iv$iv = $this$add_u24lambda_u2d1.writeUtf8(protoFile);
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                if (thrown$iv$iv == null) {
                    thrown$iv$iv = t$iv$iv;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
            }
            if (thrown$iv$iv != null) {
                throw thrown$iv$iv;
            }
            Intrinsics.checkNotNull((Object)result$iv$iv);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    @NotNull
    public final Schema build() {
        SchemaLoader schemaLoader = new SchemaLoader(this.fileSystem);
        schemaLoader.initRoots(CollectionsKt.listOf((Object)Location.Companion.get(this.sourcePath.toString())), CollectionsKt.emptyList());
        return schemaLoader.loadSchema();
    }
}

