[wire-schema](../../index.md) / [com.squareup.wire.schema](../index.md) / [MarkSet](./index.md)

# MarkSet

`class MarkSet`

A mark set is used in three phases:

1. Marking root types and root members. These are the identifiers specifically identified by
    the user in the includes set. In this phase it is an error to mark a type that is excluded,
    or to mark both a type and one of its members.
2. Marking members transitively reachable by those roots. In this phase if a member is visited,
    the member's enclosing type is marked instead, unless it is of a type that has a specific
    member already marked.
3. Retaining which members and types have been marked.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `MarkSet(pruningRules: `[`PruningRules`](../-pruning-rules/index.md)`)`<br>A mark set is used in three phases: |

### Properties

| Name | Summary |
|---|---|
| [members](members.md) | `val members: <ERROR CLASS>`<br>The members to retain. Any member not in here should be pruned! |
| [pruningRules](pruning-rules.md) | `val pruningRules: `[`PruningRules`](../-pruning-rules/index.md) |
| [types](types.md) | `val types: <ERROR CLASS>`<br>The types to retain. We may retain a type but not all of its members. |

### Functions

| Name | Summary |
|---|---|
| [contains](contains.md) | `operator fun contains(type: `[`ProtoType`](../-proto-type/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if `type` is marked and should be retained.`operator fun contains(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if `member` is marked and should be retained. |
| [mark](mark.md) | `fun mark(type: `[`ProtoType`](../-proto-type/index.md)`, reference: `[`ProtoMember`](../-proto-member/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>`fun mark(type: `[`ProtoType`](../-proto-type/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Marks a type as transitively reachable by the includes set. Returns true if the mark is new, the type will be retained, and reachable objects should be traversed.`fun mark(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Marks a member as transitively reachable by the includes set. Returns true if the mark is new, the member will be retained, and reachable objects should be traversed. |
| [root](root.md) | `fun root(protoMember: `[`ProtoMember`](../-proto-member/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Marks `protoMember`, throwing if it is explicitly excluded. This implicitly excludes other members of the same type.`fun root(type: `[`ProtoType`](../-proto-type/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Marks `type`, throwing if it is explicitly excluded. |
