/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.Syntax;
import com.squareup.wire.internal.DurationJsonFormatter;
import com.squareup.wire.internal.EnumJsonFormatter;
import com.squareup.wire.internal.FieldBinding;
import com.squareup.wire.internal.InstantJsonFormatter;
import com.squareup.wire.internal.JsonFormatter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\b$%&'()*+B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0005\u001a\u00028\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H&\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\t\u001a\u00028\u00012\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ[\u0010\u000e\u001a\u00028\u0001\"\u0014\b\u0002\u0010\u000f*\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0014\b\u0003\u0010\u0011*\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00110\u00122\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00110\u0016\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\u0015\u0010\u001b\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\u00028\u00012\u0006\u0010\n\u001a\u00028\u00002\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010 \u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006,"}, d2={"Lcom/squareup/wire/internal/JsonIntegration;", "F", "A", "", "()V", "formatterAdapter", "jsonStringAdapter", "Lcom/squareup/wire/internal/JsonFormatter;", "(Lcom/squareup/wire/internal/JsonFormatter;)Ljava/lang/Object;", "frameworkAdapter", "framework", "type", "Ljava/lang/reflect/Type;", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "jsonAdapter", "M", "Lcom/squareup/wire/Message;", "B", "Lcom/squareup/wire/Message$Builder;", "syntax", "Lcom/squareup/wire/Syntax;", "field", "Lcom/squareup/wire/internal/FieldBinding;", "(Ljava/lang/Object;Lcom/squareup/wire/Syntax;Lcom/squareup/wire/internal/FieldBinding;)Ljava/lang/Object;", "jsonFormatter", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "listAdapter", "elementAdapter", "(Ljava/lang/Object;)Ljava/lang/Object;", "mapAdapter", "keyFormatter", "valueAdapter", "(Ljava/lang/Object;Lcom/squareup/wire/internal/JsonFormatter;Ljava/lang/Object;)Ljava/lang/Object;", "mapKeyJsonFormatter", "structAdapter", "ByteStringJsonFormatter", "IntAsStringJsonFormatter", "LongAsStringJsonFormatter", "StringJsonFormatter", "UnsignedIntAsNumberJsonFormatter", "UnsignedIntAsStringJsonFormatter", "UnsignedLongAsNumberJsonFormatter", "UnsignedLongAsStringJsonFormatter", "wire-runtime"})
public abstract class JsonIntegration<F, A> {
    public abstract A frameworkAdapter(F var1, @NotNull Type var2);

    public abstract A listAdapter(A var1);

    public abstract A mapAdapter(F var1, @NotNull JsonFormatter<?> var2, A var3);

    public abstract A structAdapter(F var1);

    public abstract A formatterAdapter(@NotNull JsonFormatter<?> var1);

    public final <M extends Message<M, B>, B extends Message.Builder<M, B>> A jsonAdapter(F framework, @NotNull Syntax syntax, @NotNull FieldBinding<M, B> field) {
        A a;
        Intrinsics.checkNotNullParameter((Object)((Object)syntax), (String)"syntax");
        Intrinsics.checkNotNullParameter(field, (String)"field");
        if (field.singleAdapter().isStruct$wire_runtime()) {
            return this.structAdapter(framework);
        }
        JsonFormatter<?> jsonStringAdapter = this.jsonFormatter(syntax, field.singleAdapter());
        if (jsonStringAdapter != null) {
            a = this.formatterAdapter(jsonStringAdapter);
        } else {
            KClass<?> kClass = field.singleAdapter().getType();
            Class clazz = kClass != null ? JvmClassMappingKt.getJavaObjectType(kClass) : null;
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.Type");
            }
            a = this.frameworkAdapter(framework, clazz);
        }
        A singleAdapter = a;
        return field.getLabel().isRepeated() ? this.listAdapter(singleAdapter) : (field.isMap() ? this.mapAdapter(framework, this.mapKeyJsonFormatter(field.keyAdapter()), singleAdapter) : singleAdapter);
    }

    private final JsonFormatter<?> jsonFormatter(Syntax syntax, ProtoAdapter<?> protoAdapter) {
        ProtoAdapter<?> protoAdapter2 = protoAdapter;
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.BYTES) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.BYTES_VALUE)) {
            return ByteStringJsonFormatter.INSTANCE;
        }
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.DURATION)) {
            return DurationJsonFormatter.INSTANCE;
        }
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INSTANT)) {
            return InstantJsonFormatter.INSTANCE;
        }
        if (protoAdapter2 instanceof EnumAdapter) {
            return new EnumJsonFormatter((EnumAdapter)protoAdapter);
        }
        if (syntax == Syntax.PROTO_2) {
            protoAdapter2 = protoAdapter;
            return Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64_VALUE) ? (JsonFormatter)UnsignedLongAsNumberJsonFormatter.INSTANCE : null;
        }
        protoAdapter2 = protoAdapter;
        return Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT32_VALUE) ? (JsonFormatter)UnsignedIntAsNumberJsonFormatter.INSTANCE : (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SFIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SINT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT64_VALUE) ? (JsonFormatter)LongAsStringJsonFormatter.INSTANCE : (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64_VALUE) ? (JsonFormatter)UnsignedLongAsStringJsonFormatter.INSTANCE : null));
    }

    private final JsonFormatter<?> mapKeyJsonFormatter(ProtoAdapter<?> protoAdapter) {
        JsonFormatter jsonFormatter;
        ProtoAdapter<?> protoAdapter2 = protoAdapter;
        if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.STRING)) {
            jsonFormatter = StringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SINT32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SFIXED32)) {
            jsonFormatter = IntAsStringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED32) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT32)) {
            jsonFormatter = UnsignedIntAsStringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.INT64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SFIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.SINT64)) {
            jsonFormatter = LongAsStringJsonFormatter.INSTANCE;
        } else if (Intrinsics.areEqual(protoAdapter2, ProtoAdapter.FIXED64) || Intrinsics.areEqual(protoAdapter2, ProtoAdapter.UINT64)) {
            jsonFormatter = UnsignedLongAsStringJsonFormatter.INSTANCE;
        } else {
            String string = "Unexpected map key type: " + protoAdapter.getType();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return jsonFormatter;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedLongAsNumberJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "()V", "maxLong", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "power64", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Long;", "toStringOrNumber", "", "wire-runtime"})
    private static final class UnsignedLongAsNumberJsonFormatter
    implements JsonFormatter<Long> {
        private static final BigInteger power64;
        private static final BigInteger maxLong;
        public static final UnsignedLongAsNumberJsonFormatter INSTANCE;

        @Override
        @NotNull
        public Long fromString(@NotNull String value) {
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                bigInteger = new BigInteger(value);
            }
            catch (Exception e) {
                bigInteger = new BigDecimal(value).toBigInteger();
            }
            BigInteger bigInteger2 = bigInteger;
            return bigInteger2.compareTo(maxLong) > 0 ? bigInteger2.subtract(power64).longValue() : bigInteger2.longValue();
        }

        @Override
        @NotNull
        public Object toStringOrNumber(long value) {
            Number number = value < 0L ? power64.add(BigInteger.valueOf(value)) : Long.valueOf(value);
            Intrinsics.checkNotNullExpressionValue((Object)number, (String)"when {\n        value < 0\u2026    else -> value\n      }");
            return number;
        }

        private UnsignedLongAsNumberJsonFormatter() {
        }

        static {
            UnsignedLongAsNumberJsonFormatter unsignedLongAsNumberJsonFormatter;
            INSTANCE = unsignedLongAsNumberJsonFormatter = new UnsignedLongAsNumberJsonFormatter();
            power64 = new BigInteger("18446744073709551616");
            maxLong = BigInteger.valueOf(Long.MAX_VALUE);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedLongAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "()V", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Long;", "toStringOrNumber", "wire-runtime"})
    private static final class UnsignedLongAsStringJsonFormatter
    implements JsonFormatter<Long> {
        public static final UnsignedLongAsStringJsonFormatter INSTANCE;

        @NotNull
        public String toStringOrNumber(long value) {
            return UnsignedLongAsNumberJsonFormatter.INSTANCE.toStringOrNumber(value).toString();
        }

        @Override
        @NotNull
        public Long fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return UnsignedLongAsNumberJsonFormatter.INSTANCE.fromString(value);
        }

        private UnsignedLongAsStringJsonFormatter() {
        }

        static {
            UnsignedLongAsStringJsonFormatter unsignedLongAsStringJsonFormatter;
            INSTANCE = unsignedLongAsStringJsonFormatter = new UnsignedLongAsStringJsonFormatter();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$LongAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "()V", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Long;", "toStringOrNumber", "wire-runtime"})
    private static final class LongAsStringJsonFormatter
    implements JsonFormatter<Long> {
        public static final LongAsStringJsonFormatter INSTANCE;

        @NotNull
        public String toStringOrNumber(long value) {
            return String.valueOf(value);
        }

        @Override
        @NotNull
        public Long fromString(@NotNull String value) {
            long l;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                String string = value;
                boolean bl = false;
                l = Long.parseLong(string);
            }
            catch (Exception e) {
                l = new BigDecimal(value).longValueExact();
            }
            return l;
        }

        private LongAsStringJsonFormatter() {
        }

        static {
            LongAsStringJsonFormatter longAsStringJsonFormatter;
            INSTANCE = longAsStringJsonFormatter = new LongAsStringJsonFormatter();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedIntAsNumberJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "()V", "maxInt", "", "power32", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toStringOrNumber", "", "wire-runtime"})
    private static final class UnsignedIntAsNumberJsonFormatter
    implements JsonFormatter<Integer> {
        private static final long power32 = 0x100000000L;
        private static final long maxInt = Integer.MAX_VALUE;
        public static final UnsignedIntAsNumberJsonFormatter INSTANCE;

        @Override
        @NotNull
        public Integer fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value;
            boolean bl = false;
            long longValue = (long)Double.parseDouble(string);
            return longValue >= Integer.MAX_VALUE ? (int)(longValue - 0x100000000L) : (int)longValue;
        }

        @Override
        @NotNull
        public Object toStringOrNumber(int value) {
            return value < 0 ? (Number)((long)value + 0x100000000L) : (Number)value;
        }

        private UnsignedIntAsNumberJsonFormatter() {
        }

        static {
            UnsignedIntAsNumberJsonFormatter unsignedIntAsNumberJsonFormatter;
            INSTANCE = unsignedIntAsNumberJsonFormatter = new UnsignedIntAsNumberJsonFormatter();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$UnsignedIntAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "()V", "power32", "", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toStringOrNumber", "", "wire-runtime"})
    private static final class UnsignedIntAsStringJsonFormatter
    implements JsonFormatter<Integer> {
        private static final long power32 = 0x100000000L;
        public static final UnsignedIntAsStringJsonFormatter INSTANCE;

        @Override
        @NotNull
        public Integer fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value;
            boolean bl = false;
            return (int)Long.parseLong(string);
        }

        @Override
        @NotNull
        public Object toStringOrNumber(int value) {
            return value < 0 ? String.valueOf((long)value + 0x100000000L) : String.valueOf(value);
        }

        private UnsignedIntAsStringJsonFormatter() {
        }

        static {
            UnsignedIntAsStringJsonFormatter unsignedIntAsStringJsonFormatter;
            INSTANCE = unsignedIntAsStringJsonFormatter = new UnsignedIntAsStringJsonFormatter();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$IntAsStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "()V", "fromString", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "toStringOrNumber", "wire-runtime"})
    private static final class IntAsStringJsonFormatter
    implements JsonFormatter<Integer> {
        public static final IntAsStringJsonFormatter INSTANCE;

        @Override
        @NotNull
        public Integer fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value;
            boolean bl = false;
            return Integer.parseInt(string);
        }

        @NotNull
        public String toStringOrNumber(int value) {
            return String.valueOf(value);
        }

        private IntAsStringJsonFormatter() {
        }

        static {
            IntAsStringJsonFormatter intAsStringJsonFormatter;
            INSTANCE = intAsStringJsonFormatter = new IntAsStringJsonFormatter();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$ByteStringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "Lokio/ByteString;", "()V", "fromString", "value", "", "toStringOrNumber", "wire-runtime"})
    private static final class ByteStringJsonFormatter
    implements JsonFormatter<ByteString> {
        public static final ByteStringJsonFormatter INSTANCE;

        @NotNull
        public String toStringOrNumber(@NotNull ByteString value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.base64();
        }

        @Override
        @Nullable
        public ByteString fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ByteString.Companion.decodeBase64(value);
        }

        private ByteStringJsonFormatter() {
        }

        static {
            ByteStringJsonFormatter byteStringJsonFormatter;
            INSTANCE = byteStringJsonFormatter = new ByteStringJsonFormatter();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/squareup/wire/internal/JsonIntegration$StringJsonFormatter;", "Lcom/squareup/wire/internal/JsonFormatter;", "", "()V", "fromString", "value", "toStringOrNumber", "wire-runtime"})
    private static final class StringJsonFormatter
    implements JsonFormatter<String> {
        public static final StringJsonFormatter INSTANCE;

        @NotNull
        public String toStringOrNumber(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }

        @Override
        @NotNull
        public String fromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }

        private StringJsonFormatter() {
        }

        static {
            StringJsonFormatter stringJsonFormatter;
            INSTANCE = stringJsonFormatter = new StringJsonFormatter();
        }
    }
}

