/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Extension;
import com.squareup.wire.ImmutableList;
import com.squareup.wire.MessageSerializedForm;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.RuntimeEnumAdapter;
import com.squareup.wire.TagMap;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class Message<T extends Message<T>>
implements Serializable {
    private static final long serialVersionUID = 0L;
    transient TagMap tagMap;
    transient int cachedSerializedSize = 0;
    protected transient int hashCode = 0;

    protected Message() {
    }

    protected final void setBuilder(Builder builder) {
        if (builder.tagMapBuilder != null) {
            this.tagMap = builder.tagMapBuilder.build();
        }
    }

    protected static <T> List<T> copyOf(List<T> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        return new ArrayList<T>(list);
    }

    protected static <T> List<T> immutableCopyOf(List<T> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (list == Collections.emptyList() || list instanceof ImmutableList) {
            return list;
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <E extends Enum> E enumFromInt(Class<E> enumClass, int value) {
        RuntimeEnumAdapter<E> adapter = ProtoAdapter.newEnumAdapter(enumClass);
        return (E)((Enum)adapter.fromInt(value));
    }

    int tagMapEncodedSize() {
        return this.tagMap == null ? 0 : this.tagMap.encodedSize();
    }

    protected static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public final Set<Extension<?, ?>> getExtensions() {
        return this.tagMap != null ? this.tagMap.extensions(false) : Collections.emptySet();
    }

    public final <E> E getExtension(Extension<T, E> extension) {
        return (E)(this.tagMap != null ? this.tagMap.get(extension) : null);
    }

    protected final boolean extensionsEqual(Message<T> other) {
        return this.tagMap != null ? this.tagMap.equals(other.tagMap) : other.tagMap == null;
    }

    protected final int extensionsHashCode() {
        return this.tagMap != null ? this.tagMap.hashCode() : 0;
    }

    public String toString() {
        return ProtoAdapter.newMessageAdapter(this.getClass()).toString(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MessageSerializedForm(this, this.getClass());
    }

    public static abstract class Builder<T extends Message<T>, B extends Builder<T, B>> {
        TagMap.Builder tagMapBuilder;

        public Builder() {
        }

        public Builder(Message message) {
            if (message != null && message.tagMap != null) {
                this.tagMapBuilder = new TagMap.Builder(message.tagMap);
            }
        }

        TagMap.Builder ensureTagMap() {
            if (this.tagMapBuilder == null) {
                this.tagMapBuilder = new TagMap.Builder();
            }
            return this.tagMapBuilder;
        }

        protected static IllegalStateException missingRequiredFields(Object ... args) {
            StringBuilder sb = new StringBuilder();
            String plural = "";
            int size = args.length;
            for (int i = 0; i < size; i += 2) {
                if (args[i] != null) continue;
                if (sb.length() > 0) {
                    plural = "s";
                }
                sb.append("\n  ");
                sb.append(args[i + 1]);
            }
            throw new IllegalStateException("Required field" + plural + " not set:" + sb);
        }

        protected static <T> List<T> canonicalizeList(List<T> list) {
            if (list == null) {
                throw new NullPointerException("list == null");
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                T element = list.get(i);
                if (element != null) continue;
                throw new NullPointerException("Element at index " + i + " is null");
            }
            return list;
        }

        public final <E> E getExtension(Extension<T, E> extension) {
            return (E)(this.tagMapBuilder != null ? this.tagMapBuilder.get(extension) : null);
        }

        public final <E> B setExtension(Extension<T, E> extension, E value) {
            if (this.tagMapBuilder == null) {
                this.tagMapBuilder = new TagMap.Builder();
            } else {
                this.tagMapBuilder.removeAll(extension.getTag());
            }
            if (value instanceof List) {
                for (Object o : (List)value) {
                    this.tagMapBuilder.add(extension, o);
                }
            } else {
                this.tagMapBuilder.add(extension, value);
            }
            return (B)this;
        }

        public abstract T build();
    }
}

