/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.Preconditions;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

public abstract class TypeAdapter<E> {
    static final int FIXED_BOOL_SIZE = 1;
    static final int FIXED_32_SIZE = 4;
    static final int FIXED_64_SIZE = 8;
    final FieldEncoding fieldEncoding;
    final Class<?> javaType;
    public static final TypeAdapter<Boolean> BOOL = new TypeAdapter<Boolean>(FieldEncoding.VARINT, Boolean.class){

        @Override
        public int encodedSize(Boolean value) {
            return 1;
        }

        @Override
        public void write(ProtoWriter writer, Boolean value) throws IOException {
            writer.writeVarint32(value != false ? 1 : 0);
        }

        @Override
        public Boolean read(ProtoReader reader) throws IOException {
            int value = reader.readVarint32();
            if (value == 0) {
                return Boolean.FALSE;
            }
            if (value == 1) {
                return Boolean.TRUE;
            }
            throw new IOException(String.format("Invalid boolean value 0x%02x", value));
        }
    };
    public static final TypeAdapter<Integer> INT32 = new TypeAdapter<Integer>(FieldEncoding.VARINT, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return ProtoWriter.int32Size(value);
        }

        @Override
        public void write(ProtoWriter writer, Integer value) throws IOException {
            writer.writeSignedVarint32(value);
        }

        @Override
        public Integer read(ProtoReader reader) throws IOException {
            return reader.readVarint32();
        }
    };
    public static final TypeAdapter<Integer> UINT32 = new TypeAdapter<Integer>(FieldEncoding.VARINT, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return ProtoWriter.varint32Size(value);
        }

        @Override
        public void write(ProtoWriter writer, Integer value) throws IOException {
            writer.writeVarint32(value);
        }

        @Override
        public Integer read(ProtoReader reader) throws IOException {
            return reader.readVarint32();
        }
    };
    public static final TypeAdapter<Integer> SINT32 = new TypeAdapter<Integer>(FieldEncoding.VARINT, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return ProtoWriter.varint32Size(ProtoWriter.encodeZigZag32(value));
        }

        @Override
        public void write(ProtoWriter writer, Integer value) throws IOException {
            writer.writeVarint32(ProtoWriter.encodeZigZag32(value));
        }

        @Override
        public Integer read(ProtoReader reader) throws IOException {
            return ProtoWriter.decodeZigZag32(reader.readVarint32());
        }
    };
    public static final TypeAdapter<Integer> FIXED32 = new TypeAdapter<Integer>(FieldEncoding.FIXED32, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return 4;
        }

        @Override
        public void write(ProtoWriter writer, Integer value) throws IOException {
            writer.writeFixed32(value);
        }

        @Override
        public Integer read(ProtoReader reader) throws IOException {
            return reader.readFixed32();
        }
    };
    public static final TypeAdapter<Integer> SFIXED32 = FIXED32;
    public static final TypeAdapter<Long> INT64 = new TypeAdapter<Long>(FieldEncoding.VARINT, Long.class){

        @Override
        public int encodedSize(Long value) {
            return ProtoWriter.varint64Size(value);
        }

        @Override
        public void write(ProtoWriter writer, Long value) throws IOException {
            writer.writeVarint64(value);
        }

        @Override
        public Long read(ProtoReader reader) throws IOException {
            return reader.readVarint64();
        }
    };
    public static final TypeAdapter<Long> UINT64 = INT64;
    public static final TypeAdapter<Long> SINT64 = new TypeAdapter<Long>(FieldEncoding.VARINT, Long.class){

        @Override
        public int encodedSize(Long value) {
            return ProtoWriter.varint64Size(ProtoWriter.encodeZigZag64(value));
        }

        @Override
        public void write(ProtoWriter writer, Long value) throws IOException {
            writer.writeVarint64(ProtoWriter.encodeZigZag64(value));
        }

        @Override
        public Long read(ProtoReader reader) throws IOException {
            return ProtoWriter.decodeZigZag64(reader.readVarint64());
        }
    };
    public static final TypeAdapter<Long> FIXED64 = new TypeAdapter<Long>(FieldEncoding.FIXED64, Long.class){

        @Override
        public int encodedSize(Long value) {
            return 8;
        }

        @Override
        public void write(ProtoWriter writer, Long value) throws IOException {
            writer.writeFixed64(value);
        }

        @Override
        public Long read(ProtoReader reader) throws IOException {
            return reader.readFixed64();
        }
    };
    public static final TypeAdapter<Long> SFIXED64 = FIXED64;
    public static final TypeAdapter<Float> FLOAT = new TypeAdapter<Float>(FieldEncoding.FIXED32, Float.class){

        @Override
        public int encodedSize(Float value) {
            return 4;
        }

        @Override
        public void write(ProtoWriter writer, Float value) throws IOException {
            writer.writeFixed32(Float.floatToIntBits(value.floatValue()));
        }

        @Override
        public Float read(ProtoReader reader) throws IOException {
            return Float.valueOf(Float.intBitsToFloat(reader.readFixed32()));
        }
    };
    public static final TypeAdapter<Double> DOUBLE = new TypeAdapter<Double>(FieldEncoding.FIXED64, Double.class){

        @Override
        public int encodedSize(Double value) {
            return 8;
        }

        @Override
        public void write(ProtoWriter writer, Double value) throws IOException {
            writer.writeFixed64(Double.doubleToLongBits(value));
        }

        @Override
        public Double read(ProtoReader reader) throws IOException {
            return Double.longBitsToDouble(reader.readFixed64());
        }
    };
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(FieldEncoding.LENGTH_DELIMITED, String.class){

        @Override
        public int encodedSize(String value) {
            return ProtoWriter.utf8Length(value);
        }

        @Override
        public void write(ProtoWriter writer, String value) throws IOException {
            writer.writeString(value);
        }

        @Override
        public String read(ProtoReader reader) throws IOException {
            return reader.readString();
        }
    };
    public static final TypeAdapter<ByteString> BYTES = new TypeAdapter<ByteString>(FieldEncoding.LENGTH_DELIMITED, ByteString.class){

        @Override
        public int encodedSize(ByteString value) {
            return value.size();
        }

        @Override
        public void write(ProtoWriter writer, ByteString value) throws IOException {
            writer.writeBytes(value);
        }

        @Override
        public ByteString read(ProtoReader reader) throws IOException {
            return reader.readBytes();
        }
    };

    public TypeAdapter(FieldEncoding fieldEncoding, Class<?> javaType) {
        this.fieldEncoding = fieldEncoding;
        this.javaType = javaType;
    }

    static TypeAdapter<?> get(Wire wire, Message.Datatype datatype, Class<? extends Message> messageType, Class<? extends ProtoEnum> enumType) {
        switch (datatype) {
            case BOOL: {
                return BOOL;
            }
            case BYTES: {
                return BYTES;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case ENUM: {
                return wire.enumAdapter(enumType);
            }
            case FIXED32: {
                return FIXED32;
            }
            case FIXED64: {
                return FIXED64;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case MESSAGE: {
                return wire.adapter(messageType);
            }
            case SFIXED32: {
                return SFIXED32;
            }
            case SFIXED64: {
                return SFIXED64;
            }
            case SINT32: {
                return SINT32;
            }
            case SINT64: {
                return SINT64;
            }
            case STRING: {
                return STRING;
            }
            case UINT32: {
                return UINT32;
            }
            case UINT64: {
                return UINT64;
            }
        }
        throw new AssertionError((Object)("Unknown data type " + (Object)((Object)datatype)));
    }

    public E redact(E value) {
        return null;
    }

    public abstract int encodedSize(E var1);

    int serializedSize(int tag, E value) {
        int size = this.encodedSize(value);
        if (this.fieldEncoding == FieldEncoding.LENGTH_DELIMITED) {
            size += ProtoWriter.varint32Size(size);
        }
        return size + ProtoWriter.tagSize(tag);
    }

    public abstract void write(ProtoWriter var1, E var2) throws IOException;

    void writeTagged(ProtoWriter writer, int tag, E value) throws IOException {
        writer.writeTag(tag, this.fieldEncoding);
        if (this.fieldEncoding == FieldEncoding.LENGTH_DELIMITED) {
            writer.writeVarint32(this.encodedSize(value));
        }
        this.write(writer, value);
    }

    public final void write(BufferedSink sink, E value) throws IOException {
        Preconditions.checkNotNull(value, "value == null");
        Preconditions.checkNotNull(sink, "sink == null");
        this.write(new ProtoWriter(sink), value);
    }

    public final byte[] writeBytes(E value) {
        Preconditions.checkNotNull(value, "value == null");
        Buffer buffer = new Buffer();
        try {
            this.write((BufferedSink)buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.readByteArray();
    }

    public final void writeStream(OutputStream stream, E value) throws IOException {
        Preconditions.checkNotNull(value, "value == null");
        Preconditions.checkNotNull(stream, "stream == null");
        BufferedSink buffer = Okio.buffer((Sink)Okio.sink((OutputStream)stream));
        this.write(buffer, value);
        buffer.emit();
    }

    public abstract E read(ProtoReader var1) throws IOException;

    public final E readBytes(byte[] bytes) throws IOException {
        Preconditions.checkNotNull(bytes, "bytes == null");
        return this.read((BufferedSource)new Buffer().write(bytes));
    }

    public final E readStream(InputStream stream) throws IOException {
        Preconditions.checkNotNull(stream, "stream == null");
        return this.read(Okio.buffer((Source)Okio.source((InputStream)stream)));
    }

    public final E read(BufferedSource source) throws IOException {
        Preconditions.checkNotNull(source, "source == null");
        return this.read(new ProtoReader(source));
    }

    public String toString(E value) {
        return value.toString();
    }

    TypeAdapter<?> withLabel(Message.Label label) {
        if (label.isRepeated()) {
            return label.isPacked() ? TypeAdapter.createPacked(this) : TypeAdapter.createRepeated(this);
        }
        return this;
    }

    private static <T> TypeAdapter<List<T>> createPacked(final TypeAdapter<T> adapter) {
        if (adapter.fieldEncoding == FieldEncoding.LENGTH_DELIMITED) {
            throw new IllegalArgumentException("Unable to pack a length-delimited type.");
        }
        return new TypeAdapter<List<T>>(FieldEncoding.LENGTH_DELIMITED, List.class){

            @Override
            public int encodedSize(List<T> value) {
                int size = 0;
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    size += adapter.encodedSize(value.get(i));
                }
                return size;
            }

            @Override
            public void write(ProtoWriter writer, List<T> value) throws IOException {
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    adapter.write(writer, value.get(i));
                }
            }

            @Override
            public List<T> read(ProtoReader reader) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> redact(List<T> value) {
                return Collections.emptyList();
            }
        };
    }

    private static <T> TypeAdapter<List<T>> createRepeated(final TypeAdapter<T> adapter) {
        return new TypeAdapter<List<T>>(adapter.fieldEncoding, List.class){

            @Override
            public int encodedSize(List<T> value) {
                throw new UnsupportedOperationException();
            }

            @Override
            int serializedSize(int tag, List<T> value) {
                int size = 0;
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    size += adapter.serializedSize(tag, value.get(i));
                }
                return size;
            }

            @Override
            public void write(ProtoWriter writer, List<T> value) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            void writeTagged(ProtoWriter writer, int tag, List<T> value) throws IOException {
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    adapter.writeTagged(writer, tag, value.get(i));
                }
            }

            @Override
            public List<T> read(ProtoReader reader) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> redact(List<T> value) {
                return Collections.emptyList();
            }
        };
    }
}

