/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.RuntimeEnumAdapter;
import com.squareup.wire.RuntimeMessageAdapter;
import com.squareup.wire.TypeAdapter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Wire {
    private final ThreadLocal<List<DeferredAdapter<?>>> reentrantCalls = new ThreadLocal();
    private final Map<Class<? extends Message>, RuntimeMessageAdapter<? extends Message>> messageAdapters = new LinkedHashMap<Class<? extends Message>, RuntimeMessageAdapter<? extends Message>>();
    private final Map<Class<? extends ProtoEnum>, RuntimeEnumAdapter<? extends ProtoEnum>> enumAdapters = new LinkedHashMap<Class<? extends ProtoEnum>, RuntimeEnumAdapter<? extends ProtoEnum>>();
    private final Map<Class<? extends Message>, List<Extension<?, ?>>> messageToExtensions = new LinkedHashMap();

    public Wire(Class<?> ... extensionClasses) {
        this(Arrays.asList(extensionClasses));
    }

    public Wire(List<Class<?>> extensionClasses) {
        for (Class<?> extensionClass : extensionClasses) {
            for (Field field : extensionClass.getDeclaredFields()) {
                if (!field.getType().equals(Extension.class)) continue;
                try {
                    this.registerExtension((Extension)field.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    private <T extends ExtendableMessage<T>, E> void registerExtension(Extension<T, E> extension) {
        Class<T> messageClass = extension.getExtendedType();
        List<Extension<?, ?>> extensions = this.messageToExtensions.get(messageClass);
        if (extensions == null) {
            extensions = new ArrayList();
            this.messageToExtensions.put(messageClass, extensions);
        }
        extensions.add(extension);
    }

    List<Extension<?, ?>> getExtensions(Class<? extends Message> messageClass) {
        List<Extension<?, ?>> map = this.messageToExtensions.get(messageClass);
        return map != null ? map : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends Message> TypeAdapter<M> adapter(Class<M> type) {
        List<DeferredAdapter<?>> deferredAdapters = this.reentrantCalls.get();
        if (deferredAdapters == null) {
            deferredAdapters = new ArrayList();
            this.reentrantCalls.set(deferredAdapters);
        } else {
            for (DeferredAdapter<?> deferredAdapter : deferredAdapters) {
                if (!deferredAdapter.javaType.equals(type)) continue;
                return deferredAdapter;
            }
        }
        DeferredAdapter<M> deferredAdapter = new DeferredAdapter<M>(type);
        deferredAdapters.add(deferredAdapter);
        try {
            RuntimeMessageAdapter<M> adapter = this.messageAdapter(type);
            deferredAdapter.ready(adapter);
            RuntimeMessageAdapter<M> runtimeMessageAdapter = adapter;
            return runtimeMessageAdapter;
        }
        finally {
            deferredAdapters.remove(deferredAdapters.size() - 1);
        }
    }

    synchronized <M extends Message> RuntimeMessageAdapter<M> messageAdapter(Class<M> messageType) {
        RuntimeMessageAdapter<Message> adapter = this.messageAdapters.get(messageType);
        if (adapter == null) {
            adapter = new RuntimeMessageAdapter<M>(this, messageType);
            this.messageAdapters.put(messageType, adapter);
        }
        return adapter;
    }

    synchronized <E extends ProtoEnum> RuntimeEnumAdapter<E> enumAdapter(Class<E> enumClass) {
        RuntimeEnumAdapter<ProtoEnum> adapter = this.enumAdapters.get(enumClass);
        if (adapter == null) {
            adapter = new RuntimeEnumAdapter<E>(enumClass);
            this.enumAdapters.put(enumClass, adapter);
        }
        return adapter;
    }

    public static <T> T get(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    private static class DeferredAdapter<M extends Message>
    extends TypeAdapter<M> {
        private TypeAdapter<M> delegate;

        DeferredAdapter(Class<M> type) {
            super(FieldEncoding.LENGTH_DELIMITED, type);
        }

        public void ready(TypeAdapter<M> delegate) {
            this.delegate = delegate;
        }

        @Override
        public M redact(M message) {
            if (this.delegate == null) {
                throw new IllegalStateException("Type adapter isn't ready");
            }
            return (M)((Message)this.delegate.redact(message));
        }

        @Override
        public String toString(M value) {
            if (this.delegate == null) {
                throw new IllegalStateException("Type adapter isn't ready");
            }
            return this.delegate.toString(value);
        }

        @Override
        public int encodedSize(M value) {
            if (this.delegate == null) {
                throw new IllegalStateException("Type adapter isn't ready");
            }
            return this.delegate.encodedSize(value);
        }

        @Override
        public void write(ProtoWriter writer, M value) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException("Type adapter isn't ready");
            }
            this.delegate.write(writer, value);
        }

        @Override
        public M read(ProtoReader reader) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException("Type adapter isn't ready");
            }
            return (M)((Message)this.delegate.read(reader));
        }
    }
}

