/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireEnumConstant;
import com.squareup.wire.internal.JsonFormatter;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/squareup/wire/internal/EnumJsonFormatter;", "E", "Lcom/squareup/wire/WireEnum;", "Lcom/squareup/wire/internal/JsonFormatter;", "adapter", "Lcom/squareup/wire/EnumAdapter;", "(Lcom/squareup/wire/EnumAdapter;)V", "stringToValue", "", "", "valueToString", "fromString", "value", "(Ljava/lang/String;)Lcom/squareup/wire/WireEnum;", "toStringOrNumber", "(Lcom/squareup/wire/WireEnum;)Ljava/lang/String;", "wire-runtime"})
public final class EnumJsonFormatter<E extends WireEnum>
implements JsonFormatter<E> {
    @NotNull
    private final Map<String, E> stringToValue;
    @NotNull
    private final Map<E, String> valueToString;

    public EnumJsonFormatter(@NotNull EnumAdapter<E> adapter2) {
        Intrinsics.checkNotNullParameter(adapter2, (String)"adapter");
        boolean bl = false;
        Map mutableStringToValue = new LinkedHashMap();
        boolean bl2 = false;
        Map mutableValueToString = new LinkedHashMap();
        KClass<?> kClass = adapter2.getType();
        Intrinsics.checkNotNull(kClass);
        Class enumType = JvmClassMappingKt.getJavaClass(kClass);
        T[] TArray = enumType.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"enumType.enumConstants");
        for (WireEnum constant : (WireEnum[])TArray) {
            if (constant == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            String name = ((Enum)((Object)constant)).name();
            Map map = mutableStringToValue;
            Object object = constant;
            boolean bl3 = false;
            map.put(name, object);
            map = mutableStringToValue;
            object = String.valueOf(constant.getValue());
            WireEnum wireEnum = constant;
            boolean bl4 = false;
            map.put(object, wireEnum);
            map = mutableValueToString;
            object = constant;
            boolean bl5 = false;
            map.put(object, name);
            Field constantField = enumType.getDeclaredField(name);
            WireEnumConstant wireEnumConstant = constantField.getAnnotation(WireEnumConstant.class);
            if (wireEnumConstant == null) continue;
            Object object2 = wireEnumConstant.declaredName();
            bl4 = false;
            if (!(object2.length() > 0)) continue;
            object2 = mutableStringToValue;
            Object object3 = wireEnumConstant.declaredName();
            Object object4 = constant;
            boolean bl6 = false;
            object2.put(object3, object4);
            object2 = mutableValueToString;
            object3 = constant;
            object4 = wireEnumConstant.declaredName();
            bl6 = false;
            object2.put(object3, object4);
        }
        this.stringToValue = mutableStringToValue;
        this.valueToString = mutableValueToString;
    }

    @Override
    @Nullable
    public E fromString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (E)((WireEnum)this.stringToValue.get(value));
    }

    @NotNull
    public String toStringOrNumber(@NotNull E value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        String string = this.valueToString.get(value);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }
}

