/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java.internal;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.java.internal.AutoValue_ProfileFileElement;
import com.squareup.wire.java.internal.TypeConfigElement;
import com.squareup.wire.schema.Location;

public abstract class ProfileFileElement {
    public static Builder builder(Location location) {
        return new AutoValue_ProfileFileElement.Builder().location(location).imports((ImmutableList<String>)ImmutableList.of()).typeConfigs((ImmutableList<TypeConfigElement>)ImmutableList.of());
    }

    public abstract Location location();

    public abstract String packageName();

    public abstract ImmutableList<String> imports();

    public abstract ImmutableList<TypeConfigElement> typeConfigs();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        builder.append("// ").append(this.location()).append('\n');
        builder.append("syntax \"wire2\";\n");
        if (this.packageName() != null) {
            builder.append("package ").append(this.packageName()).append(";\n");
        }
        if (!this.imports().isEmpty()) {
            builder.append('\n');
            for (String file : this.imports()) {
                builder.append("import \"").append(file).append("\";\n");
            }
        }
        if (!this.typeConfigs().isEmpty()) {
            builder.append('\n');
            for (TypeConfigElement typeConfigElement : this.typeConfigs()) {
                builder.append(typeConfigElement.toSchema());
            }
        }
        return builder.toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder packageName(String var1);

        public Builder imports(ImmutableList<String> var1);

        public Builder typeConfigs(ImmutableList<TypeConfigElement> var1);

        public ProfileFileElement build();
    }
}

