/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.GrpcCall;
import com.squareup.wire.GrpcMethod;
import com.squareup.wire.GrpcStreamingCall;
import com.squareup.wire.internal.RealGrpcCall;
import com.squareup.wire.internal.RealGrpcStreamingCall;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\f\"\b\b\u0000\u0010\r*\u00020\u0001\"\b\b\u0001\u0010\u000e*\u00020\u00012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0010J\u001d\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J:\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0018\"\b\b\u0000\u0010\r*\u00020\u0001\"\b\b\u0001\u0010\u000e*\u00020\u00012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/squareup/wire/GrpcClient;", "", "client", "Lokhttp3/OkHttpClient;", "baseUrl", "Lokhttp3/HttpUrl;", "(Lokhttp3/OkHttpClient;Lokhttp3/HttpUrl;)V", "getBaseUrl$wire_grpc_client", "()Lokhttp3/HttpUrl;", "getClient$wire_grpc_client", "()Lokhttp3/OkHttpClient;", "newCall", "Lcom/squareup/wire/GrpcCall;", "S", "R", "method", "Lcom/squareup/wire/GrpcMethod;", "Lokhttp3/Call;", "path", "", "requestBody", "Lokhttp3/RequestBody;", "newCall$wire_grpc_client", "newStreamingCall", "Lcom/squareup/wire/GrpcStreamingCall;", "Builder", "wire-grpc-client"})
public final class GrpcClient {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final HttpUrl baseUrl;

    @NotNull
    public final <S, R> GrpcCall<S, R> newCall(@NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        return new RealGrpcCall<S, R>(this, method);
    }

    @NotNull
    public final <S, R> GrpcStreamingCall<S, R> newStreamingCall(@NotNull GrpcMethod<S, R> method) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        return new RealGrpcStreamingCall<S, R>(this, method);
    }

    @NotNull
    public final Call newCall$wire_grpc_client(@NotNull String path, @NotNull RequestBody requestBody) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)requestBody, (String)"requestBody");
        Request.Builder builder = new Request.Builder();
        HttpUrl httpUrl = this.baseUrl.resolve(path);
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        return this.client.newCall(builder.url(httpUrl).addHeader("te", "trailers").addHeader("grpc-trace-bin", "").addHeader("grpc-accept-encoding", "gzip").addHeader("grpc-encoding", "gzip").method("POST", requestBody).build());
    }

    @NotNull
    public final OkHttpClient getClient$wire_grpc_client() {
        return this.client;
    }

    @NotNull
    public final HttpUrl getBaseUrl$wire_grpc_client() {
        return this.baseUrl;
    }

    private GrpcClient(OkHttpClient client, HttpUrl baseUrl) {
        this.client = client;
        this.baseUrl = baseUrl;
    }

    public /* synthetic */ GrpcClient(OkHttpClient client, HttpUrl baseUrl, DefaultConstructorMarker $constructor_marker) {
        this(client, baseUrl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0007J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/squareup/wire/GrpcClient$Builder;", "", "()V", "baseUrl", "Lokhttp3/HttpUrl;", "client", "Lokhttp3/OkHttpClient;", "", "url", "build", "Lcom/squareup/wire/GrpcClient;", "wire-grpc-client"})
    public static final class Builder {
        private OkHttpClient client;
        private HttpUrl baseUrl;

        @NotNull
        public final Builder client(@NotNull OkHttpClient client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            this.client = client;
            return this;
        }

        @NotNull
        public final Builder baseUrl(@NotNull String baseUrl) {
            Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
            this.baseUrl = HttpUrl.Companion.get(baseUrl);
            return this;
        }

        @NotNull
        public final Builder baseUrl(@NotNull HttpUrl url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.baseUrl = url;
            return this;
        }

        @NotNull
        public final GrpcClient build() {
            OkHttpClient okHttpClient = this.client;
            if (okHttpClient == null) {
                Intrinsics.throwNpe();
            }
            HttpUrl httpUrl = this.baseUrl;
            if (httpUrl == null) {
                Intrinsics.throwNpe();
            }
            return new GrpcClient(okHttpClient, httpUrl, null);
        }
    }
}

