/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.RootKt;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/squareup/wire/schema/DirectoryRoot;", "Lcom/squareup/wire/schema/Root;", "base", "", "rootDirectory", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getBase", "()Ljava/lang/String;", "getRootDirectory", "()Ljava/nio/file/Path;", "allProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFilePath;", "resolve", "import", "wire-compiler"})
public final class DirectoryRoot
extends Root {
    @NotNull
    private final String base;
    @NotNull
    private final Path rootDirectory;

    @Override
    @NotNull
    public Set<ProtoFilePath> allProtoFiles() {
        boolean bl = false;
        Set result = new LinkedHashSet();
        Files.walkFileTree(this.rootDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, result){
            final /* synthetic */ DirectoryRoot this$0;
            final /* synthetic */ Set $result;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path descendant, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)descendant, (String)"descendant");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                if (RootKt.access$endsWithDotProto(descendant)) {
                    Location location = Location.Companion.get(this.this$0.getBase(), String.valueOf(this.this$0.getRootDirectory().relativize(descendant)));
                    this.$result.add(new ProtoFilePath(location, descendant));
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
            }
        });
        return result;
    }

    @Override
    @Nullable
    public ProtoFilePath resolve(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"import");
        Path resolved = this.rootDirectory.resolve(string);
        if (!Files.exists(resolved, new LinkOption[0])) {
            return null;
        }
        Location location = Location.Companion.get(this.base, string);
        Path path = resolved;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"resolved");
        return new ProtoFilePath(location, path);
    }

    @NotNull
    public final String getBase() {
        return this.base;
    }

    @NotNull
    public final Path getRootDirectory() {
        return this.rootDirectory;
    }

    public DirectoryRoot(@NotNull String base, @NotNull Path rootDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)rootDirectory, (String)"rootDirectory");
        super(null);
        this.base = base;
        this.rootDirectory = rootDirectory;
    }
}

