/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import com.squareup.wire.Message;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okio.ByteString;

public final class JavaGenerator {
    public static final ClassName BYTE_STRING = ClassName.get(ByteString.class);
    public static final ClassName STRING = ClassName.get(String.class);
    public static final ClassName LIST = ClassName.get(List.class);
    public static final ClassName MESSAGE = ClassName.get(Message.class);
    public static final ClassName EXTENDABLE_MESSAGE = ClassName.get(ExtendableMessage.class);
    public static final ClassName BUILDER = ClassName.get(Message.Builder.class);
    public static final ClassName EXTENDABLE_BUILDER = ClassName.get(ExtendableMessage.ExtendableBuilder.class);
    public static final ClassName EXTENSION = ClassName.get(Extension.class);
    public static final TypeName MESSAGE_OPTIONS = ClassName.get((String)"com.google.protobuf", (String)"MessageOptions", (String[])new String[0]);
    public static final TypeName FIELD_OPTIONS = ClassName.get((String)"com.google.protobuf", (String)"FieldOptions", (String[])new String[0]);
    public static final TypeName ENUM_OPTIONS = ClassName.get((String)"com.google.protobuf", (String)"EnumOptions", (String[])new String[0]);
    private static final Map<Type.Name, TypeName> SCALAR_TYPES_MAP = ImmutableMap.builder().put((Object)Type.Name.BOOL, (Object)TypeName.BOOLEAN.box()).put((Object)Type.Name.BYTES, (Object)ClassName.get(ByteString.class)).put((Object)Type.Name.DOUBLE, (Object)TypeName.DOUBLE.box()).put((Object)Type.Name.FLOAT, (Object)TypeName.FLOAT.box()).put((Object)Type.Name.FIXED32, (Object)TypeName.INT.box()).put((Object)Type.Name.FIXED64, (Object)TypeName.LONG.box()).put((Object)Type.Name.INT32, (Object)TypeName.INT.box()).put((Object)Type.Name.INT64, (Object)TypeName.LONG.box()).put((Object)Type.Name.SFIXED32, (Object)TypeName.INT.box()).put((Object)Type.Name.SFIXED64, (Object)TypeName.LONG.box()).put((Object)Type.Name.SINT32, (Object)TypeName.INT.box()).put((Object)Type.Name.SINT64, (Object)TypeName.LONG.box()).put((Object)Type.Name.STRING, (Object)ClassName.get(String.class)).put((Object)Type.Name.UINT32, (Object)TypeName.INT.box()).put((Object)Type.Name.UINT64, (Object)TypeName.LONG.box()).build();
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private final Schema schema;
    private final ImmutableMap<Type.Name, TypeName> nameToJavaName;
    private final ImmutableMap<Field, ProtoFile> extensionFieldToFile;

    private JavaGenerator(Schema schema, ImmutableMap<Type.Name, TypeName> nameToJavaName, ImmutableMap<Field, ProtoFile> extensionFieldToFile) {
        this.schema = schema;
        this.nameToJavaName = nameToJavaName;
        this.extensionFieldToFile = extensionFieldToFile;
    }

    public static JavaGenerator get(Schema schema) {
        ImmutableMap.Builder nameToJavaName = ImmutableMap.builder();
        ImmutableMap.Builder extensionFieldToFile = ImmutableMap.builder();
        nameToJavaName.putAll(SCALAR_TYPES_MAP);
        for (ProtoFile protoFile : schema.protoFiles()) {
            String javaPackage = JavaGenerator.javaPackage(protoFile);
            JavaGenerator.putAll((ImmutableMap.Builder<Type.Name, TypeName>)nameToJavaName, javaPackage, null, (List<Type>)protoFile.types());
            for (Extend extend : protoFile.extendList()) {
                for (Field field : extend.fields()) {
                    extensionFieldToFile.put((Object)field, (Object)protoFile);
                }
            }
            for (Service service : protoFile.services()) {
                ClassName className = ClassName.get((String)javaPackage, (String)service.name().simpleName(), (String[])new String[0]);
                nameToJavaName.put((Object)service.name(), (Object)className);
            }
        }
        return new JavaGenerator(schema, (ImmutableMap<Type.Name, TypeName>)nameToJavaName.build(), (ImmutableMap<Field, ProtoFile>)extensionFieldToFile.build());
    }

    private static void putAll(ImmutableMap.Builder<Type.Name, TypeName> wireToJava, String javaPackage, ClassName enclosingClassName, List<Type> types) {
        for (Type type : types) {
            ClassName className = enclosingClassName != null ? enclosingClassName.nestedClass(type.name().simpleName()) : ClassName.get((String)javaPackage, (String)type.name().simpleName(), (String[])new String[0]);
            wireToJava.put((Object)type.name(), (Object)className);
            JavaGenerator.putAll(wireToJava, javaPackage, className, (List<Type>)type.nestedTypes());
        }
    }

    public ClassName extensionsClass(ProtoFile protoFile) {
        return ClassName.get((String)JavaGenerator.javaPackage(protoFile), (String)("Ext_" + protoFile.name()), (String[])new String[0]);
    }

    public ClassName extensionsClass(Field field) {
        ProtoFile protoFile = (ProtoFile)this.extensionFieldToFile.get((Object)field);
        return protoFile != null ? this.extensionsClass(protoFile) : null;
    }

    public TypeName typeName(Type.Name name) {
        TypeName candidate = (TypeName)this.nameToJavaName.get((Object)name);
        Preconditions.checkArgument((candidate != null ? 1 : 0) != 0, (String)"unexpected type %s", (Object[])new Object[]{name});
        return candidate;
    }

    private static String javaPackage(ProtoFile protoFile) {
        Object javaPackageOption = protoFile.options().get("java_package");
        if (javaPackageOption != null) {
            return String.valueOf(javaPackageOption);
        }
        if (protoFile.packageName() != null) {
            return protoFile.packageName();
        }
        return "";
    }

    public boolean isEnum(Type.Name type) {
        Type wireType = this.schema.getType(type);
        return wireType instanceof EnumType;
    }

    public EnumConstant enumDefault(Type.Name type) {
        EnumType wireEnum = (EnumType)this.schema.getType(type);
        return (EnumConstant)wireEnum.constants().get(0);
    }

    public static TypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)LIST, (TypeName[])new TypeName[]{type});
    }

    public static TypeName extendableMessageOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)EXTENDABLE_MESSAGE, (TypeName[])new TypeName[]{type});
    }

    public static TypeName builderOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)BUILDER, (TypeName[])new TypeName[]{messageType});
    }

    public static TypeName extendableBuilderOf(TypeName messageType, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)EXTENDABLE_BUILDER, (TypeName[])new TypeName[]{messageType, builderType});
    }

    public static TypeName extensionOf(TypeName messageType, TypeName fieldType) {
        return ParameterizedTypeName.get((ClassName)EXTENSION, (TypeName[])new TypeName[]{messageType, fieldType});
    }

    public static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public static interface IO {
        public static final IO DEFAULT = new IO(){

            @Override
            public void write(File outputDirectory, JavaFile javaFile) throws IOException {
                javaFile.writeTo(outputDirectory);
            }
        };

        public void write(File var1, JavaFile var2) throws IOException;
    }
}

