/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireException;
import com.squareup.wire.java.ServiceFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;

final class CommandLineOptions {
    public static final String PROTO_PATH_FLAG = "--proto_path=";
    public static final String JAVA_OUT_FLAG = "--java_out=";
    public static final String FILES_FLAG = "--files=";
    public static final String ROOTS_FLAG = "--roots=";
    public static final String REGISTRY_CLASS_FLAG = "--registry_class=";
    public static final String NO_OPTIONS_FLAG = "--no_options";
    public static final String ENUM_OPTIONS_FLAG = "--enum_options=";
    public static final String SERVICE_FACTORY_FLAG = "--service_factory=";
    public static final String SERVICE_FACTORY_OPT_FLAG = "--service_factory_opt=";
    public static final String QUIET_FLAG = "--quiet";
    public static final String DRY_RUN_FLAG = "--dry_run";
    final List<String> protoPaths;
    final File javaOut;
    final List<String> sourceFileNames;
    final List<String> roots;
    final String registryClass;
    final boolean emitOptions;
    final Set<String> enumOptions;
    final ServiceFactory serviceFactory;
    final List<String> serviceFactoryOptions;
    final boolean quiet;
    final boolean dryRun;

    CommandLineOptions(String protoPath, File javaOut, List<String> sourceFileNames, List<String> roots, String registryClass, boolean emitOptions, Set<String> enumOptions, ServiceFactory serviceFactory, List<String> serviceFactoryOptions, boolean quiet, boolean dryRun) {
        this.protoPaths = Arrays.asList(protoPath);
        this.javaOut = javaOut;
        this.sourceFileNames = sourceFileNames;
        this.roots = roots;
        this.registryClass = registryClass;
        this.emitOptions = emitOptions;
        this.enumOptions = enumOptions;
        this.serviceFactory = serviceFactory;
        this.serviceFactoryOptions = serviceFactoryOptions;
        this.quiet = quiet;
        this.dryRun = dryRun;
    }

    CommandLineOptions(String ... args) throws WireException {
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        ArrayList<String> serviceFactoryOptions = new ArrayList<String>();
        ArrayList<String> roots = new ArrayList<String>();
        boolean emitOptions = true;
        ArrayList<String> protoPaths = new ArrayList<String>();
        File javaOut = null;
        String registryClass = null;
        ArrayList<String> enumOptionsList = new ArrayList<String>();
        ServiceFactory serviceFactory = null;
        boolean quiet = false;
        boolean dryRun = false;
        for (int index = 0; index < args.length; ++index) {
            if (args[index].startsWith(PROTO_PATH_FLAG)) {
                protoPaths.add(args[index].substring(PROTO_PATH_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(JAVA_OUT_FLAG)) {
                javaOut = new File(args[index].substring(JAVA_OUT_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(FILES_FLAG)) {
                String[] fileNames;
                File files = new File(args[index].substring(FILES_FLAG.length()));
                try {
                    fileNames = new Scanner(files, "UTF-8").useDelimiter("\\A").next().split("\n");
                }
                catch (FileNotFoundException ex) {
                    throw new WireException("Error processing argument " + args[index], ex);
                }
                sourceFileNames.addAll(Arrays.asList(fileNames));
                continue;
            }
            if (args[index].startsWith(ROOTS_FLAG)) {
                roots.addAll(CommandLineOptions.splitArg(args[index], ROOTS_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(REGISTRY_CLASS_FLAG)) {
                registryClass = args[index].substring(REGISTRY_CLASS_FLAG.length());
                continue;
            }
            if (args[index].equals(NO_OPTIONS_FLAG)) {
                emitOptions = false;
                continue;
            }
            if (args[index].startsWith(ENUM_OPTIONS_FLAG)) {
                enumOptionsList.addAll(CommandLineOptions.splitArg(args[index], ENUM_OPTIONS_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(SERVICE_FACTORY_FLAG)) {
                String serviceFactoryClassName = args[index].substring(SERVICE_FACTORY_FLAG.length());
                serviceFactory = this.loadServiceFactory(serviceFactoryClassName);
                continue;
            }
            if (args[index].startsWith(SERVICE_FACTORY_OPT_FLAG)) {
                serviceFactoryOptions.add(args[index].substring(SERVICE_FACTORY_OPT_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(QUIET_FLAG)) {
                quiet = true;
                continue;
            }
            if (args[index].startsWith(DRY_RUN_FLAG)) {
                dryRun = true;
                continue;
            }
            sourceFileNames.add(args[index]);
        }
        this.protoPaths = protoPaths;
        this.javaOut = javaOut;
        this.sourceFileNames = sourceFileNames;
        this.roots = roots;
        this.registryClass = registryClass;
        this.emitOptions = emitOptions;
        this.enumOptions = new LinkedHashSet<String>(enumOptionsList);
        this.serviceFactory = serviceFactory;
        this.serviceFactoryOptions = serviceFactoryOptions;
        this.quiet = quiet;
        this.dryRun = dryRun;
    }

    private ServiceFactory loadServiceFactory(String className) throws WireException {
        try {
            Class<?> serviceFactoryClass = Class.forName(className);
            return (ServiceFactory)serviceFactoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new WireException("Failed to load ServiceFactory: " + className, e);
        }
        catch (ClassCastException e) {
            throw new WireException("Class " + className + " does not implement ServiceFactory interface.");
        }
        catch (InstantiationException e) {
            throw new WireException("Failed to instantiate ServiceFactory: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new WireException("Failed to access ServiceFactory: " + className, e);
        }
    }

    private static List<String> splitArg(String arg, int flagLength) {
        return Arrays.asList(arg.substring(flagLength).split(","));
    }

    public List<String> protoPaths() {
        List<String> result = this.protoPaths;
        if (result == null || result.isEmpty()) {
            result = Arrays.asList(System.getProperty("user.dir"));
            System.err.println("--proto_path= flag not specified, using current dir " + result);
        }
        return result;
    }
}

