/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import java.io.File;

final class OutputArtifact {
    private final String outputDirectory;
    private final String className;
    private final String javaPackage;

    public OutputArtifact(String outputDirectory, String javaPackage, String className) {
        this.outputDirectory = outputDirectory;
        this.className = className;
        this.javaPackage = javaPackage;
    }

    public String outputDirectory() {
        return this.outputDirectory;
    }

    public String className() {
        return this.className;
    }

    public String javaPackage() {
        return this.javaPackage;
    }

    public File file() {
        String dir = this.outputDirectory + File.separator + this.javaPackage.replace(".", File.separator);
        return new File(dir, this.className + ".java");
    }

    public File dir() {
        return this.file().getParentFile();
    }

    public String fullClassName() {
        return this.javaPackage + "." + this.className;
    }
}

