/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.RpcElement;
import com.squareup.protoparser.ServiceElement;
import com.squareup.wire.ServiceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.element.Modifier;

abstract class AbstractServiceWriter
extends ServiceWriter {
    public AbstractServiceWriter(JavaWriter writer, List<String> options) {
        super(writer, options);
    }

    @Override
    public void emitService(ServiceElement service, Set<String> importedTypes) throws IOException {
        importedTypes.addAll(this.getImports(service));
        this.writer.emitImports(importedTypes);
        this.writer.emitEmptyLine();
        if (!service.documentation().isEmpty()) {
            this.writer.emitJavadoc(service.documentation(), new Object[0]);
        }
        this.writer.beginType(service.name(), "interface", EnumSet.of(Modifier.PUBLIC));
        for (RpcElement rpc : service.rpcs()) {
            String requestType = rpc.requestType().toString();
            int index = requestType.lastIndexOf(46);
            if (index != -1) {
                requestType = requestType.substring(index + 1);
            }
            if (!rpc.documentation().isEmpty()) {
                this.writer.emitJavadoc(rpc.documentation(), new Object[0]);
            }
            this.emitAnnotation(service, rpc);
            this.writer.beginMethod(rpc.responseType().toString(), this.getRpcName(rpc), EnumSet.noneOf(Modifier.class), Arrays.asList(this.getRequestType(requestType), this.getRequestName(requestType)), this.getThrows());
            this.writer.endMethod();
        }
        this.writer.endType();
    }

    List<String> getImports(ServiceElement service) {
        return null;
    }

    void emitAnnotation(ServiceElement service, RpcElement rpc) throws IOException {
    }

    String getRpcName(RpcElement rpc) {
        return this.lowerCaseInitialLetter(rpc.name());
    }

    String getRequestName(String requestType) {
        return this.lowerCaseInitialLetter(requestType);
    }

    String lowerCaseInitialLetter(String name) {
        return name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
    }

    String getRequestType(String baseType) {
        return baseType;
    }

    List<String> getThrows() {
        return null;
    }
}

