/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.ExtendDeclaration;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.Type;
import com.squareup.wire.ExtensionInfo;
import com.squareup.wire.FieldInfo;
import com.squareup.wire.IO;
import com.squareup.wire.Message;
import com.squareup.wire.MessageOptionsMapMaker;
import com.squareup.wire.MessageWriter;
import com.squareup.wire.Stringer;
import com.squareup.wire.TypeInfo;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;

public class WireCompiler {
    static final String INDENT = "  ";
    static final String LINE_WRAP_INDENT = "    ";
    private static final Charset ISO_8859_1 = Charset.forName("ISO_8859_1");
    private static final String PROTO_PATH_FLAG = "--proto_path=";
    private static final String JAVA_OUT_FLAG = "--java_out=";
    private static final String FILES_FLAG = "--files=";
    private static final String REGISTRY_CLASS_FLAG = "--registry_class=";
    private static final String ROOTS_FLAG = "--roots=";
    private static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private final String repoPath;
    private final List<String> sourceFileNames;
    private final IO io;
    private final Set<String> typesToEmit = new LinkedHashSet<String>();
    private final Map<String, String> javaSymbolMap = new LinkedHashMap<String, String>();
    private final Set<String> enumTypes = new LinkedHashSet<String>();
    private final Map<String, String> enumDefaults = new LinkedHashMap<String, String>();
    private final Map<String, ExtensionInfo> extensionInfo = new LinkedHashMap<String, ExtensionInfo>();
    private final Map<String, FieldInfo> fieldMap = new LinkedHashMap<String, FieldInfo>();
    private final String outputDirectory;
    private final String registryClass;
    private final List<String> extensionClasses = new ArrayList<String>();
    private final MessageOptionsMapMaker messageOptionsMapMaker = new MessageOptionsMapMaker(this);
    private ProtoFile protoFile;
    private JavaWriter writer;
    private String sourceFileName;
    private String protoFileName;
    private String typeBeingGenerated = "";

    public static void main(String ... args) throws Exception {
        String protoPath = null;
        String javaOut = null;
        String registryClass = null;
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        ArrayList<String> roots = new ArrayList<String>();
        for (int index = 0; index < args.length; ++index) {
            if (args[index].startsWith(PROTO_PATH_FLAG)) {
                protoPath = args[index].substring(PROTO_PATH_FLAG.length());
                continue;
            }
            if (args[index].startsWith(JAVA_OUT_FLAG)) {
                javaOut = args[index].substring(JAVA_OUT_FLAG.length());
                continue;
            }
            if (args[index].startsWith(FILES_FLAG)) {
                File files = new File(args[index].substring(FILES_FLAG.length()));
                String[] fileNames = new Scanner(files, "UTF-8").useDelimiter("\\A").next().split("\n");
                sourceFileNames.addAll(Arrays.asList(fileNames));
                continue;
            }
            if (args[index].startsWith(ROOTS_FLAG)) {
                roots.addAll(Arrays.asList(args[index].substring(ROOTS_FLAG.length()).split(",")));
                continue;
            }
            if (args[index].startsWith(REGISTRY_CLASS_FLAG)) {
                registryClass = args[index].substring(REGISTRY_CLASS_FLAG.length());
                continue;
            }
            sourceFileNames.add(args[index]);
        }
        if (javaOut == null) {
            System.err.println("Must specify --java_out= flag");
            System.exit(1);
        }
        if (protoPath == null) {
            protoPath = System.getProperty("user.dir");
            System.err.println("--proto_path= flag not specified, using current dir " + protoPath);
        }
        WireCompiler wireCompiler = new WireCompiler(protoPath, sourceFileNames, roots, javaOut, registryClass);
        wireCompiler.compile();
    }

    public WireCompiler(String protoPath, List<String> sourceFileNames, List<String> roots, String outputDirectory, String registryClass) {
        this(protoPath, sourceFileNames, roots, outputDirectory, registryClass, new IO.FileIO());
    }

    WireCompiler(String protoPath, List<String> sourceFileNames, List<String> roots, String outputDirectory, String registryClass, IO io) {
        this.repoPath = protoPath;
        this.typesToEmit.addAll(roots);
        this.sourceFileNames = sourceFileNames;
        this.outputDirectory = outputDirectory;
        this.registryClass = registryClass;
        this.io = io;
    }

    public void compile() throws IOException {
        LinkedHashMap<String, ProtoFile> parsedFiles = new LinkedHashMap<String, ProtoFile>();
        for (String string : this.sourceFileNames) {
            String sourcePath = this.repoPath + File.separator + string;
            ProtoFile protoFile = this.io.parse(sourcePath);
            parsedFiles.put(sourcePath, protoFile);
            this.loadSymbols(protoFile);
        }
        if (!this.typesToEmit.isEmpty()) {
            System.out.println("Analyzing dependencies of root types.");
            this.findDependencies(parsedFiles.values());
        }
        for (Map.Entry entry : parsedFiles.entrySet()) {
            this.sourceFileName = (String)entry.getKey();
            this.protoFile = (ProtoFile)entry.getValue();
            this.protoFileName = this.protoFileName(this.protoFile.getFileName());
            System.out.println("Compiling proto source file " + this.sourceFileName);
            this.compileOne();
        }
        if (this.registryClass != null) {
            this.emitRegistry();
        }
    }

    ProtoFile getProtoFile() {
        return this.protoFile;
    }

    MessageOptionsMapMaker getMessageOptionsMapMaker() {
        return this.messageOptionsMapMaker;
    }

    JavaWriter getWriter() {
        return this.writer;
    }

    String getEnumDefault(String fullyQualifiedName) {
        return this.enumDefaults.get(fullyQualifiedName);
    }

    FieldInfo getField(String dollarName) {
        return this.fieldMap.get(dollarName);
    }

    String javaName(ProtoFile protoFile, MessageType messageType, String type) {
        String scalarType = TypeInfo.scalarType(type);
        return scalarType != null ? scalarType : this.shortenJavaName(protoFile, this.javaName(this.fullyQualifiedName(protoFile, messageType, type)));
    }

    boolean fullyQualifiedNameIsOutsidePackage(String fqName) {
        return fqName != null && !this.protoFile.getJavaPackage().equals(this.getPackageFromFullyQualifiedJavaName(fqName));
    }

    String prefixWithPackageName(String name) {
        return this.prefixWithPackageName(this.protoFile, name);
    }

    boolean hasFields(Type type) {
        return type instanceof MessageType && !((MessageType)type).getFields().isEmpty();
    }

    boolean hasExtensions(MessageType messageType) {
        return !messageType.getExtensions().isEmpty();
    }

    String getTrailingSegment(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(index + 1);
    }

    ExtensionInfo getExtension(String name) {
        return this.extensionInfo.get(name);
    }

    String getInitializerForType(String initialValue, String javaTypeName) {
        if ("Boolean".equals(javaTypeName)) {
            return initialValue == null ? "false" : initialValue;
        }
        if ("Integer".equals(javaTypeName)) {
            return initialValue == null ? "0" : this.toInt(initialValue);
        }
        if ("Long".equals(javaTypeName)) {
            return initialValue == null ? "0L" : this.toLong(initialValue) + "L";
        }
        if ("Float".equals(javaTypeName)) {
            return initialValue == null ? "0F" : initialValue + "F";
        }
        if ("Double".equals(javaTypeName)) {
            return initialValue == null ? "0D" : initialValue + "D";
        }
        if ("String".equals(javaTypeName)) {
            return this.quoteString(initialValue);
        }
        if ("ByteString".equals(javaTypeName)) {
            if (initialValue == null) {
                return "ByteString.EMPTY";
            }
            return "ByteString.of(\"" + Stringer.encode((byte[])initialValue.getBytes(ISO_8859_1)) + "\")";
        }
        throw new IllegalArgumentException(javaTypeName + " is not an allowed scalar type");
    }

    boolean isEnum(String type) {
        return this.enumTypes.contains(type);
    }

    String javaName(MessageType messageType, String type) {
        String scalarType = TypeInfo.scalarType(type);
        return scalarType != null ? scalarType : this.shortenJavaName(this.javaName(this.fullyQualifiedName(messageType, type)));
    }

    String javaName(String fqName) {
        return this.javaSymbolMap.get(fqName);
    }

    String fullyQualifiedName(MessageType messageType, String type) {
        return this.fullyQualifiedName(this.protoFile, messageType, type);
    }

    String shortenJavaName(String fullyQualifiedName) {
        return this.shortenJavaName(this.protoFile, fullyQualifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileOne() throws IOException {
        this.typeBeingGenerated = "";
        if (this.hasExtends()) {
            try {
                String className = "Ext_" + this.protoFileName;
                String javaPackage = this.protoFile.getJavaPackage();
                this.writer = this.io.getJavaWriter(this.outputDirectory, javaPackage, className);
                this.emitExtensionClass();
                String extensionClass = javaPackage + "." + className;
                System.out.println("wrote extension class " + extensionClass);
                this.extensionClasses.add(extensionClass);
            }
            finally {
                this.writer.close();
            }
        }
        for (Type type : this.protoFile.getTypes()) {
            if (!this.shouldEmitType(type.getFullyQualifiedName())) continue;
            String savedType = this.typeBeingGenerated;
            this.typeBeingGenerated = this.typeBeingGenerated + type.getName() + ".";
            this.emitMessageClass(type);
            this.typeBeingGenerated = savedType;
        }
    }

    private boolean hasMessageOption(List<Type> types) {
        for (Type type : types) {
            if (!(type instanceof MessageType) || ((MessageType)type).getOptions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void getTypes(Type parent, List<Type> types) {
        types.add(parent);
        for (Type nestedType : parent.getNestedTypes()) {
            this.getTypes(nestedType, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitRegistry() throws IOException {
        int packageClassSep = this.registryClass.lastIndexOf(".");
        String javaPackage = this.registryClass.substring(0, packageClassSep);
        String className = this.registryClass.substring(packageClassSep + 1);
        try {
            this.writer = this.io.getJavaWriter(this.outputDirectory, javaPackage, className);
            this.writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
            this.writer.emitPackage(javaPackage);
            this.writer.emitImports(new String[]{"java.util.List"});
            this.writer.emitEmptyLine();
            this.writer.emitStaticImports(new String[]{"java.util.Arrays.asList", "java.util.Collections.unmodifiableList"});
            this.writer.emitEmptyLine();
            this.writer.beginType(className, "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
            this.writer.emitEmptyLine();
            StringBuilder classes = new StringBuilder("unmodifiableList(asList(\n");
            int extensionsCount = this.extensionClasses.size();
            for (int i = 0; i < extensionsCount; ++i) {
                String format = i < extensionsCount - 1 ? "%1$s%2$s.class,%n" : "%1$s%2$s.class";
                String extensionClass = this.extensionClasses.get(i);
                classes.append(String.format(format, "      ", extensionClass));
            }
            classes.append("))");
            this.writer.emitField("List<Class<?>>", "EXTENSIONS", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), classes.toString());
            this.writer.emitEmptyLine();
            this.writer.beginMethod(null, className, EnumSet.of(Modifier.PRIVATE), new String[0]);
            this.writer.endMethod();
            this.writer.endType();
        }
        finally {
            this.writer.close();
        }
    }

    private boolean shouldEmitType(String name) {
        return this.typesToEmit.isEmpty() || this.typesToEmit.contains(name);
    }

    private void findDependencies(Collection<ProtoFile> protoFiles) throws IOException {
        LinkedHashSet<String> loadedDependencies = new LinkedHashSet<String>();
        int count = this.typesToEmit.size();
        while (true) {
            for (ProtoFile protoFile : protoFiles) {
                this.findDependenciesHelper(protoFile, loadedDependencies);
            }
            int newCount = this.typesToEmit.size();
            if (newCount == count) break;
            count = newCount;
        }
    }

    private void findDependenciesHelper(ProtoFile protoFile, Set<String> loadedDependencies) throws IOException {
        for (String dependency : protoFile.getDependencies()) {
            if (loadedDependencies.contains(dependency)) continue;
            String dep = this.repoPath + File.separator + dependency;
            ProtoFile dependencyFile = this.io.parse(dep);
            this.loadSymbols(dependencyFile);
            loadedDependencies.add(dependency);
        }
        for (ExtendDeclaration extend : protoFile.getExtendDeclarations()) {
            String typeName = extend.getFullyQualifiedName();
            this.typesToEmit.add(typeName);
            for (MessageType.Field field : extend.getFields()) {
                String fieldTypeName = this.prefixWithPackageName(protoFile, field.getType());
                this.typesToEmit.add(fieldTypeName);
            }
        }
        this.addDependencies(protoFile.getTypes(), protoFile.getJavaPackage() + ".");
    }

    private void addDependencies(List<Type> types, String javaPrefix) {
        for (Type type : types) {
            String name = type.getName();
            String fqName = type.getFullyQualifiedName();
            if (type instanceof MessageType && this.typesToEmit.contains(fqName)) {
                for (MessageType.Field field : ((MessageType)type).getFields()) {
                    String fieldType = field.getType();
                    if (TypeInfo.isScalar(fieldType)) continue;
                    String fqFieldType = this.fullyQualifiedName((MessageType)type, field.getType());
                    this.addDependencyBranch(fqFieldType);
                }
            }
            this.addDependencies(type.getNestedTypes(), javaPrefix + name + ".");
        }
    }

    private void addDependencyBranch(String name) {
        while (this.typeIsComplete(name)) {
            this.typesToEmit.add(name);
            name = this.removeTrailingSegment(name);
        }
    }

    private String removeTrailingSegment(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    private void loadSymbols(ProtoFile protoFile) throws IOException {
        this.loadSymbolsHelper(protoFile, new LinkedHashSet<String>(), LoadSymbolsPass.LOAD_TYPES);
        this.loadSymbolsHelper(protoFile, new LinkedHashSet<String>(), LoadSymbolsPass.LOAD_FIELDS);
    }

    private void loadSymbolsHelper(ProtoFile protoFile, Set<String> loadedDependencies, LoadSymbolsPass pass) throws IOException {
        for (String dependency : protoFile.getDependencies()) {
            if (loadedDependencies.contains(dependency)) continue;
            String dep = this.repoPath + File.separator + dependency;
            ProtoFile dependencyFile = this.io.parse(dep);
            this.loadSymbolsHelper(dependencyFile, loadedDependencies, pass);
            loadedDependencies.add(dependency);
        }
        this.addTypes(protoFile.getTypes(), protoFile.getJavaPackage() + ".", pass);
        this.addExtensions(protoFile);
    }

    private void addExtensions(ProtoFile protoFile) {
        for (ExtendDeclaration extend : protoFile.getExtendDeclarations()) {
            for (MessageType.Field field : extend.getFields()) {
                boolean isEnum;
                String fieldType = field.getType();
                String type = this.javaName(protoFile, null, fieldType);
                if (type == null) {
                    type = this.javaName(protoFile, null, this.prefixWithPackageName(protoFile, fieldType));
                }
                type = this.shortenJavaName(protoFile, type);
                String fqName = this.prefixWithPackageName(protoFile, field.getName());
                boolean isScalar = TypeInfo.isScalar(fieldType);
                boolean bl = isEnum = !isScalar && this.isEnum(this.fullyQualifiedName(protoFile, null, fieldType));
                String fqType = isScalar ? (type = field.getType()) : (isEnum ? (type = this.fullyQualifiedName(protoFile, null, fieldType)) : this.fullyQualifiedName(protoFile, null, fieldType));
                String location = this.protoFileName(protoFile.getFileName());
                String fqLocation = protoFile.getJavaPackage() + ".Ext_" + location;
                ExtensionInfo info = new ExtensionInfo(type, fqType, location, fqLocation, field.getLabel());
                this.extensionInfo.put(fqName, info);
            }
        }
    }

    private void addTypes(List<Type> types, String javaPrefix, LoadSymbolsPass pass) {
        for (Type type : types) {
            String name = type.getName();
            if (pass == LoadSymbolsPass.LOAD_TYPES) {
                String fqName = type.getFullyQualifiedName();
                this.javaSymbolMap.put(fqName, javaPrefix + name);
                if (type instanceof EnumType) {
                    this.enumTypes.add(fqName);
                    this.enumDefaults.put(fqName, ((EnumType.Value)((EnumType)type).getValues().get(0)).getName());
                }
            } else if (type instanceof MessageType) {
                this.addFields((MessageType)type);
            }
            this.addTypes(type.getNestedTypes(), javaPrefix + name + ".", pass);
        }
    }

    private void addFields(MessageType messageType) {
        for (MessageType.Field field : messageType.getFields()) {
            String fieldType = field.getType();
            String fqMessageName = messageType.getFullyQualifiedName();
            String key = fqMessageName + "$" + field.getName();
            this.fieldMap.put(key, new FieldInfo(TypeInfo.isScalar(fieldType) ? fieldType : this.fullyQualifiedName(messageType, fieldType), field.getLabel()));
        }
    }

    private String fullyQualifiedName(ProtoFile protoFile, MessageType messageType, String type) {
        String prefix;
        if (this.typeIsComplete(type)) {
            return type;
        }
        String string = prefix = messageType == null ? protoFile.getPackageName() : messageType.getFullyQualifiedName();
        while (!prefix.isEmpty()) {
            String fqname = prefix + "." + type;
            if (this.typeIsComplete(fqname)) {
                return fqname;
            }
            prefix = this.removeTrailingSegment(prefix);
        }
        throw new RuntimeException("Unknown type " + type + " in message " + (messageType == null ? "<unknown>" : messageType.getName()));
    }

    private String shortenJavaName(ProtoFile protoFile, String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        String javaTypeBeingGenerated = protoFile.getJavaPackage() + "." + this.typeBeingGenerated;
        if (fullyQualifiedName.startsWith(javaTypeBeingGenerated)) {
            return fullyQualifiedName.substring(javaTypeBeingGenerated.length());
        }
        for (String javaSymbol : this.javaSymbolMap.values()) {
            if (!fullyQualifiedName.startsWith(javaSymbol)) continue;
            String pkgPrefix = this.getPackageFromFullyQualifiedJavaName(fullyQualifiedName) + '.';
            return fullyQualifiedName.substring(pkgPrefix.length());
        }
        return fullyQualifiedName;
    }

    private String protoFileName(String path) {
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex != -1) {
            path = path.substring(slashIndex + 1);
        }
        if (path.endsWith(".proto")) {
            path = path.substring(0, path.length() - ".proto".length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitMessageClass(Type type) throws IOException {
        try {
            this.writer = this.io.getJavaWriter(this.outputDirectory, this.protoFile.getJavaPackage(), type.getName());
            this.writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
            this.writer.emitSingleLineComment("Source file: %s", new Object[]{this.sourceFileName});
            this.writer.emitPackage(this.protoFile.getJavaPackage());
            ArrayList<Type> types = new ArrayList<Type>();
            this.getTypes(type, types);
            boolean hasMessage = this.hasMessage(types);
            boolean hasExtensions = this.hasExtensions(Arrays.asList(type));
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            if (hasMessage) {
                imports.add("com.squareup.wire.Message");
            }
            if ((hasMessage || hasExtensions) && this.hasFields(type)) {
                imports.add("com.squareup.wire.ProtoField");
            }
            if (this.hasBytesField(types)) {
                imports.add("com.squareup.wire.ByteString");
            }
            if (this.hasEnum(types)) {
                imports.add("com.squareup.wire.ProtoEnum");
            }
            if (this.hasRepeatedField(types)) {
                imports.add("java.util.Collections");
                imports.add("java.util.List");
            }
            if (hasExtensions) {
                imports.add("com.squareup.wire.ExtendableMessage");
                imports.add("com.squareup.wire.Extension");
            }
            if (this.hasMessageOption(types)) {
                imports.add("com.google.protobuf.MessageOptions");
            }
            ArrayList<String> externalTypes = new ArrayList<String>();
            this.getExternalTypes(type, externalTypes);
            Map<String, ?> optionsMap = null;
            if (type instanceof MessageType) {
                optionsMap = this.messageOptionsMapMaker.createOptionsMap((MessageType)type);
            }
            if (optionsMap != null) {
                this.messageOptionsMapMaker.getOptionTypes(optionsMap, externalTypes);
            }
            imports.addAll(externalTypes);
            TreeSet<Message.Datatype> datatypes = new TreeSet<Message.Datatype>(Message.Datatype.ORDER_BY_NAME);
            TreeSet<Message.Label> labels = new TreeSet<Message.Label>(Message.Label.ORDER_BY_NAME);
            this.getDatatypesAndLabels(type, datatypes, labels);
            labels.remove(Message.Label.OPTIONAL);
            MessageWriter messageWriter = new MessageWriter(this);
            messageWriter.emitHeader(imports, datatypes, labels);
            messageWriter.emitType(type, this.protoFile.getPackageName() + ".", optionsMap, true);
        }
        finally {
            this.writer.close();
        }
    }

    private void getExternalTypes(Type parent, List<String> types) {
        if (parent instanceof MessageType) {
            MessageType messageType = (MessageType)parent;
            for (MessageType.Field field : messageType.getFields()) {
                String fqName = this.fullyQualifiedJavaName(messageType, field.getType());
                if (!this.fullyQualifiedNameIsOutsidePackage(fqName)) continue;
                types.add(fqName);
            }
        }
        for (Type nestedType : parent.getNestedTypes()) {
            this.getExternalTypes(nestedType, types);
        }
    }

    private String getPackageFromFullyQualifiedJavaName(String fqName) {
        while (this.javaSymbolMap.containsValue(fqName)) {
            fqName = this.removeTrailingSegment(fqName);
        }
        return fqName;
    }

    private List<String> getExtensionTypes() {
        ArrayList<String> extensionClasses = new ArrayList<String>();
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            String fqName = this.fullyQualifiedJavaName(null, extend.getFullyQualifiedName());
            if (this.fullyQualifiedNameIsOutsidePackage(fqName)) {
                extensionClasses.add(fqName);
            }
            for (MessageType.Field field : extend.getFields()) {
                String fqFieldType = this.fullyQualifiedJavaName(null, field.getType());
                if (!this.fullyQualifiedNameIsOutsidePackage(fqFieldType)) continue;
                extensionClasses.add(fqFieldType);
            }
        }
        return extensionClasses;
    }

    private boolean hasExtends() {
        return !this.protoFile.getExtendDeclarations().isEmpty();
    }

    private void emitExtensionClass() throws IOException {
        this.writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
        this.writer.emitSingleLineComment("Source file: %s", new Object[]{this.sourceFileName});
        this.writer.emitPackage(this.protoFile.getJavaPackage());
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (this.hasByteStringExtension()) {
            imports.add("com.squareup.wire.ByteString");
        }
        imports.add("com.squareup.wire.Extension");
        if (this.hasRepeatedExtension()) {
            imports.add("java.util.List");
        }
        imports.addAll(this.getExtensionTypes());
        this.writer.emitImports(imports);
        this.writer.emitEmptyLine();
        String className = "Ext_" + this.protoFileName;
        this.writer.beginType(className, "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, className, EnumSet.of(Modifier.PRIVATE), new String[0]);
        this.writer.endMethod();
        this.writer.emitEmptyLine();
        this.emitExtensions();
        this.writer.endType();
    }

    private void emitExtensions() throws IOException {
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            String fullyQualifiedName = extend.getFullyQualifiedName();
            String javaName = this.javaName(null, fullyQualifiedName);
            String name = this.shortenJavaName(javaName);
            for (MessageType.Field field : extend.getFields()) {
                String fieldType = field.getType();
                String type = this.javaName(null, fieldType);
                if (type == null) {
                    type = this.javaName(null, this.prefixWithPackageName(fieldType));
                }
                type = this.shortenJavaName(type);
                String className = this.writer.compressType(name);
                String extensionName = field.getName();
                String fqName = this.prefixWithPackageName(field.getName());
                int tag = field.getTag();
                boolean isScalar = TypeInfo.isScalar(fieldType);
                boolean isEnum = !isScalar && this.isEnum(this.fullyQualifiedName(null, fieldType));
                String labelString = this.getLabelString(field, isEnum);
                String initialValue = isScalar ? String.format("Extension%n%1$s.%2$sExtending(%3$s.class)%n%1$s.setName(\"%4$s\")%n%1$s.setTag(%5$d)%n%1$s.build%6$s()", "      ", field.getType(), className, fqName, tag, labelString) : (isEnum ? String.format("Extension%n%1$s.enumExtending(%2$s.class, %3$s.class)%n%1$s.setName(\"%4$s\")%n%1$s.setTag(%5$d)%n%1$s.build%6$s()", "      ", type, className, fqName, tag, labelString) : String.format("Extension%n%1$s.messageExtending(%2$s.class, %3$s.class)%n%1$s.setName(\"%4$s\")%n%1$s.setTag(%5$d)%n%1$s.build%6$s()", "      ", type, className, fqName, tag, labelString));
                if (FieldInfo.isRepeated(field)) {
                    type = "List<" + type + ">";
                }
                this.writer.emitField("Extension<" + name + ", " + type + ">", extensionName, EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), initialValue);
            }
        }
    }

    private String prefixWithPackageName(ProtoFile protoFile, String name) {
        return protoFile.getPackageName() + "." + name;
    }

    private String getLabelString(MessageType.Field field, boolean isEnum) {
        switch (field.getLabel()) {
            case OPTIONAL: {
                return "Optional";
            }
            case REQUIRED: {
                return "Required";
            }
            case REPEATED: {
                return FieldInfo.isPacked(field, isEnum) ? "Packed" : "Repeated";
            }
        }
        throw new RuntimeException("Unknown extension label \"" + field.getLabel() + "\"");
    }

    private boolean hasByteStringExtension() {
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            for (MessageType.Field field : extend.getFields()) {
                String fieldType = field.getType();
                if (!"bytes".equals(fieldType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRepeatedExtension() {
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            for (MessageType.Field field : extend.getFields()) {
                if (field.getLabel() != MessageType.Label.REPEATED) continue;
                return true;
            }
        }
        return false;
    }

    private String toInt(String value) {
        return Integer.toString(new BigDecimal(value).intValue());
    }

    private String toLong(String value) {
        return Long.toString(new BigDecimal(value).longValue());
    }

    private String quoteString(String initialValue) {
        return initialValue == null ? "\"\"" : JavaWriter.stringLiteral((String)initialValue);
    }

    private boolean hasEnum(List<Type> types) {
        for (Type type : types) {
            if (!(type instanceof EnumType) && !this.hasEnum(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtensions(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType && this.hasExtensions((MessageType)type)) {
                return true;
            }
            if (!this.hasExtensions(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasMessage(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType && !this.hasExtensions((MessageType)type)) {
                return true;
            }
            if (!this.hasMessage(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRepeatedField(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType) {
                for (MessageType.Field field : ((MessageType)type).getFields()) {
                    if (!FieldInfo.isRepeated(field)) continue;
                    return true;
                }
            }
            if (!this.hasRepeatedField(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasBytesField(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType) {
                for (MessageType.Field field : ((MessageType)type).getFields()) {
                    if (!"bytes".equals(field.getType())) continue;
                    return true;
                }
            }
            if (!this.hasBytesField(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private void getDatatypesAndLabels(Type type, Collection<Message.Datatype> types, Collection<Message.Label> labels) {
        if (type instanceof MessageType) {
            block5: for (MessageType.Field field : ((MessageType)type).getFields()) {
                String fieldType = field.getType();
                Message.Datatype datatype = Message.Datatype.of((String)fieldType);
                if (datatype == null && this.isEnum(this.fullyQualifiedName((MessageType)type, field.getType()))) {
                    datatype = Message.Datatype.ENUM;
                }
                if (datatype != null) {
                    types.add(datatype);
                }
                MessageType.Label label = field.getLabel();
                switch (label) {
                    case OPTIONAL: {
                        labels.add(Message.Label.OPTIONAL);
                        continue block5;
                    }
                    case REQUIRED: {
                        labels.add(Message.Label.REQUIRED);
                        continue block5;
                    }
                    case REPEATED: {
                        if (FieldInfo.isPacked(field, false)) {
                            labels.add(Message.Label.PACKED);
                            continue block5;
                        }
                        labels.add(Message.Label.REPEATED);
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unknown label " + label));
            }
            for (Type nestedType : type.getNestedTypes()) {
                this.getDatatypesAndLabels(nestedType, types, labels);
            }
        }
    }

    private boolean typeIsComplete(String type) {
        return this.javaSymbolMap.containsKey(type);
    }

    private String fullyQualifiedJavaName(MessageType messageType, String type) {
        return TypeInfo.isScalar(type) ? null : this.javaName(this.fullyQualifiedName(messageType, type));
    }

    private static enum LoadSymbolsPass {
        LOAD_TYPES,
        LOAD_FIELDS;

    }
}

