/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.Type;
import com.squareup.wire.ExtensionInfo;
import com.squareup.wire.FieldInfo;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoField;
import com.squareup.wire.TypeInfo;
import com.squareup.wire.WireCompiler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class MessageWriter {
    private static final Set<String> JAVA_KEYWORDS = new LinkedHashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private final WireCompiler compiler;
    private final JavaWriter writer;

    public MessageWriter(WireCompiler compiler) {
        this.compiler = compiler;
        this.writer = compiler.getWriter();
    }

    public static void emitDocumentation(JavaWriter writer, String documentation) throws IOException {
        if (MessageWriter.hasDocumentation(documentation)) {
            writer.emitJavadoc(MessageWriter.sanitizeJavadoc(documentation), new Object[0]);
        }
    }

    static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replace("%", "%%");
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public void emitHeader(Set<String> imports, Collection<Message.Datatype> datatypes, Collection<Message.Label> labels) throws IOException {
        this.writer.emitImports(imports);
        if (!datatypes.isEmpty() || !labels.isEmpty()) {
            this.writer.emitEmptyLine();
        }
        for (Message.Datatype datatype : datatypes) {
            this.writer.emitStaticImports(new String[]{"com.squareup.wire.Message.Datatype." + datatype.toString()});
        }
        for (Message.Label label : labels) {
            this.writer.emitStaticImports(new String[]{"com.squareup.wire.Message.Label." + label.toString()});
        }
    }

    public void emitType(Type type, String currentType, Map<String, ?> optionsMap, boolean topLevel) throws IOException {
        this.writer.emitEmptyLine();
        if (type instanceof MessageType) {
            this.emitAll((MessageType)type, optionsMap, topLevel);
            for (Type nestedType : type.getNestedTypes()) {
                this.emitType(nestedType, currentType + nestedType.getName() + ".", optionsMap, false);
            }
            this.writer.endType();
        } else if (type instanceof EnumType) {
            EnumType enumType = (EnumType)type;
            this.writer.beginType(enumType.getName(), "enum", EnumSet.of(Modifier.PUBLIC));
            for (EnumType.Value value : enumType.getValues()) {
                MessageWriter.emitDocumentation(this.writer, value.getDocumentation());
                this.writer.emitAnnotation(ProtoEnum.class, (Object)value.getTag());
                this.writer.emitEnumValue(value.getName());
            }
            this.writer.endType();
        }
    }

    private void emitAll(MessageType messageType, Map<String, ?> optionsMap, boolean topLevel) throws IOException {
        EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC, Modifier.FINAL);
        if (!topLevel) {
            modifiers.add(Modifier.STATIC);
        }
        String name = messageType.getName();
        MessageWriter.emitDocumentation(this.writer, messageType.getDocumentation());
        this.writer.beginType(name, "class", modifiers, this.compiler.hasExtensions(messageType) ? "ExtendableMessage<" + name + ">" : "Message", new String[0]);
        this.emitMessageOptions(optionsMap);
        this.emitMessageDefaults(messageType);
        this.emitMessageFields(messageType);
        this.emitMessageConstructor(messageType);
        this.emitMessageEquals(messageType);
        this.emitMessageHashCode(messageType);
        this.emitBuilder(messageType);
    }

    private void emitMessageOptions(Map<String, ?> optionsMap) throws IOException {
        if (optionsMap != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("new MessageOptions.Builder()");
            for (Map.Entry<String, ?> entry : optionsMap.entrySet()) {
                String fqName = entry.getKey();
                ExtensionInfo info = this.compiler.getExtension(fqName);
                sb.append(String.format("%n%s.setExtension(Ext_%s.%s, %s)", "      ", info.location, this.compiler.getTrailingSegment(fqName), this.compiler.getMessageOptionsMapMaker().createOptionInitializer(entry.getValue(), "", "", info.fqType, false, 1)));
            }
            sb.append("\n").append("  ").append("    ").append(".build()");
            this.writer.emitEmptyLine();
            this.writer.emitField("MessageOptions", "MESSAGE_OPTIONS", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), sb.toString());
        }
    }

    private void emitMessageDefaults(MessageType messageType) throws IOException {
        ArrayList<MessageType.Field> defaultFields = new ArrayList<MessageType.Field>();
        for (MessageType.Field field : messageType.getFields()) {
            if (this.isMessageType(messageType, field) && !FieldInfo.isRepeated(field)) continue;
            defaultFields.add(field);
        }
        if (!defaultFields.isEmpty()) {
            this.writer.emitEmptyLine();
        }
        for (MessageType.Field field : defaultFields) {
            String javaName = this.getJavaFieldType(messageType, field);
            if (javaName == null) {
                throw new IllegalArgumentException("Unknown type for field " + field + " in message " + messageType.getName());
            }
            String defaultValue = this.getDefaultValue(messageType, field);
            this.writer.emitField(javaName, "DEFAULT_" + field.getName().toUpperCase(Locale.US), EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), defaultValue);
        }
    }

    private void emitMessageFields(MessageType messageType) throws IOException {
        HashSet<Integer> tags = new HashSet<Integer>();
        for (MessageType.Field field : messageType.getFields()) {
            int tag = field.getTag();
            if (tags.contains(tag)) {
                throw new RuntimeException("Duplicate tag value for field " + messageType.getFullyQualifiedName() + "." + field.getName());
            }
            tags.add(tag);
            String fieldType = field.getType();
            String javaName = this.compiler.javaName(messageType, fieldType);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("tag", String.valueOf(tag));
            boolean isEnum = false;
            if (TypeInfo.isScalar(fieldType)) {
                map.put("type", this.scalarTypeConstant(fieldType));
            } else {
                String fullyQualifiedName = this.compiler.fullyQualifiedName(messageType, fieldType);
                isEnum = this.compiler.isEnum(fullyQualifiedName);
                if (isEnum) {
                    map.put("type", "ENUM");
                }
            }
            if (!FieldInfo.isOptional(field)) {
                if (FieldInfo.isPacked(field, isEnum)) {
                    map.put("label", "PACKED");
                } else {
                    map.put("label", field.getLabel().toString());
                }
            }
            this.writer.emitEmptyLine();
            MessageWriter.emitDocumentation(this.writer, field.getDocumentation());
            this.writer.emitAnnotation(ProtoField.class, map);
            if (FieldInfo.isRepeated(field)) {
                javaName = "List<" + javaName + ">";
            }
            this.writer.emitField(javaName, this.sanitize(field.getName()), EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        }
    }

    private void emitMessageConstructor(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, messageType.getName(), EnumSet.of(Modifier.PRIVATE), new String[]{"Builder", "builder"});
        this.writer.emitStatement("super(builder)", new Object[0]);
        for (MessageType.Field field : messageType.getFields()) {
            if (FieldInfo.isRepeated(field)) {
                this.writer.emitStatement("this.%1$s = immutableCopyOf(builder.%1$s)", new Object[]{this.sanitize(field.getName())});
                continue;
            }
            this.writer.emitStatement("this.%1$s = builder.%1$s", new Object[]{this.sanitize(field.getName())});
        }
        this.writer.endMethod();
    }

    private void emitMessageEquals(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod("boolean", "equals", EnumSet.of(Modifier.PUBLIC), new String[]{"Object", "other"});
        List fields = messageType.getFields();
        if (fields.isEmpty()) {
            this.writer.emitStatement("return other instanceof %s", new Object[]{messageType.getName()});
        } else {
            this.writer.emitStatement("if (other == this) return true", new Object[0]);
            this.writer.emitStatement("if (!(other instanceof %s)) return false", new Object[]{messageType.getName()});
            if (this.hasOnlyOneField(messageType)) {
                String name = this.sanitize(((MessageType.Field)fields.get(0)).getName());
                this.writer.emitStatement("return equals(%1$s, ((%2$s) other).%3$s)", new Object[]{this.addThisIfOneOf(name, "other", "o"), messageType.getName(), name});
            } else {
                this.writer.emitStatement("%1$s o = (%1$s) other", new Object[]{messageType.getName()});
                if (this.compiler.hasExtensions(messageType)) {
                    this.writer.emitStatement("if (!extensionsEqual(o)) return false", new Object[0]);
                }
                StringBuilder sb = new StringBuilder();
                String prefix = "return ";
                for (MessageType.Field field : fields) {
                    sb.append(prefix);
                    prefix = "\n&& ";
                    String name = this.sanitize(field.getName());
                    sb.append(String.format("equals(%1$s, o.%2$s)", this.addThisIfOneOf(name, "other", "o"), name));
                }
                this.writer.emitStatement(sb.toString(), new Object[0]);
            }
        }
        this.writer.endMethod();
    }

    private void emitMessageHashCode(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod("int", "hashCode", EnumSet.of(Modifier.PUBLIC), new String[0]);
        if (!this.compiler.hasFields((Type)messageType) && !this.compiler.hasExtensions(messageType)) {
            this.writer.emitStatement("return 0", new Object[0]);
        } else if (this.hasOnlyOneField(messageType)) {
            MessageType.Field field = (MessageType.Field)messageType.getFields().get(0);
            String name = this.sanitize(field.getName());
            name = this.addThisIfOneOf(name, "result");
            this.writer.emitStatement("int result = hashCode", new Object[0]);
            this.writer.emitStatement("return result != 0 ? result : (hashCode = %1$s != null ? %1$s.hashCode() : 0)", new Object[]{name});
        } else {
            this.writer.emitStatement("int result = hashCode", new Object[0]);
            this.writer.beginControlFlow("if (result == 0)");
            boolean afterFirstAssignment = false;
            if (this.compiler.hasExtensions(messageType)) {
                this.writer.emitStatement("result = extensionsHashCode()", new Object[0]);
                afterFirstAssignment = true;
            }
            for (MessageType.Field field : messageType.getFields()) {
                String name = this.sanitize(field.getName());
                name = this.addThisIfOneOf(name, "result");
                if (afterFirstAssignment) {
                    this.writer.emitStatement("result = result * 37 + (%1$s != null ? %1$s.hashCode() : 0)", new Object[]{name});
                    continue;
                }
                this.writer.emitStatement("result = %1$s != null ? %1$s.hashCode() : 0", new Object[]{name});
                afterFirstAssignment = true;
            }
            this.writer.emitStatement("hashCode = result", new Object[0]);
            this.writer.endControlFlow();
            this.writer.emitStatement("return result", new Object[0]);
        }
        this.writer.endMethod();
    }

    private void emitBuilder(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.beginType("Builder", "class", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), (this.compiler.hasExtensions(messageType) ? "ExtendableBuilder<" : "Message.Builder<") + messageType.getName() + ">", new String[0]);
        this.emitBuilderFields(messageType);
        this.emitBuilderConstructors(messageType);
        this.emitBuilderSetters(messageType);
        if (this.compiler.hasExtensions(messageType)) {
            this.emitBuilderSetExtension(messageType);
        }
        this.emitBuilderBuild(messageType);
        this.writer.endType();
    }

    private void emitBuilderFields(MessageType messageType) throws IOException {
        List fields = messageType.getFields();
        if (!fields.isEmpty()) {
            this.writer.emitEmptyLine();
        }
        for (MessageType.Field field : fields) {
            String javaName = this.getJavaFieldType(messageType, field);
            this.writer.emitField(javaName, this.sanitize(field.getName()), EnumSet.of(Modifier.PUBLIC));
        }
    }

    private void emitBuilderConstructors(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, "Builder", EnumSet.of(Modifier.PUBLIC), new String[0]);
        this.writer.endMethod();
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, "Builder", EnumSet.of(Modifier.PUBLIC), new String[]{messageType.getName(), "message"});
        this.writer.emitStatement("super(message)", new Object[0]);
        List fields = messageType.getFields();
        if (!fields.isEmpty()) {
            this.writer.emitStatement("if (message == null) return", new Object[0]);
        }
        for (MessageType.Field field : fields) {
            if (FieldInfo.isRepeated(field)) {
                this.writer.emitStatement("this.%1$s = copyOf(message.%1$s)", new Object[]{this.sanitize(field.getName())});
                continue;
            }
            this.writer.emitStatement("this.%1$s = message.%1$s", new Object[]{this.sanitize(field.getName())});
        }
        this.writer.endMethod();
    }

    private void emitBuilderSetters(MessageType messageType) throws IOException {
        for (MessageType.Field field : messageType.getFields()) {
            String javaName = this.getJavaFieldType(messageType, field);
            ArrayList<String> args = new ArrayList<String>();
            args.add(javaName);
            String sanitized = this.sanitize(field.getName());
            args.add(sanitized);
            this.writer.emitEmptyLine();
            MessageWriter.emitDocumentation(this.writer, field.getDocumentation());
            this.writer.beginMethod("Builder", sanitized, EnumSet.of(Modifier.PUBLIC), args, null);
            this.writer.emitStatement("this.%1$s = %1$s", new Object[]{sanitized});
            this.writer.emitStatement("return this", new Object[0]);
            this.writer.endMethod();
        }
    }

    private void emitBuilderSetExtension(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod("<E> Builder", "setExtension", EnumSet.of(Modifier.PUBLIC), new String[]{"Extension<" + messageType.getName() + ", E>", "extension", "E", "value"});
        this.writer.emitStatement("super.setExtension(extension, value)", new Object[0]);
        this.writer.emitStatement("return this", new Object[0]);
        this.writer.endMethod();
    }

    private void emitBuilderBuild(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod(messageType.getName(), "build", EnumSet.of(Modifier.PUBLIC), new String[0]);
        if (this.hasRequiredFields((Type)messageType)) {
            this.writer.emitStatement("checkRequiredFields()", new Object[0]);
        }
        this.writer.emitStatement("return new %s(this)", new Object[]{messageType.getName()});
        this.writer.endMethod();
    }

    private String addThisIfOneOf(String name, String ... matches) {
        for (String match : matches) {
            if (!match.equals(name)) continue;
            return "this." + name;
        }
        return name;
    }

    private String getDefaultValue(MessageType messageType, MessageType.Field field) {
        String initialValue = field.getDefault();
        if (FieldInfo.isRepeated(field)) {
            return "Collections.emptyList()";
        }
        String javaName = this.compiler.javaName(messageType, field.getType());
        if (TypeInfo.isScalar(field.getType())) {
            return this.compiler.getInitializerForType(initialValue, javaName);
        }
        if (initialValue != null) {
            return javaName + "." + initialValue;
        }
        String fullyQualifiedName = this.compiler.fullyQualifiedName(messageType, field.getType());
        if (this.compiler.isEnum(fullyQualifiedName)) {
            return javaName + "." + this.compiler.getEnumDefault(fullyQualifiedName);
        }
        throw new IllegalArgumentException("Field " + field + " cannot have default value");
    }

    private String getJavaFieldType(MessageType messageType, MessageType.Field field) {
        return this.getJavaFieldType(this.compiler.getProtoFile(), messageType, field);
    }

    private String getJavaFieldType(ProtoFile protoFile, MessageType messageType, MessageType.Field field) {
        String javaName = this.compiler.javaName(protoFile, messageType, field.getType());
        if (FieldInfo.isRepeated(field)) {
            javaName = "List<" + javaName + ">";
        }
        return javaName;
    }

    private static boolean hasDocumentation(String documentation) {
        return documentation != null && !documentation.isEmpty();
    }

    private boolean hasOnlyOneField(MessageType messageType) {
        return messageType.getFields().size() == 1 && !this.compiler.hasExtensions(messageType);
    }

    private boolean hasRequiredFields(Type type) {
        if (type instanceof MessageType) {
            for (MessageType.Field field : ((MessageType)type).getFields()) {
                if (!FieldInfo.isRequired(field)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMessageType(MessageType messageType, MessageType.Field field) {
        return !TypeInfo.isScalar(field.getType()) && !this.compiler.isEnum(this.compiler.fullyQualifiedName(messageType, field.getType()));
    }

    private String sanitize(String name) {
        return JAVA_KEYWORDS.contains(name) ? "_" + name : name;
    }

    private String scalarTypeConstant(String type) {
        return type.toUpperCase(Locale.US);
    }
}

