/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.protoparser.MessageType;
import com.squareup.wire.TypeInfo;

final class FieldInfo {
    final String name;
    final MessageType.Label label;

    FieldInfo(String name, MessageType.Label label) {
        this.name = name;
        this.label = label;
    }

    public static boolean isOptional(MessageType.Field field) {
        return field.getLabel() == MessageType.Label.OPTIONAL;
    }

    public static boolean isPacked(MessageType.Field field, boolean isEnum) {
        return "true".equals(field.getExtensions().get("packed")) && (isEnum || FieldInfo.isPackableScalar(field));
    }

    private static boolean isPackableScalar(MessageType.Field field) {
        String type = field.getType();
        return TypeInfo.isScalar(type) && !"string".equals(type) && !"bytes".equals(type);
    }

    public static boolean isRepeated(MessageType.Field field) {
        return field.getLabel() == MessageType.Label.REPEATED;
    }

    public static boolean isRequired(MessageType.Field field) {
        return field.getLabel() == MessageType.Label.REQUIRED;
    }

    public boolean isRepeated() {
        return this.label == MessageType.Label.REPEATED;
    }
}

