/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.java8;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.java8.HttpException;

@Deprecated
public final class Java8CallAdapterFactory
extends CallAdapter.Factory {
    public static Java8CallAdapterFactory create() {
        return new Java8CallAdapterFactory();
    }

    private Java8CallAdapterFactory() {
    }

    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Java8CallAdapterFactory.getRawType((Type)returnType) != CompletableFuture.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("CompletableFuture return type must be parameterized as CompletableFuture<Foo> or CompletableFuture<? extends Foo>");
        }
        Type innerType = Java8CallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        if (Java8CallAdapterFactory.getRawType((Type)innerType) != Response.class) {
            return new BodyCallAdapter(innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = Java8CallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)innerType));
        return new ResponseCallAdapter(responseType);
    }

    private static final class ResponseCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<Response<R>>> {
        private final Type responseType;

        ResponseCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public CompletableFuture<Response<R>> adapt(final Call<R> call) {
            final CompletableFuture future = new CompletableFuture<Response<R>>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    if (mayInterruptIfRunning) {
                        call.cancel();
                    }
                    return super.cancel(mayInterruptIfRunning);
                }
            };
            call.enqueue(new Callback<R>(){

                public void onResponse(Call<R> call, Response<R> response) {
                    future.complete(response);
                }

                public void onFailure(Call<R> call, Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            return future;
        }
    }

    private static final class BodyCallAdapter<R>
    implements CallAdapter<R, CompletableFuture<R>> {
        private final Type responseType;

        BodyCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public CompletableFuture<R> adapt(final Call<R> call) {
            final CompletableFuture future = new CompletableFuture<R>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    if (mayInterruptIfRunning) {
                        call.cancel();
                    }
                    return super.cancel(mayInterruptIfRunning);
                }
            };
            call.enqueue(new Callback<R>(){

                public void onResponse(Call<R> call, Response<R> response) {
                    if (response.isSuccessful()) {
                        future.complete(response.body());
                    } else {
                        future.completeExceptionally((Throwable)((Object)new HttpException(response)));
                    }
                }

                public void onFailure(Call<R> call, Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            return future;
        }
    }
}

