/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.ExtendDeclaration;
import com.squareup.protoparser.Extensions;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.Option;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.Service;
import com.squareup.protoparser.Type;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ProtoSchemaParser {
    private final String fileName;
    private final char[] data;
    private int pos;
    private int line;
    private int lineStart;
    private String packageName;
    private String prefix = "";
    private final List<String> dependencies = new ArrayList<String>();
    private final List<String> publicDependencies = new ArrayList<String>();
    private final List<Type> types = new ArrayList<Type>();
    private final List<Service> services = new ArrayList<Service>();
    private final List<ExtendDeclaration> extendDeclarations = new ArrayList<ExtendDeclaration>();
    private final List<Option> options = new ArrayList<Option>();

    public static ProtoFile parse(File file) throws IOException {
        return new ProtoSchemaParser(file.getName(), ProtoSchemaParser.fileToCharArray(file)).readProtoFile();
    }

    public static ProtoFile parseUtf8(String name, InputStream is) throws IOException {
        return new ProtoSchemaParser(name, ProtoSchemaParser.streamToCharArray(is)).readProtoFile();
    }

    public static ProtoFile parse(String name, Reader reader) throws IOException {
        return new ProtoSchemaParser(name, ProtoSchemaParser.readerToCharArray(reader)).readProtoFile();
    }

    public static ProtoFile parse(String name, String data) {
        return new ProtoSchemaParser(name, data.toCharArray()).readProtoFile();
    }

    ProtoSchemaParser(String fileName, char[] data) {
        this.fileName = fileName;
        this.data = data;
    }

    private static char[] fileToCharArray(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            char[] cArray = ProtoSchemaParser.streamToCharArray(is);
            return cArray;
        }
        finally {
            is.close();
        }
    }

    private static char[] streamToCharArray(InputStream is) throws IOException {
        return ProtoSchemaParser.readerToCharArray(new InputStreamReader(is, "UTF-8"));
    }

    private static char[] readerToCharArray(Reader reader) throws IOException {
        int count;
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[1024];
        while ((count = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, count);
        }
        return writer.toCharArray();
    }

    ProtoFile readProtoFile() {
        while (true) {
            String documentation = this.readDocumentation();
            if (this.pos == this.data.length) {
                return new ProtoFile(this.fileName, this.packageName, this.dependencies, this.publicDependencies, this.types, this.services, this.options, this.extendDeclarations);
            }
            Object declaration = this.readDeclaration(documentation, Context.FILE);
            if (declaration instanceof Type) {
                this.types.add((Type)declaration);
                continue;
            }
            if (declaration instanceof Service) {
                this.services.add((Service)declaration);
                continue;
            }
            if (declaration instanceof Option) {
                this.options.add((Option)declaration);
                continue;
            }
            if (!(declaration instanceof ExtendDeclaration)) continue;
            this.extendDeclarations.add((ExtendDeclaration)declaration);
        }
    }

    private Object readDeclaration(String documentation, Context context) {
        if (this.peekChar() == ';') {
            ++this.pos;
            return null;
        }
        String label = this.readWord();
        if (label.equals("package")) {
            if (!context.permitsPackage()) {
                throw this.unexpected("package in " + (Object)((Object)context));
            }
            if (this.packageName != null) {
                throw this.unexpected("too many package names");
            }
            this.packageName = this.readName();
            this.prefix = this.packageName + ".";
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("import")) {
            if (!context.permitsImport()) {
                throw this.unexpected("import in " + (Object)((Object)context));
            }
            String importString = this.readString();
            if ("public".equals(importString)) {
                this.publicDependencies.add(this.readString());
            } else {
                this.dependencies.add(importString);
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("option")) {
            Option result = this.readOption('=');
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return result;
        }
        if (label.equals("message")) {
            return this.readMessage(documentation);
        }
        if (label.equals("enum")) {
            return this.readEnumType(documentation);
        }
        if (label.equals("service")) {
            return this.readService(documentation);
        }
        if (label.equals("extend")) {
            return this.readExtend(documentation);
        }
        if (label.equals("rpc")) {
            if (!context.permitsRpc()) {
                throw this.unexpected("rpc in " + (Object)((Object)context));
            }
            return this.readRpc(documentation);
        }
        if (label.equals("required") || label.equals("optional") || label.equals("repeated")) {
            if (!context.permitsField()) {
                throw this.unexpected("fields must be nested");
            }
            return this.readField(documentation, label);
        }
        if (label.equals("extensions")) {
            if (!context.permitsExtensions()) {
                throw this.unexpected("extensions must be nested");
            }
            return this.readExtensions(documentation);
        }
        if (context == Context.ENUM) {
            int tag;
            ArrayList<Option> options;
            block27: {
                options = new ArrayList<Option>();
                if (this.readChar() != '=') {
                    throw this.unexpected("expected '='");
                }
                tag = this.readInt();
                if (this.peekChar() == '[') {
                    char c;
                    this.readChar();
                    do {
                        options.add(this.readOption('='));
                        c = this.readChar();
                        if (c == ']') break block27;
                    } while (c == ',');
                    throw this.unexpected("Expected ',' or ']");
                }
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return new EnumType.Value(label, tag, documentation, options);
        }
        throw this.unexpected("unexpected label: " + label);
    }

    private MessageType readMessage(String documentation) {
        String previousPrefix = this.prefix;
        String name = this.readName();
        this.prefix = this.prefix + name + ".";
        ArrayList<MessageType.Field> fields = new ArrayList<MessageType.Field>();
        ArrayList<Type> nestedTypes = new ArrayList<Type>();
        ArrayList<Extensions> extensions = new ArrayList<Extensions>();
        ArrayList<Option> options = new ArrayList<Option>();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(nestedDocumentation, Context.MESSAGE);
            if (declared instanceof MessageType.Field) {
                fields.add((MessageType.Field)declared);
                continue;
            }
            if (declared instanceof Type) {
                nestedTypes.add((Type)declared);
                continue;
            }
            if (declared instanceof Extensions) {
                extensions.add((Extensions)declared);
                continue;
            }
            if (!(declared instanceof Option)) continue;
            options.add((Option)declared);
        }
        this.prefix = previousPrefix;
        return new MessageType(name, this.prefix + name, documentation, fields, nestedTypes, extensions, options);
    }

    private ExtendDeclaration readExtend(String documentation) {
        String name = this.readName();
        ArrayList<MessageType.Field> fields = new ArrayList<MessageType.Field>();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(nestedDocumentation, Context.EXTEND);
            if (!(declared instanceof MessageType.Field)) continue;
            fields.add((MessageType.Field)declared);
        }
        return new ExtendDeclaration(name, name.contains(".") ? name : this.prefix + name, documentation, fields);
    }

    private Service readService(String documentation) {
        String name = this.readName();
        ArrayList<Option> options = new ArrayList<Option>();
        ArrayList<Service.Method> methods = new ArrayList<Service.Method>();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String methodDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(methodDocumentation, Context.SERVICE);
            if (declared instanceof Service.Method) {
                methods.add((Service.Method)declared);
                continue;
            }
            if (!(declared instanceof Option)) continue;
            options.add((Option)declared);
        }
        return new Service(name, this.prefix + name, documentation, options, methods);
    }

    private EnumType readEnumType(String documentation) {
        String name = this.readName();
        ArrayList<Option> options = new ArrayList<Option>();
        ArrayList<EnumType.Value> values = new ArrayList<EnumType.Value>();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String valueDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(valueDocumentation, Context.ENUM);
            if (declared instanceof EnumType.Value) {
                values.add((EnumType.Value)declared);
                continue;
            }
            if (!(declared instanceof Option)) continue;
            options.add((Option)declared);
        }
        return new EnumType(name, this.prefix + name, documentation, options, values);
    }

    private MessageType.Field readField(String documentation, String label) {
        MessageType.Label labelEnum = MessageType.Label.valueOf(label.toUpperCase(Locale.US));
        String type = this.readName();
        String name = this.readName();
        if (this.readChar() != '=') {
            throw this.unexpected("expected '='");
        }
        int tag = this.readInt();
        ArrayList<Option> options = new ArrayList<Option>();
        if (this.peekChar() == '[') {
            ++this.pos;
            while (true) {
                options.add(this.readOption('='));
                char c = this.peekChar();
                if (c == ']') {
                    ++this.pos;
                    break;
                }
                if (c != ',') continue;
                ++this.pos;
            }
        }
        if (this.readChar() == ';') {
            return new MessageType.Field(labelEnum, type, name, tag, documentation, options);
        }
        throw this.unexpected("expected ';'");
    }

    private Extensions readExtensions(String documentation) {
        int start;
        int end = start = this.readInt();
        if (this.peekChar() != ';') {
            if (!"to".equals(this.readWord())) {
                throw this.unexpected("expected ';' or 'to'");
            }
            String s = this.readWord();
            end = s.equals("max") ? 0x1FFFFFFF : Integer.parseInt(s);
        }
        if (this.readChar() != ';') {
            throw this.unexpected("expected ';'");
        }
        return new Extensions(documentation, start, end);
    }

    private Option readOption(char keyValueSeparator) {
        boolean isExtension = this.peekChar() == '[';
        String name = this.readName();
        if (isExtension) {
            name = "[" + name + "]";
        }
        String subName = null;
        char c = this.readChar();
        if (c == '.') {
            subName = this.readName();
            c = this.readChar();
        }
        if (c != keyValueSeparator) {
            throw this.unexpected("expected '" + keyValueSeparator + "' in option");
        }
        Object value = this.readValue();
        return new Option(name, subName != null ? new Option(subName, value) : value);
    }

    private Object readValue() {
        switch (this.peekChar()) {
            case '{': {
                return this.readMap('{', '}', ':');
            }
            case '[': {
                return this.readList();
            }
        }
        return this.readString();
    }

    private Map<String, Object> readMap(char openBrace, char closeBrace, char keyValueSeparator) {
        if (this.readChar() != openBrace) {
            throw new AssertionError();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while (true) {
            if (this.peekChar() == closeBrace) {
                ++this.pos;
                return result;
            }
            Option option = this.readOption(keyValueSeparator);
            String name = option.getName();
            Object value = option.getValue();
            if (value instanceof Option) {
                LinkedHashMap<String, Object> nested = (LinkedHashMap<String, Object>)result.get(name);
                if (nested == null) {
                    nested = new LinkedHashMap<String, Object>();
                    result.put(name, nested);
                }
                Option valueOption = (Option)value;
                nested.put(valueOption.getName(), valueOption.getValue());
            } else {
                Object previous = result.get(name);
                if (previous == null) {
                    result.put(name, value);
                } else if (previous instanceof List) {
                    this.addToList((List)previous, value);
                } else {
                    ArrayList<Object> newList = new ArrayList<Object>();
                    newList.add(previous);
                    this.addToList(newList, value);
                    result.put(name, newList);
                }
            }
            if (this.peekChar() != ',') continue;
            ++this.pos;
        }
    }

    private void addToList(List<Object> list, Object value) {
        if (value instanceof List) {
            list.addAll((List)value);
        } else {
            list.add(value);
        }
    }

    private List<Object> readList() {
        if (this.readChar() != '[') {
            throw new AssertionError();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (true) {
            if (this.peekChar() == ']') {
                ++this.pos;
                return result;
            }
            result.add(this.readValue());
            char c = this.peekChar();
            if (c == ',') {
                ++this.pos;
                continue;
            }
            if (c != ']') break;
        }
        throw this.unexpected("expected ',' or ']'");
    }

    private Service.Method readRpc(String documentation) {
        ArrayList<Option> options;
        String responseType;
        String requestType;
        String name;
        block9: {
            name = this.readName();
            if (this.readChar() != '(') {
                throw this.unexpected("expected '('");
            }
            requestType = this.readName();
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
            if (!this.readWord().equals("returns")) {
                throw this.unexpected("expected 'returns'");
            }
            if (this.readChar() != '(') {
                throw this.unexpected("expected '('");
            }
            responseType = this.readName();
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
            options = new ArrayList<Option>();
            if (this.peekChar() == '{') {
                ++this.pos;
                while (true) {
                    String methodDocumentation = this.readDocumentation();
                    if (this.peekChar() == '}') {
                        ++this.pos;
                        break block9;
                    }
                    Object declared = this.readDeclaration(methodDocumentation, Context.RPC);
                    if (!(declared instanceof Option)) continue;
                    options.add((Option)declared);
                }
            }
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
        }
        return new Service.Method(name, documentation, requestType, responseType, options);
    }

    private char readChar() {
        char result = this.peekChar();
        ++this.pos;
        return result;
    }

    private char peekChar() {
        this.skipWhitespace(true);
        if (this.pos == this.data.length) {
            throw this.unexpected("unexpected end of file");
        }
        return this.data[this.pos];
    }

    private String readString() {
        this.skipWhitespace(true);
        return this.peekChar() == '\"' ? this.readQuotedString() : this.readWord();
    }

    private String readQuotedString() {
        if (this.readChar() != '\"') {
            throw new AssertionError();
        }
        StringBuilder result = new StringBuilder();
        while (this.pos < this.data.length) {
            int c;
            if ((c = this.data[this.pos++]) == 34) {
                return result.toString();
            }
            if (c == 92) {
                if (this.pos == this.data.length) {
                    throw this.unexpected("unexpected end of file");
                }
                c = this.data[this.pos++];
                switch (c) {
                    case 97: {
                        c = 7;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 118: {
                        c = 11;
                        break;
                    }
                    case 88: 
                    case 120: {
                        c = this.readNumericEscape(16, 2);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        --this.pos;
                        c = this.readNumericEscape(8, 3);
                        break;
                    }
                }
            }
            result.append((char)c);
            if (c != 10) continue;
            this.newline();
        }
        throw this.unexpected("unterminated string");
    }

    private char readNumericEscape(int radix, int len) {
        int digit;
        int value = -1;
        int endPos = Math.min(this.pos + len, this.data.length);
        while (this.pos < endPos && (digit = this.hexDigit(this.data[this.pos])) != -1 && digit < radix) {
            value = value < 0 ? digit : value * radix + digit;
            ++this.pos;
        }
        if (value < 0) {
            throw this.unexpected("expected a digit after \\x or \\X");
        }
        return (char)value;
    }

    private int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    private String readName() {
        String optionName;
        char c = this.peekChar();
        if (c == '(') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
        } else if (c == '[') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ']') {
                throw this.unexpected("expected ']'");
            }
        } else {
            optionName = this.readWord();
        }
        return optionName;
    }

    private String readWord() {
        char c;
        this.skipWhitespace(true);
        int start = this.pos;
        while (this.pos < this.data.length && ((c = this.data[this.pos]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.')) {
            ++this.pos;
        }
        if (start == this.pos) {
            throw this.unexpected("expected a word");
        }
        return new String(this.data, start, this.pos - start);
    }

    private int readInt() {
        String tag = this.readWord();
        try {
            int radix = 10;
            if (tag.startsWith("0x")) {
                tag = tag.substring("0x".length());
                radix = 16;
            }
            return Integer.valueOf(tag, radix);
        }
        catch (Exception e) {
            throw this.unexpected("expected an integer but was " + tag);
        }
    }

    private String readDocumentation() {
        String result = null;
        while (true) {
            this.skipWhitespace(false);
            if (this.pos == this.data.length || this.data[this.pos] != '/') {
                return result != null ? result : "";
            }
            String comment = this.readComment();
            result = result == null ? comment : result + "\n" + comment;
        }
    }

    private String readComment() {
        int commentType;
        if (this.pos == this.data.length || this.data[this.pos] != '/') {
            throw new AssertionError();
        }
        ++this.pos;
        int n = commentType = this.pos < this.data.length ? this.data[this.pos++] : -1;
        if (commentType == 42) {
            StringBuilder result = new StringBuilder();
            boolean startOfLine = true;
            while (this.pos + 1 < this.data.length) {
                char c = this.data[this.pos];
                if (c == '*' && this.data[this.pos + 1] == '/') {
                    this.pos += 2;
                    return result.toString().trim();
                }
                if (c == '\n') {
                    result.append('\n');
                    this.newline();
                    startOfLine = true;
                } else if (!startOfLine) {
                    result.append(c);
                } else if (c == '*') {
                    if (this.data[this.pos + 1] == ' ') {
                        ++this.pos;
                    }
                    startOfLine = false;
                } else if (!Character.isWhitespace(c)) {
                    result.append(c);
                    startOfLine = false;
                }
                ++this.pos;
            }
            throw this.unexpected("unterminated comment");
        }
        if (commentType == 47) {
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                ++this.pos;
            }
            int start = this.pos;
            while (this.pos < this.data.length) {
                char c;
                if ((c = this.data[this.pos++]) != '\n') continue;
                this.newline();
                break;
            }
            return new String(this.data, start, this.pos - 1 - start);
        }
        throw this.unexpected("unexpected '/'");
    }

    private void skipWhitespace(boolean skipComments) {
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                ++this.pos;
                if (c != '\n') continue;
                this.newline();
                continue;
            }
            if (!skipComments || c != '/') break;
            this.readComment();
        }
    }

    private void newline() {
        ++this.line;
        this.lineStart = this.pos;
    }

    private int column() {
        return this.pos - this.lineStart + 1;
    }

    private int line() {
        return this.line + 1;
    }

    private RuntimeException unexpected(String message) {
        throw new IllegalStateException(String.format("Syntax error in %s at %d:%d: %s", this.fileName, this.line(), this.column(), message));
    }

    static enum Context {
        FILE,
        MESSAGE,
        ENUM,
        RPC,
        EXTEND,
        SERVICE;


        public boolean permitsPackage() {
            return this == FILE;
        }

        public boolean permitsImport() {
            return this == FILE;
        }

        public boolean permitsField() {
            return this == MESSAGE || this == EXTEND;
        }

        public boolean permitsExtensions() {
            return this != FILE;
        }

        public boolean permitsRpc() {
            return this == SERVICE;
        }
    }
}

