/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.java.net.cookiejar;

import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.internal.Internal;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/java/net/cookiejar/JavaNetCookieJar;", "Lokhttp3/CookieJar;", "cookieHandler", "Ljava/net/CookieHandler;", "(Ljava/net/CookieHandler;)V", "decodeHeaderAsJavaNetCookies", "", "Lokhttp3/Cookie;", "url", "Lokhttp3/HttpUrl;", "header", "", "loadForRequest", "saveFromResponse", "", "cookies", "okhttp-java-net-cookiejar"})
public final class JavaNetCookieJar
implements CookieJar {
    @NotNull
    private final CookieHandler cookieHandler;

    public JavaNetCookieJar(@NotNull CookieHandler cookieHandler) {
        Intrinsics.checkNotNullParameter((Object)cookieHandler, (String)"cookieHandler");
        this.cookieHandler = cookieHandler;
    }

    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        List cookieStrings = new ArrayList();
        for (Cookie cookie : cookies) {
            cookieStrings.add(Internal.cookieToString((Cookie)cookie, (boolean)true));
        }
        Map multimap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Set-Cookie", (Object)cookieStrings));
        try {
            this.cookieHandler.put(url.uri(), multimap);
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Saving cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull((Object)httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, (Throwable)e);
        }
    }

    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        Object object;
        Map<String, List<String>> map;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            map = this.cookieHandler.get(url.uri(), MapsKt.emptyMap());
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Loading cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull((Object)httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, (Throwable)e);
            return CollectionsKt.emptyList();
        }
        Map<String, List<String>> cookieHeaders = map;
        List cookies = null;
        Intrinsics.checkNotNull(cookieHeaders);
        for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (!StringsKt.equals((String)"Cookie", (String)key, (boolean)true) && !StringsKt.equals((String)"Cookie2", (String)key, (boolean)true)) continue;
            Intrinsics.checkNotNull(value);
            if (!(!((Collection)value).isEmpty())) continue;
            for (String header : value) {
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                Intrinsics.checkNotNull((Object)header);
                cookies.addAll((Collection)this.decodeHeaderAsJavaNetCookies(url, header));
            }
        }
        if (cookies != null) {
            List list = Collections.unmodifiableList(cookies);
            Intrinsics.checkNotNull((Object)list);
            object = list;
        } else {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl url, String header) {
        List result = new ArrayList();
        int pos = 0;
        int limit = header.length();
        int pairEnd = 0;
        while (pos < limit) {
            String value;
            pairEnd = _UtilCommonKt.delimiterOffset((String)header, (String)";,", (int)pos, (int)limit);
            int equalsSign = _UtilCommonKt.delimiterOffset((String)header, (char)'=', (int)pos, (int)pairEnd);
            String name = _UtilCommonKt.trimSubstring((String)header, (int)pos, (int)equalsSign);
            if (StringsKt.startsWith$default((String)name, (String)"$", (boolean)false, (int)2, null)) {
                pos = pairEnd + 1;
                continue;
            }
            String string = value = equalsSign < pairEnd ? _UtilCommonKt.trimSubstring((String)header, (int)(equalsSign + 1), (int)pairEnd) : "";
            if (StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && value.length() >= 2) {
                String string2 = value.substring(1, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                value = string2;
            }
            result.add(new Cookie.Builder().name(name).value(value).domain(url.host()).build());
            pos = pairEnd + 1;
        }
        return result;
    }
}

