/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.android.AndroidLogHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0006\u0010\u0015\u001a\u00020\rJ\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/platform/android/AndroidLog;", "", "<init>", "()V", "MAX_LOG_LENGTH", "", "configuredLoggers", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Ljava/util/logging/Logger;", "knownLoggers", "", "", "androidLog", "", "loggerName", "logLevel", "message", "t", "", "androidLog$okhttp", "loggerTag", "enable", "enableLogging", "logger", "tag", "okhttp"})
@SuppressSignatureCheck
public final class AndroidLog {
    @NotNull
    public static final AndroidLog INSTANCE;
    private static final int MAX_LOG_LENGTH = 4000;
    @NotNull
    private static final CopyOnWriteArraySet<Logger> configuredLoggers;
    @NotNull
    private static final Map<String, String> knownLoggers;

    private AndroidLog() {
    }

    public final void androidLog$okhttp(@NotNull String loggerName, int logLevel, @NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String tag = this.loggerTag(loggerName);
        if (Log.isLoggable((String)tag, (int)logLevel)) {
            String logMessage = message;
            if (t != null) {
                logMessage = logMessage + '\n' + Log.getStackTraceString((Throwable)t);
            }
            int length = logMessage.length();
            for (int i = 0; i < length; ++i) {
                int end;
                int newline = StringsKt.indexOf$default((CharSequence)logMessage, (char)'\n', (int)i, (boolean)false, (int)4, null);
                newline = newline != -1 ? newline : length;
                do {
                    end = Math.min(newline, i + 4000);
                    String string = logMessage.substring(i, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    Log.println((int)logLevel, (String)tag, (String)string);
                } while ((i = end) < newline);
            }
        }
    }

    public static /* synthetic */ void androidLog$okhttp$default(AndroidLog androidLog, String string, int n, String string2, Throwable throwable, int n2, Object object) {
        if ((n2 & 8) != 0) {
            throwable = null;
        }
        androidLog.androidLog$okhttp(string, n, string2, throwable);
    }

    private final String loggerTag(String loggerName) {
        String string = knownLoggers.get(loggerName);
        if (string == null) {
            string = StringsKt.take((String)loggerName, (int)23);
        }
        return string;
    }

    public final void enable() {
        try {
            for (Map.Entry<String, String> entry : knownLoggers.entrySet()) {
                String logger = entry.getKey();
                String tag = entry.getValue();
                this.enableLogging(logger, tag);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    private final void enableLogging(String logger, String tag) {
        Logger logger2 = Logger.getLogger(logger);
        if (configuredLoggers.add(logger2)) {
            logger2.setUseParentHandlers(false);
            logger2.setLevel(Log.isLoggable((String)tag, (int)3) ? Level.FINE : (Log.isLoggable((String)tag, (int)4) ? Level.INFO : Level.WARNING));
            logger2.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    static {
        String packageName;
        LinkedHashMap linkedHashMap;
        INSTANCE = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap $this$knownLoggers_u24lambda_u240 = linkedHashMap = new LinkedHashMap();
        boolean bl = false;
        Package package_ = OkHttpClient.class.getPackage();
        String string = packageName = package_ != null ? package_.getName() : null;
        if (packageName != null) {
            ((Map)$this$knownLoggers_u24lambda_u240).put(packageName, "OkHttp");
        }
        ((Map)$this$knownLoggers_u24lambda_u240).put(OkHttpClient.class.getName(), "okhttp.OkHttpClient");
        ((Map)$this$knownLoggers_u24lambda_u240).put(Http2.class.getName(), "okhttp.Http2");
        ((Map)$this$knownLoggers_u24lambda_u240).put(TaskRunner.class.getName(), "okhttp.TaskRunner");
        ((Map)$this$knownLoggers_u24lambda_u240).put("okhttp3.mockwebserver.MockWebServer", "okhttp.MockWebServer");
        knownLoggers = MapsKt.toMap((Map)linkedHashMap);
    }
}

