/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.google.auto.common;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.checker.nullness.qual.Nullable;
import shadow.com.google.auto.common.AnnotationMirrors;
import shadow.com.google.auto.common.MoreStreams;
import shadow.com.google.auto.common.MoreTypes;

public final class SimpleAnnotationMirror
implements AnnotationMirror {
    private final TypeElement annotationType;
    private final ImmutableMap<String, ? extends AnnotationValue> namedValues;
    private final ImmutableMap<ExecutableElement, ? extends AnnotationValue> elementValues;

    private SimpleAnnotationMirror(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        Preconditions.checkArgument((boolean)annotationType.getKind().equals((Object)ElementKind.ANNOTATION_TYPE), (String)"annotationType must be an annotation: %s", (Object)annotationType);
        LinkedHashMap values = new LinkedHashMap();
        LinkedHashMap<String, ? extends AnnotationValue> unusedValues = new LinkedHashMap<String, AnnotationValue>(namedValues);
        ArrayList<String> missingMembers = new ArrayList<String>();
        for (ExecutableElement method2 : ElementFilter.methodsIn(annotationType.getEnclosedElements())) {
            String memberName = method2.getSimpleName().toString();
            if (unusedValues.containsKey(memberName)) {
                values.put(memberName, unusedValues.remove(memberName));
                continue;
            }
            if (method2.getDefaultValue() != null) {
                values.put(memberName, method2.getDefaultValue());
                continue;
            }
            missingMembers.add(memberName);
        }
        Preconditions.checkArgument((boolean)unusedValues.isEmpty(), (String)"namedValues has entries for members that are not in %s: %s", (Object)annotationType, unusedValues);
        Preconditions.checkArgument((boolean)missingMembers.isEmpty(), (String)"namedValues is missing entries for: %s", missingMembers);
        this.annotationType = annotationType;
        this.namedValues = ImmutableMap.copyOf(namedValues);
        this.elementValues = ElementFilter.methodsIn(annotationType.getEnclosedElements()).stream().collect(MoreStreams.toImmutableMap(e -> e, e -> (AnnotationValue)values.get(e.getSimpleName().toString())));
    }

    public static AnnotationMirror of(TypeElement annotationType) {
        return SimpleAnnotationMirror.of(annotationType, (Map<String, ? extends AnnotationValue>)ImmutableMap.of());
    }

    public static AnnotationMirror of(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        return new SimpleAnnotationMirror(annotationType, namedValues);
    }

    @Override
    public DeclaredType getAnnotationType() {
        return MoreTypes.asDeclared(this.annotationType.asType());
    }

    public Map<ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return this.elementValues;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("@").append(this.annotationType.getQualifiedName());
        if (!this.namedValues.isEmpty()) {
            builder.append('(').append(Joiner.on((String)", ").withKeyValueSeparator(" = ").join(this.namedValues)).append(')');
        }
        return builder.toString();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AnnotationMirror && AnnotationMirrors.equivalence().equivalent((Object)this, (Object)((AnnotationMirror)other));
    }

    public int hashCode() {
        return AnnotationMirrors.equivalence().hash((Object)this);
    }
}

