/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.widget.Switch;
import org.assertj.android.api.widget.AbstractCompoundButtonAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=14)
public class SwitchAssert
extends AbstractCompoundButtonAssert<SwitchAssert, Switch> {
    public SwitchAssert(Switch actual) {
        super(actual, SwitchAssert.class);
    }

    @TargetApi(value=16)
    public SwitchAssert hasSwitchMinWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Switch)this.actual).getSwitchMinWidth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected switch min width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    @TargetApi(value=16)
    public SwitchAssert hasSwitchPadding(int padding) {
        this.isNotNull();
        int actualPadding = ((Switch)this.actual).getSwitchPadding();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected switch padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    public SwitchAssert hasOnText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((Switch)this.actual).getTextOn();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected 'on' text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    public SwitchAssert hasOnText(int resId) {
        this.isNotNull();
        return this.hasOnText(((Switch)this.actual).getContext().getString(resId));
    }

    public SwitchAssert hasOffText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((Switch)this.actual).getTextOff();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actualText).overridingErrorMessage("Expected 'off' text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    public SwitchAssert hasOffText(int resId) {
        this.isNotNull();
        return this.hasOffText(((Switch)this.actual).getContext().getString(resId));
    }

    @TargetApi(value=16)
    public SwitchAssert hasThumbDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((Switch)this.actual).getThumbDrawable();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected thumb drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return this;
    }

    @TargetApi(value=16)
    public SwitchAssert hasThumbTextPadding(int padding) {
        this.isNotNull();
        int actualPadding = ((Switch)this.actual).getThumbTextPadding();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected thumb text padding <%s> but was <%s>.", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return this;
    }

    @TargetApi(value=16)
    public SwitchAssert hasTrackDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((Switch)this.actual).getTrackDrawable();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected track drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return this;
    }
}

