/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.widget.DatePicker;
import org.assertj.android.api.widget.AbstractFrameLayoutAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public class DatePickerAssert
extends AbstractFrameLayoutAssert<DatePickerAssert, DatePicker> {
    public DatePickerAssert(DatePicker actual) {
        super(actual, DatePickerAssert.class);
    }

    @TargetApi(value=11)
    public DatePickerAssert isShowingCalendarView() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getCalendarViewShown()).overridingErrorMessage("Expected calendar view to be showing but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=11)
    public DatePickerAssert isNotShowingCalendarView() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getCalendarViewShown()).overridingErrorMessage("Expected calendar view to not be showing but was.", new Object[0])).isFalse();
        return this;
    }

    public DatePickerAssert hasDayOfMonth(int day) {
        this.isNotNull();
        int actualDay = ((DatePicker)this.actual).getDayOfMonth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDay).overridingErrorMessage("Expected day of month <%s> but was <%s>.", new Object[]{day, actualDay})).isEqualTo(day);
        return this;
    }

    @TargetApi(value=11)
    public DatePickerAssert hasMaxDate(long date) {
        this.isNotNull();
        long actualDate = ((DatePicker)this.actual).getMaxDate();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDate).overridingErrorMessage("Expected max date <%s> but was <%s>.", new Object[]{date, actualDate})).isEqualTo(date);
        return this;
    }

    @TargetApi(value=11)
    public DatePickerAssert hasMinDate(long date) {
        this.isNotNull();
        long actualDate = ((DatePicker)this.actual).getMinDate();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDate).overridingErrorMessage("Expected min date <%s> but was <%s>.", new Object[]{date, actualDate})).isEqualTo(date);
        return this;
    }

    public DatePickerAssert hasMonth(int month) {
        this.isNotNull();
        int actualMonth = ((DatePicker)this.actual).getMonth();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualMonth).overridingErrorMessage("Expected month <%s> but was <%s>.", new Object[]{month, actualMonth})).isEqualTo(month);
        return this;
    }

    @TargetApi(value=11)
    public DatePickerAssert isShowingSpinners() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getSpinnersShown()).overridingErrorMessage("Expected to be showing spinners but was not.", new Object[0])).isTrue();
        return this;
    }

    @TargetApi(value=11)
    public DatePickerAssert isNotShowingSpinners() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getSpinnersShown()).overridingErrorMessage("Expected to not be showing spinners but was.", new Object[0])).isFalse();
        return this;
    }

    public DatePickerAssert hasYear(int year) {
        this.isNotNull();
        int actualYear = ((DatePicker)this.actual).getYear();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualYear).overridingErrorMessage("Expected year <%s> but was <%s>.", new Object[]{year, actualYear})).isEqualTo(year);
        return this;
    }
}

