/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.widget;

import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.widget.CalendarView;
import org.assertj.android.api.widget.AbstractFrameLayoutAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public class CalendarViewAssert
extends AbstractFrameLayoutAssert<CalendarViewAssert, CalendarView> {
    public CalendarViewAssert(CalendarView actual) {
        super(actual, CalendarViewAssert.class);
    }

    public CalendarViewAssert hasDate(long date) {
        this.isNotNull();
        long actualDate = ((CalendarView)this.actual).getDate();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDate).overridingErrorMessage("Expected date <%s> but was <%s>.", new Object[]{date, actualDate})).isEqualTo(date);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasDateTextAppearance(int resId) {
        this.isNotNull();
        int actualResId = ((CalendarView)this.actual).getDateTextAppearance();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualResId).overridingErrorMessage("Expected date text appearance resource ID <%s> but was <%s>.", new Object[]{resId, actualResId})).isEqualTo(resId);
        return this;
    }

    public CalendarViewAssert hasFirstDayOfWeek(int day) {
        this.isNotNull();
        int actualDay = ((CalendarView)this.actual).getFirstDayOfWeek();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDay).overridingErrorMessage("Expected first day of week <%s> but was <%s>.", new Object[]{day, actualDay})).isEqualTo(day);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasFocusedMonthDateColor(int color) {
        this.isNotNull();
        int actualColor = ((CalendarView)this.actual).getFocusedMonthDateColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected focused month date color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public CalendarViewAssert hasMaxDate(long date) {
        this.isNotNull();
        long actualDate = ((CalendarView)this.actual).getMaxDate();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDate).overridingErrorMessage("Expected max date <%s> but was <%s>.", new Object[]{date, actualDate})).isEqualTo(date);
        return this;
    }

    public CalendarViewAssert hasMinDate(long date) {
        this.isNotNull();
        long actualDate = ((CalendarView)this.actual).getMinDate();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDate).overridingErrorMessage("Expected min date <%s> but was <%s>.", new Object[]{date, actualDate})).isEqualTo(date);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasSelectedDateVerticalBar(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((CalendarView)this.actual).getSelectedDateVerticalBar();
        ((AbstractObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected selected date vertical bar <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasSelectedWeekBackgroundColor(int color) {
        this.isNotNull();
        int actualColor = ((CalendarView)this.actual).getSelectedWeekBackgroundColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected selected week background color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    public CalendarViewAssert isShowingWeekNumber() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((CalendarView)this.actual).getShowWeekNumber()).overridingErrorMessage("Expected to be showing week number but was not.", new Object[0])).isTrue();
        return this;
    }

    public CalendarViewAssert isNotShowingWeekNumber() {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((CalendarView)this.actual).getShowWeekNumber()).overridingErrorMessage("Expected to not be showing week number but was.", new Object[0])).isFalse();
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasShownWeekCount(int count) {
        this.isNotNull();
        int actualCount = ((CalendarView)this.actual).getShownWeekCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected shown week count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasUnfocusedMonthDateColor(int color) {
        this.isNotNull();
        int actualColor = ((CalendarView)this.actual).getUnfocusedMonthDateColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected unfocused month date color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasWeekDayTextAppearance(int resId) {
        this.isNotNull();
        int actualResId = ((CalendarView)this.actual).getWeekDayTextAppearance();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualResId).overridingErrorMessage("Expected week day text appearance res ID <%s> but was <%s>.", new Object[]{resId, actualResId})).isEqualTo(resId);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasWeekNumberColor(int color) {
        this.isNotNull();
        int actualColor = ((CalendarView)this.actual).getWeekNumberColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected week number color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }

    @TargetApi(value=16)
    public CalendarViewAssert hasWeekSeparatorLineColor(int color) {
        this.isNotNull();
        int actualColor = ((CalendarView)this.actual).getWeekSeparatorLineColor();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected week separator line color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return this;
    }
}

