/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.util;

import android.util.DisplayMetrics;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class DisplayMetricsAssert
extends AbstractAssert<DisplayMetricsAssert, DisplayMetrics> {
    public DisplayMetricsAssert(DisplayMetrics actual) {
        super((Object)actual, DisplayMetricsAssert.class);
    }

    public DisplayMetricsAssert hasDensity(float density) {
        this.isNotNull();
        float actualDensity = ((DisplayMetrics)this.actual).density;
        ((AbstractFloatAssert)Assertions.assertThat((float)actualDensity).overridingErrorMessage("Expected density <%s> but was <%s>.", new Object[]{Float.valueOf(density), Float.valueOf(actualDensity)})).isEqualTo(density);
        return this;
    }

    public DisplayMetricsAssert hasDpi(int dpi) {
        this.isNotNull();
        int actualDpi = ((DisplayMetrics)this.actual).densityDpi;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualDpi).overridingErrorMessage("Expected DPI <%s> but was <%s>.", new Object[]{dpi, actualDpi})).isEqualTo(dpi);
        return this;
    }

    public DisplayMetricsAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((DisplayMetrics)this.actual).heightPixels;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public DisplayMetricsAssert hasScaledDensity(float scaledDensity) {
        this.isNotNull();
        float actualDensity = ((DisplayMetrics)this.actual).scaledDensity;
        ((AbstractFloatAssert)Assertions.assertThat((float)actualDensity).overridingErrorMessage("Expected scaled density <%s> but was <%s>.", new Object[]{Float.valueOf(scaledDensity), Float.valueOf(actualDensity)})).isEqualTo(scaledDensity);
        return this;
    }

    public DisplayMetricsAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((DisplayMetrics)this.actual).widthPixels;
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public DisplayMetricsAssert hasXDpi(float xDpi) {
        this.isNotNull();
        float actualXDpi = ((DisplayMetrics)this.actual).xdpi;
        ((AbstractFloatAssert)Assertions.assertThat((float)actualXDpi).overridingErrorMessage("Expected X DPI <%s> but was <%s>.", new Object[]{Float.valueOf(xDpi), Float.valueOf(actualXDpi)})).isEqualTo(xDpi);
        return this;
    }

    public DisplayMetricsAssert hasYDpi(float yDpi) {
        this.isNotNull();
        float actualYDpi = ((DisplayMetrics)this.actual).ydpi;
        ((AbstractFloatAssert)Assertions.assertThat((float)actualYDpi).overridingErrorMessage("Expected Y DPI <%s> but was <%s>.", new Object[]{Float.valueOf(yDpi), Float.valueOf(actualYDpi)})).isEqualTo(yDpi);
        return this;
    }
}

