/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.content;

import android.annotation.TargetApi;
import android.content.CursorLoader;
import android.net.Uri;
import java.util.Arrays;
import org.assertj.android.api.content.AbstractLoaderAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assertions;

@TargetApi(value=11)
public class CursorLoaderAssert
extends AbstractLoaderAssert<CursorLoaderAssert, CursorLoader> {
    public CursorLoaderAssert(CursorLoader actual) {
        super(actual, CursorLoaderAssert.class);
    }

    public CursorLoaderAssert hasProjection(String ... projection) {
        this.isNotNull();
        Assertions.assertThat((Object[])((CursorLoader)this.actual).getProjection()).isEqualTo((Object)projection);
        return this;
    }

    public CursorLoaderAssert doesNotHaveProjection() {
        this.isNotNull();
        Object[] projection = ((CursorLoader)this.actual).getProjection();
        ((AbstractObjectArrayAssert)Assertions.assertThat((Object[])projection).overridingErrorMessage("Expected no projection but was <%s>.", new Object[]{Arrays.toString(projection)})).isNullOrEmpty();
        return this;
    }

    public CursorLoaderAssert projectionContains(String ... projection) {
        this.isNotNull();
        Assertions.assertThat((Object[])((CursorLoader)this.actual).getProjection()).contains((Object[])projection);
        return this;
    }

    public CursorLoaderAssert hasSelection(String selection) {
        this.isNotNull();
        String actualSelection = ((CursorLoader)this.actual).getSelection();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualSelection).overridingErrorMessage("Expected cursor selection <%s> but was <%s>.", new Object[]{selection, actualSelection})).isEqualTo((Object)selection);
        return this;
    }

    public CursorLoaderAssert doesNotHaveSelection() {
        this.isNotNull();
        String selection = ((CursorLoader)this.actual).getSelection();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)selection).overridingErrorMessage("Expected no selection but was <%s>.", new Object[]{selection})).isNullOrEmpty();
        return this;
    }

    public CursorLoaderAssert hasSelectionArgs(String ... selectionArgs) {
        this.isNotNull();
        Assertions.assertThat((Object[])((CursorLoader)this.actual).getSelectionArgs()).isEqualTo((Object)selectionArgs);
        return this;
    }

    public CursorLoaderAssert doesNotHaveSelectionArgs() {
        this.isNotNull();
        Object[] selectionArgs = ((CursorLoader)this.actual).getSelectionArgs();
        ((AbstractObjectArrayAssert)Assertions.assertThat((Object[])selectionArgs).overridingErrorMessage("Excpected no selection arguments but was <%s>.", new Object[]{Arrays.toString(selectionArgs)})).isNullOrEmpty();
        return this;
    }

    public CursorLoaderAssert containsSelectionArgs(String ... selectionArgs) {
        this.isNotNull();
        Assertions.assertThat((Object[])((CursorLoader)this.actual).getSelectionArgs()).contains((Object[])selectionArgs);
        return this;
    }

    public CursorLoaderAssert hasSortOrder(String sortOrder) {
        this.isNotNull();
        String actualSortOrder = ((CursorLoader)this.actual).getSortOrder();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualSortOrder).overridingErrorMessage("Expected cursor sort order <%s> but was <%s>.", new Object[]{sortOrder, actualSortOrder})).isEqualTo((Object)sortOrder);
        return this;
    }

    public CursorLoaderAssert doesNotHaveSortOrder() {
        this.isNotNull();
        String sortOrder = ((CursorLoader)this.actual).getSortOrder();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)sortOrder).overridingErrorMessage("Expected no sort order but was <%s>.", new Object[]{sortOrder})).isNullOrEmpty();
        return this;
    }

    public CursorLoaderAssert hasUri(Uri uri) {
        this.isNotNull();
        Uri actualUri = ((CursorLoader)this.actual).getUri();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualUri).overridingErrorMessage("Expected cursor URI <%s> but was <%s>.", new Object[]{uri, actualUri})).isEqualTo((Object)uri);
        return this;
    }
}

