/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class BluetoothDeviceAssert
extends AbstractAssert<BluetoothDeviceAssert, BluetoothDevice> {
    public BluetoothDeviceAssert(BluetoothDevice actual) {
        super((Object)actual, BluetoothDeviceAssert.class);
    }

    public BluetoothDeviceAssert hasAddress(String address) {
        this.isNotNull();
        String actualAddress = ((BluetoothDevice)this.actual).getAddress();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualAddress).overridingErrorMessage("Expected address <%s> but was <%s>.", new Object[]{address, actualAddress})).isEqualTo((Object)address);
        return this;
    }

    public BluetoothDeviceAssert hasBondState(int state) {
        this.isNotNull();
        int actualState = ((BluetoothDevice)this.actual).getBondState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected bond state <%s> but was <%s>.", new Object[]{BluetoothDeviceAssert.bondStateToString(state), BluetoothDeviceAssert.bondStateToString(actualState)})).isEqualTo(state);
        return this;
    }

    public BluetoothDeviceAssert hasName(String name) {
        this.isNotNull();
        String actualName = ((BluetoothDevice)this.actual).getName();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    @TargetApi(value=18)
    public BluetoothDeviceAssert hasType(int type) {
        this.isNotNull();
        int actualType = ((BluetoothDevice)this.actual).getType();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected type <%s> but was <%s>.", new Object[]{BluetoothDeviceAssert.typeToString(type), BluetoothDeviceAssert.typeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public static String bondStateToString(int state) {
        return IntegerUtils.buildNamedValueString(state).value(10, "none").value(12, "bonded").value(11, "bonding").get();
    }

    @TargetApi(value=18)
    public static String typeToString(int type) {
        return IntegerUtils.buildNamedValueString(type).value(1, "classic").value(3, "dual").value(2, "le").value(0, "unknown").get();
    }
}

