/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.android.api.bluetooth;

import android.bluetooth.BluetoothClass;
import org.assertj.android.internal.IntegerUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class BluetoothClassAssert
extends AbstractAssert<BluetoothClassAssert, BluetoothClass> {
    public BluetoothClassAssert(BluetoothClass actual) {
        super((Object)actual, BluetoothClassAssert.class);
    }

    public BluetoothClassAssert hasDeviceClass(int deviceClass) {
        this.isNotNull();
        int actualClass = ((BluetoothClass)this.actual).getDeviceClass();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualClass).overridingErrorMessage("Expected device class <%s> but was <%s>.", new Object[]{BluetoothClassAssert.deviceClassToString(deviceClass), BluetoothClassAssert.deviceClassToString(actualClass)})).isEqualTo(actualClass);
        return this;
    }

    public BluetoothClassAssert hasMajorDeviceClass(int majorDeviceClass) {
        this.isNotNull();
        int actualMajorDeviceClass = ((BluetoothClass)this.actual).getMajorDeviceClass();
        ((AbstractIntegerAssert)Assertions.assertThat((int)majorDeviceClass).overridingErrorMessage("Expected major device class <%s> but was <%s>.", new Object[]{BluetoothClassAssert.majorDeviceClassToString(majorDeviceClass), BluetoothClassAssert.majorDeviceClassToString(actualMajorDeviceClass)})).isEqualTo(majorDeviceClass);
        return this;
    }

    public BluetoothClassAssert hasService(int service) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((BluetoothClass)this.actual).hasService(service)).overridingErrorMessage("Expected to have service <%s> but did not.", new Object[]{BluetoothClassAssert.serviceToString(service)})).isTrue();
        return this;
    }

    public BluetoothClassAssert doesNotHave(int service) {
        this.isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((BluetoothClass)this.actual).hasService(service)).overridingErrorMessage("Expected to not have service <%s> but did.", new Object[]{BluetoothClassAssert.serviceToString(service)})).isTrue();
        return this;
    }

    public static String deviceClassToString(int deviceClass) {
        return IntegerUtils.buildNamedValueString(deviceClass).value(1076, "AUDIO_VIDEO_CAMCORDER").value(1056, "AUDIO_VIDEO_CAR_AUDIO").value(1032, "AUDIO_VIDEO_HANDSFREE").value(1048, "AUDIO_VIDEO_HEADPHONES").value(1064, "AUDIO_VIDEO_HIFI_AUDIO").value(1044, "AUDIO_VIDEO_LOUDSPEAKER").value(1040, "AUDIO_VIDEO_MICROPHONE").value(1052, "AUDIO_VIDEO_PORTABLE_AUDIO").value(1060, "AUDIO_VIDEO_SET_TOP_BOX").value(1024, "AUDIO_VIDEO_UNCATEGORIZED").value(1068, "AUDIO_VIDEO_VCR").value(1072, "AUDIO_VIDEO_VIDEO_CAMERA").value(1088, "AUDIO_VIDEO_VIDEO_CONFERENCING").value(1084, "AUDIO_VIDEO_VIDEO_DISPLAY_AND_LOUDSPEAKER").value(1096, "AUDIO_VIDEO_VIDEO_GAMING_TOY").value(1080, "AUDIO_VIDEO_VIDEO_MONITOR").value(1028, "AUDIO_VIDEO_WEARABLE_HEADSET").value(260, "COMPUTER_DESKTOP").value(272, "COMPUTER_HANDHELD_PC_PDA").value(268, "COMPUTER_LAPTOP").value(276, "COMPUTER_PALM_SIZE_PC_PDA").value(264, "COMPUTER_SERVER").value(256, "COMPUTER_UNCATEGORIZED").value(280, "COMPUTER_WEARABLE").value(2308, "HEALTH_BLOOD_PRESSURE").value(2332, "HEALTH_DATA_DISPLAY").value(2320, "HEALTH_GLUCOSE").value(2324, "HEALTH_PULSE_OXIMETER").value(2328, "HEALTH_PULSE_RATE").value(2312, "HEALTH_THERMOMETER").value(2304, "HEALTH_UNCATEGORIZED").value(2316, "HEALTH_WEIGHING").value(516, "PHONE_CELLULAR").value(520, "PHONE_CORDLESS").value(532, "PHONE_ISDN").value(528, "PHONE_MODEM_OR_GATEWAY").value(524, "PHONE_SMART").value(512, "PHONE_UNCATEGORIZED").value(2064, "TOY_CONTROLLER").value(2060, "TOY_DOLL_ACTION_FIGURE").value(2068, "TOY_GAME").value(2052, "TOY_ROBOT").value(2048, "TOY_UNCATEGORIZED").value(2056, "TOY_VEHICLE").value(1812, "WEARABLE_GLASSES").value(1808, "WEARABLE_HELMET").value(1804, "WEARABLE_JACKET").value(1800, "WEARABLE_PAGER").value(1792, "WEARABLE_UNCATEGORIZED").value(1796, "WEARABLE_WRIST_WATCH").get();
    }

    public static String majorDeviceClassToString(int majorDeviceClass) {
        return IntegerUtils.buildNamedValueString(majorDeviceClass).value(1024, "audio_video").value(256, "computer").value(2304, "health").value(1536, "imaging").value(0, "misc").value(768, "networking").value(1280, "peripheral").value(512, "phone").value(2048, "toy").value(7936, "uncategorized").value(1792, "wearable").get();
    }

    public static String serviceToString(int service) {
        return IntegerUtils.buildNamedValueString(service).value(0x200000, "audio").value(524288, "capture").value(0x800000, "information").value(8192, "limited_discoverability").value(131072, "networking").value(0x100000, "object_transfer").value(65536, "positioning").value(262144, "render").value(0x400000, "telephony").get();
    }
}

