/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal.reference;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.api.AnvilCompilationException;
import com.squareup.anvil.compiler.internal.DescriptorUtilsKt;
import com.squareup.anvil.compiler.internal.FqNameKt;
import com.squareup.anvil.compiler.internal.KotlinPoetUtilsKt;
import com.squareup.anvil.compiler.internal.PsiUtilsKt;
import com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor;
import com.squareup.anvil.compiler.internal.reference.ClassReference;
import com.squareup.anvil.compiler.internal.reference.ClassReferenceKt;
import com.squareup.anvil.compiler.internal.reference.TypeReference$Psi$requireTypeName$findExtendsBound$;
import com.squareup.anvil.compiler.internal.reference.TypeReference$Psi$requireTypeName$isTypeParameter$;
import com.squareup.anvil.compiler.internal.reference.TypeReferenceKt;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeVariableName;
import com.squareup.kotlinpoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtFunctionTypeReceiver;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002%&B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0017\u001a\u00020\u0004J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0019\u001a\u00020\u000eJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001b\u001a\u00020\u001cH&J\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u001cH&J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u0004J\u0012\u0010!\u001a\u0004\u0018\u00010\u00002\u0006\u0010 \u001a\u00020\u0004H&J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0004J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0002'(\u00a8\u0006)"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "", "()V", "classReference", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getClassReference", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "declaringClass", "getDeclaringClass", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "typeName", "Lcom/squareup/kotlinpoet/TypeName;", "getTypeName", "()Lcom/squareup/kotlinpoet/TypeName;", "typeNameOrNull", "getTypeNameOrNull", "unwrappedTypes", "", "getUnwrappedTypes", "()Ljava/util/List;", "asClassReference", "asClassReferenceOrNull", "asTypeName", "asTypeNameOrNull", "isFunctionType", "", "isGenericType", "isNullable", "resolveGenericTypeNameOrNull", "implementingClass", "resolveGenericTypeOrNull", "resolveGenericTypeOrSelf", "toString", "", "Descriptor", "Psi", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "compiler-utils"})
@ExperimentalAnvilApi
public abstract class TypeReference {
    private TypeReference() {
    }

    @Nullable
    public abstract ClassReference getDeclaringClass();

    @Nullable
    protected abstract ClassReference getClassReference();

    @Nullable
    protected abstract TypeName getTypeNameOrNull();

    @NotNull
    protected abstract TypeName getTypeName();

    @NotNull
    public abstract List<TypeReference> getUnwrappedTypes();

    @NotNull
    public abstract AnvilModuleDescriptor getModule();

    @Nullable
    public final ClassReference asClassReferenceOrNull() {
        return this.getClassReference();
    }

    @NotNull
    public final ClassReference asClassReference() {
        ClassReference classReference2 = this.getClassReference();
        if (classReference2 == null) {
            throw TypeReferenceKt.AnvilCompilationExceptionTypReference$default(this, "Unable to convert a type reference to a class reference.", null, 4, null);
        }
        return classReference2;
    }

    @Nullable
    public final TypeName asTypeNameOrNull() {
        return this.getTypeNameOrNull();
    }

    @NotNull
    public final TypeName asTypeName() {
        return this.getTypeName();
    }

    @Nullable
    public abstract TypeReference resolveGenericTypeOrNull(@NotNull ClassReference var1);

    @Nullable
    public final TypeName resolveGenericTypeNameOrNull(@NotNull ClassReference implementingClass) {
        Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
        ClassReference classReference2 = this.asClassReferenceOrNull();
        if (classReference2 != null) {
            ClassReference it = classReference2;
            boolean bl = false;
            return this.asTypeName();
        }
        return this.resolveGenericTypeOrSelf(implementingClass).asTypeNameOrNull();
    }

    @NotNull
    public final TypeReference resolveGenericTypeOrSelf(@NotNull ClassReference implementingClass) {
        Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
        if (!this.isGenericType()) {
            return this;
        }
        TypeReference typeReference = this.resolveGenericTypeOrNull(implementingClass);
        if (typeReference == null) {
            typeReference = this;
        }
        return typeReference;
    }

    public final boolean isGenericType() {
        ClassReference classReference2 = this.asClassReferenceOrNull();
        return classReference2 != null ? classReference2.isGenericClass() : true;
    }

    public abstract boolean isFunctionType();

    public abstract boolean isNullable();

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + "(declaringClass=" + this.getDeclaringClass() + ", classReference=" + this.getClassReference() + ')';
    }

    public /* synthetic */ TypeReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b$J\u0012\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0005H\u0016J\u000e\u0010&\u001a\u0004\u0018\u00010\u0014*\u00020\u0003H\u0002R\u001d\u0010\t\u001a\u0004\u0018\u00010\u00058TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00148TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\r\u001a\u0004\b\u0018\u0010\u0016R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lcom/squareup/anvil/compiler/internal/reference/ClassReference;Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;)V", "classReference", "getClassReference", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "classReference$delegate", "Lkotlin/Lazy;", "getDeclaringClass", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "typeName", "Lcom/squareup/kotlinpoet/TypeName;", "getTypeName", "()Lcom/squareup/kotlinpoet/TypeName;", "typeNameOrNull", "getTypeNameOrNull", "typeNameOrNull$delegate", "unwrappedTypes", "", "getUnwrappedTypes", "()Ljava/util/List;", "unwrappedTypes$delegate", "isFunctionType", "", "isNullable", "resolveGenericKotlinTypeOrNull", "implementingClass", "resolveGenericKotlinTypeOrNull$compiler_utils", "resolveGenericTypeOrNull", "asTypeNameOrNull", "compiler-utils"})
    @SourceDebugExtension(value={"SMAP\nTypeReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeReference.kt\ncom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,679:1\n1#2:680\n1549#3:681\n1620#3,3:682\n*S KotlinDebug\n*F\n+ 1 TypeReference.kt\ncom/squareup/anvil/compiler/internal/reference/TypeReference$Descriptor\n*L\n462#1:681\n462#1:682,3\n*E\n"})
    public static final class Descriptor
    extends TypeReference {
        @NotNull
        private final KotlinType type;
        @Nullable
        private final ClassReference declaringClass;
        @NotNull
        private final AnvilModuleDescriptor module;
        @NotNull
        private final Lazy classReference$delegate;
        @NotNull
        private final Lazy typeNameOrNull$delegate;
        @NotNull
        private final Lazy unwrappedTypes$delegate;

        public Descriptor(@NotNull KotlinType type2, @Nullable ClassReference declaringClass, @NotNull AnvilModuleDescriptor module) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(null);
            this.type = type2;
            this.declaringClass = declaringClass;
            this.module = module;
            this.classReference$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ClassReference.Descriptor>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final ClassReference.Descriptor invoke() {
                    ClassDescriptor classDescriptor = DescriptorUtilsKt.classDescriptorOrNull(this.this$0.getType());
                    return classDescriptor != null ? ClassReferenceKt.toClassReference(classDescriptor, (ModuleDescriptor)this.this$0.getModule()) : null;
                }
            }));
            this.typeNameOrNull$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<TypeName>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final TypeName invoke() {
                    TypeName typeName2 = Descriptor.access$asTypeNameOrNull(this.this$0, this.this$0.getType());
                    return typeName2 != null ? TypeReferenceKt.access$lambdaFix(typeName2) : null;
                }
            }));
            this.unwrappedTypes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.this$0.getType().getArguments();
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        KotlinType kotlinType = it.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                        collection.add(TypeReferenceKt.toTypeReference(kotlinType, descriptor.getDeclaringClass(), descriptor.getModule()));
                    }
                    return (List)destination$iv$iv;
                }
            }));
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        @Override
        @Nullable
        public ClassReference getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        @NotNull
        public AnvilModuleDescriptor getModule() {
            return this.module;
        }

        @Override
        @Nullable
        protected ClassReference getClassReference() {
            Lazy lazy = this.classReference$delegate;
            return (ClassReference)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeName getTypeNameOrNull() {
            Lazy lazy = this.typeNameOrNull$delegate;
            return (TypeName)lazy.getValue();
        }

        @Override
        @NotNull
        protected TypeName getTypeName() {
            TypeName typeName2 = this.getTypeNameOrNull();
            if (typeName2 == null) {
                ClassReference classReference2 = this.getDeclaringClass();
                throw TypeReferenceKt.AnvilCompilationExceptionTypReference$default(this, "Unable to convert the Kotlin type " + this.type + " to a type name for declaring class " + (classReference2 != null ? classReference2.getFqName() : null) + '.', null, 4, null);
            }
            return typeName2;
        }

        @NotNull
        public List<Descriptor> getUnwrappedTypes() {
            Lazy lazy = this.unwrappedTypes$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        public TypeReference resolveGenericTypeOrNull(@NotNull ClassReference implementingClass) {
            Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
            return this.resolveGenericKotlinTypeOrNull$compiler_utils(implementingClass);
        }

        @Nullable
        public final TypeReference resolveGenericKotlinTypeOrNull$compiler_utils(@NotNull ClassReference implementingClass) {
            KotlinType parameterKotlinType;
            FqName fqName;
            Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
            ClassDescriptor classDescriptor = DescriptorUtilsKt.classDescriptorOrNull(this.type);
            if (classDescriptor != null && (fqName = org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor))) != null) {
                FqName it = fqName;
                boolean bl = false;
                return this;
            }
            fqName = this.type;
            KotlinType kotlinType = fqName instanceof FlexibleType ? (KotlinType)(((FlexibleType)this.type).getLowerBound().isMarkedNullable() ? ((FlexibleType)this.type).getUpperBound() : ((FlexibleType)this.type).getLowerBound()) : (parameterKotlinType = fqName instanceof DefinitelyNotNullType ? (KotlinType)((DefinitelyNotNullType)this.type).getOriginal() : this.type);
            if (this.getDeclaringClass() == null) {
                return null;
            }
            return TypeReferenceKt.access$resolveGenericTypeReference(implementingClass, this.getDeclaringClass(), parameterKotlinType.toString(), this.getModule());
        }

        @Override
        public boolean isFunctionType() {
            return FunctionTypesKt.isFunctionType((KotlinType)this.type);
        }

        @Override
        public boolean isNullable() {
            return KotlinTypeKt.isNullable((KotlinType)this.type);
        }

        /*
         * WARNING - void declaration
         */
        private final TypeName asTypeNameOrNull(KotlinType $this$asTypeNameOrNull) {
            void $this$mapTo$iv$iv;
            if (TypeUtilsKt.isTypeParameter((KotlinType)$this$asTypeNameOrNull)) {
                return (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)$this$asTypeNameOrNull.toString(), null, (int)2, null);
            }
            ClassName className = KotlinPoetUtilsKt.asClassName(DescriptorUtilsKt.classDescriptor($this$asTypeNameOrNull));
            if ($this$asTypeNameOrNull.getArguments().isEmpty()) {
                return TypeName.copy$default((TypeName)((TypeName)className), (boolean)$this$asTypeNameOrNull.isMarkedNullable(), null, (int)2, null);
            }
            Iterable $this$map$iv = $this$asTypeNameOrNull.getArguments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TypeName typeName2;
                void typeProjection;
                TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (typeProjection.isStarProjection()) {
                    typeName2 = (TypeName)TypeNames.STAR;
                } else {
                    KotlinType kotlinType = typeProjection.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    if (this.asTypeNameOrNull(kotlinType) == null) {
                        return null;
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[typeProjection.getProjectionKind().ordinal()]) {
                        case 1: {
                            TypeName typeName3;
                            typeName2 = typeName3;
                            break;
                        }
                        case 2: {
                            TypeName typeName3;
                            typeName2 = (TypeName)WildcardTypeName.Companion.producerOf(typeName3);
                            break;
                        }
                        case 3: {
                            TypeName typeName3;
                            typeName2 = (TypeName)WildcardTypeName.Companion.consumerOf(typeName3);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                collection.add(typeName2);
            }
            List argumentTypeNames = (List)destination$iv$iv;
            return TypeName.copy$default((TypeName)((TypeName)ParameterizedTypeName.Companion.get(className, argumentTypeNames)), (boolean)$this$asTypeNameOrNull.isMarkedNullable(), null, (int)2, null);
        }

        public static final /* synthetic */ TypeName access$asTypeNameOrNull(Descriptor $this, KotlinType $receiver) {
            return $this.asTypeNameOrNull($receiver);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Variance.values().length];
                try {
                    nArray[Variance.INVARIANT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Variance.OUT_VARIANCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Variance.IN_VARIANCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010&\u001a\u00020\nH\u0016J\u0015\u0010'\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b(J\f\u0010)\u001a\u00020\u0016*\u00020\u0003H\u0002R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000e\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0018R!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000e\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/TypeReference$Psi;", "Lcom/squareup/anvil/compiler/internal/reference/TypeReference;", "type", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;)V", "classReference", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getClassReference", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "classReference$delegate", "Lkotlin/Lazy;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "getType", "()Lorg/jetbrains/kotlin/psi/KtTypeReference;", "typeName", "Lcom/squareup/kotlinpoet/TypeName;", "getTypeName", "()Lcom/squareup/kotlinpoet/TypeName;", "typeName$delegate", "typeNameOrNull", "getTypeNameOrNull", "unwrappedTypes", "", "getUnwrappedTypes", "()Ljava/util/List;", "unwrappedTypes$delegate", "findUnwrappedTypesWithTypeAlias", "isFunctionType", "", "isNullable", "resolveGenericTypeOrNull", "implementingClass", "resolveTypeReference", "resolveTypeReference$compiler_utils", "requireTypeName", "compiler-utils"})
    @SourceDebugExtension(value={"SMAP\nTypeReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeReference.kt\ncom/squareup/anvil/compiler/internal/reference/TypeReference$Psi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AnvilModuleDescriptor.kt\ncom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptorKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,679:1\n1#2:680\n1#2:701\n54#3:681\n1549#4:682\n1620#4,3:683\n1747#4,3:687\n1603#4,9:691\n1855#4:700\n1856#4:702\n1612#4:703\n1549#4:704\n1620#4,3:705\n1549#4:708\n1620#4,2:709\n1549#4:711\n1620#4,3:712\n1622#4:715\n1549#4:716\n1620#4,3:717\n473#5:686\n473#5:690\n*S KotlinDebug\n*F\n+ 1 TypeReference.kt\ncom/squareup/anvil/compiler/internal/reference/TypeReference$Psi\n*L\n238#1:701\n350#1:681\n357#1:682\n357#1:683,3\n228#1:687,3\n238#1:691,9\n238#1:700\n238#1:702\n238#1:703\n248#1:704\n248#1:705,3\n262#1:708\n262#1:709,2\n274#1:711\n274#1:712,3\n262#1:715\n311#1:716\n311#1:717,3\n228#1:686\n235#1:690\n*E\n"})
    public static final class Psi
    extends TypeReference {
        @NotNull
        private final KtTypeReference type;
        @Nullable
        private final ClassReference.Psi declaringClass;
        @NotNull
        private final AnvilModuleDescriptor module;
        @NotNull
        private final Lazy classReference$delegate;
        @NotNull
        private final Lazy typeName$delegate;
        @NotNull
        private final Lazy unwrappedTypes$delegate;

        public Psi(@NotNull KtTypeReference type2, @Nullable ClassReference.Psi declaringClass, @NotNull AnvilModuleDescriptor module) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(null);
            this.type = type2;
            this.declaringClass = declaringClass;
            this.module = module;
            this.classReference$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ClassReference>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final ClassReference invoke() {
                    FqName fqName = PsiUtilsKt.fqNameOrNull((PsiElement)this.this$0.getType(), this.this$0.getModule());
                    return fqName != null ? ClassReferenceKt.toClassReference(fqName, (ModuleDescriptor)this.this$0.getModule()) : null;
                }
            }));
            this.typeName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TypeName>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final TypeName invoke() {
                    return TypeReferenceKt.access$lambdaFix(Psi.access$requireTypeName(this.this$0, this.this$0.getType()));
                }
            }));
            this.unwrappedTypes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends TypeReference>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<TypeReference> invoke() {
                    List list;
                    PsiElement[] psiElementArray;
                    PsiElement[] $this$filterIsInstanceTo$iv$iv;
                    KtTypeElement ktTypeElement = this.this$0.getType().getTypeElement();
                    Intrinsics.checkNotNull((Object)ktTypeElement);
                    PsiElement[] psiElementArray2 = ktTypeElement.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                    Object[] $this$filterIsInstance$iv = psiElementArray2;
                    boolean $i$f$filterIsInstance = false;
                    Object[] objectArray = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo22 = false;
                    for (void var10_12 : $this$filterIsInstanceTo$iv$iv) {
                        if (!(var10_12 instanceof KtTypeArgumentList)) continue;
                        destination$iv$iv.add(var10_12);
                    }
                    KtTypeArgumentList ktTypeArgumentList = (KtTypeArgumentList)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                    if (ktTypeArgumentList != null && (psiElementArray = ktTypeArgumentList.getChildren()) != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void var10_14;
                        void $this$filterIsInstanceTo$iv$iv2;
                        void $this$filterIsInstance$iv2;
                        $this$filterIsInstanceTo$iv$iv = psiElementArray;
                        boolean $i$f$filterIsInstance232 = false;
                        void $i$f$filterIsInstanceTo22 = $this$filterIsInstance$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo2232 = false;
                        boolean bl = false;
                        int n = ((void)$this$filterIsInstanceTo$iv$iv2).length;
                        while (var10_14 < n) {
                            void element$iv$iv = $this$filterIsInstanceTo$iv$iv2[var10_14];
                            if (element$iv$iv instanceof KtTypeProjection) {
                                destination$iv$iv2.add(element$iv$iv);
                            }
                            ++var10_14;
                        }
                        Iterable $i$f$filterIsInstance232 = (List)destination$iv$iv2;
                        Psi psi = this.this$0;
                        boolean $i$f$map = false;
                        void $i$f$filterIsInstanceTo2232 = $this$map$iv;
                        Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            TypeReference typeReference;
                            ClassDescriptor anyDescriptor;
                            void typeProjection;
                            KtTypeProjection ktTypeProjection = (KtTypeProjection)item$iv$iv;
                            Collection collection2 = collection;
                            boolean bl2 = false;
                            PsiElement[] psiElementArray3 = typeProjection.getChildren();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"getChildren(...)");
                            if (((Object[])psiElementArray3).length == 0 && Intrinsics.areEqual((Object)typeProjection.getText(), (Object)"*")) {
                                ModuleDescriptor $this$asAnvilModuleDescriptor$iv = psi.getModule();
                                boolean $i$f$asAnvilModuleDescriptor = false;
                                Intrinsics.checkNotNull((Object)$this$asAnvilModuleDescriptor$iv, (String)"null cannot be cast to non-null type com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor");
                                Intrinsics.checkNotNull((Object)AnvilModuleDescriptor.DefaultImpls.resolveFqNameOrNull$default((AnvilModuleDescriptor)$this$asAnvilModuleDescriptor$iv, FqNameKt.getAnyFqName(), null, 2, null));
                                SimpleType simpleType = anyDescriptor.getDefaultType();
                                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
                                typeReference = TypeReferenceKt.toTypeReference((KotlinType)simpleType, (ClassReference)psi.getDeclaringClass(), psi.getModule());
                            } else {
                                void $this$filterIsInstanceTo$iv$iv3;
                                void $this$filterIsInstance$iv3;
                                PsiElement[] psiElementArray4 = typeProjection.getChildren();
                                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray4, (String)"getChildren(...)");
                                anyDescriptor = (ClassDescriptor)psiElementArray4;
                                boolean $i$f$filterIsInstance3 = false;
                                void $i$f$asAnvilModuleDescriptor = $this$filterIsInstance$iv3;
                                Collection destination$iv$iv4 = new ArrayList<E>();
                                boolean $i$f$filterIsInstanceTo3 = false;
                                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                                    if (!(element$iv$iv instanceof KtTypeReference)) continue;
                                    destination$iv$iv4.add(element$iv$iv);
                                }
                                typeReference = TypeReferenceKt.toTypeReference((KtTypeReference)CollectionsKt.single((List)((List)destination$iv$iv4)), psi.getDeclaringClass(), psi.getModule());
                            }
                            collection2.add(typeReference);
                        }
                        list = (List)collection;
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    List unwrappedTypes2 = list;
                    return Psi.access$findUnwrappedTypesWithTypeAlias(this.this$0, unwrappedTypes2);
                }
            }));
        }

        @NotNull
        public final KtTypeReference getType() {
            return this.type;
        }

        @Override
        @Nullable
        public ClassReference.Psi getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        @NotNull
        public AnvilModuleDescriptor getModule() {
            return this.module;
        }

        @Override
        @Nullable
        protected ClassReference getClassReference() {
            Lazy lazy = this.classReference$delegate;
            return (ClassReference)lazy.getValue();
        }

        @Override
        @NotNull
        protected TypeName getTypeName() {
            Lazy lazy = this.typeName$delegate;
            return (TypeName)lazy.getValue();
        }

        @Override
        @Nullable
        protected TypeName getTypeNameOrNull() {
            TypeName typeName2;
            try {
                typeName2 = this.getTypeName();
            }
            catch (AnvilCompilationException e) {
                typeName2 = null;
            }
            return typeName2;
        }

        @Override
        @NotNull
        public List<TypeReference> getUnwrappedTypes() {
            Lazy lazy = this.unwrappedTypes$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @Nullable
        public TypeReference resolveGenericTypeOrNull(@NotNull ClassReference implementingClass) {
            Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
            return this.resolveTypeReference$compiler_utils(implementingClass);
        }

        @NotNull
        public final TypeReference resolveTypeReference$compiler_utils(@NotNull ClassReference implementingClass) {
            FqName fqName;
            Intrinsics.checkNotNullParameter((Object)implementingClass, (String)"implementingClass");
            KtTypeElement ktTypeElement = this.type.getTypeElement();
            if (ktTypeElement != null && (fqName = PsiUtilsKt.fqNameOrNull((PsiElement)ktTypeElement, this.getModule())) != null) {
                FqName it = fqName;
                boolean bl = false;
                return this;
            }
            if (this.getDeclaringClass() == null) {
                return this;
            }
            ClassReference classReference2 = this.getDeclaringClass();
            String string = this.type.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            TypeReference typeReference = TypeReferenceKt.access$resolveGenericTypeReference(implementingClass, classReference2, string, this.getModule());
            if (typeReference == null) {
                typeReference = this;
            }
            return typeReference;
        }

        @Override
        public boolean isFunctionType() {
            return this.type.getTypeElement() instanceof KtFunctionType;
        }

        @Override
        public boolean isNullable() {
            return this.type.getTypeElement() instanceof KtNullableType;
        }

        private final TypeName requireTypeName(KtTypeReference $this$requireTypeName) {
            KtTypeElement ktTypeElement = $this$requireTypeName.getTypeElement();
            if (ktTypeElement == null) {
                Psi.requireTypeName$fail((PsiElement)$this$requireTypeName);
                throw new KotlinNothingValueException();
            }
            return Psi.requireTypeName$requireTypeName(ktTypeElement, this);
        }

        /*
         * WARNING - void declaration
         */
        private final List<TypeReference> findUnwrappedTypesWithTypeAlias(List<? extends TypeReference> unwrappedTypes2) {
            void $this$mapTo$iv$iv;
            TypeAliasDescriptor typeAliasDescriptor;
            block10: {
                block9: {
                    PsiElement[] psiElementArray = this.type.getTypeElement();
                    if (psiElementArray == null || (psiElementArray = psiElementArray.getChildren()) == null) {
                        return unwrappedTypes2;
                    }
                    PsiElement[] children = psiElementArray;
                    if (children.length != 2 || !(children[1] instanceof KtTypeArgumentList)) {
                        return unwrappedTypes2;
                    }
                    PsiElement psiElement = children[0];
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"get(...)");
                    FqName fqName = PsiUtilsKt.fqNameOrNull(psiElement, this.getModule());
                    if (fqName == null) break block9;
                    FqName it = fqName;
                    boolean bl = false;
                    ModuleDescriptor $this$asAnvilModuleDescriptor$iv = this.getModule();
                    boolean $i$f$asAnvilModuleDescriptor = false;
                    Intrinsics.checkNotNull((Object)$this$asAnvilModuleDescriptor$iv, (String)"null cannot be cast to non-null type com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor");
                    typeAliasDescriptor = ((AnvilModuleDescriptor)$this$asAnvilModuleDescriptor$iv).resolveTypeAliasFqNameOrNull(it);
                    if (typeAliasDescriptor != null) break block10;
                }
                return unwrappedTypes2;
            }
            TypeAliasDescriptor typeAlias = typeAliasDescriptor;
            List typeAliasArguments = typeAlias.getDefaultType().getArguments();
            List delegatedTypeArguments = typeAlias.getExpandedType().getArguments();
            if (typeAliasArguments.size() == delegatedTypeArguments.size()) {
                return unwrappedTypes2;
            }
            Iterable $this$map$iv = delegatedTypeArguments;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TypeReference typeReference;
                void typeProjection;
                TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                int index = typeAliasArguments.indexOf(typeProjection);
                if (index >= 0) {
                    typeReference = unwrappedTypes2.get(index);
                } else {
                    KotlinType kotlinType = typeProjection.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    typeReference = TypeReferenceKt.toTypeReference(kotlinType, (ClassReference)this.getDeclaringClass(), this.getModule());
                }
                collection.add(typeReference);
            }
            return (List)destination$iv$iv;
        }

        private static final Void requireTypeName$fail(PsiElement $this$requireTypeName_u24fail) {
            throw new AnvilCompilationException("Couldn't resolve type: " + $this$requireTypeName_u24fail.getText(), null, $this$requireTypeName_u24fail, 2, null);
        }

        private static final boolean requireTypeName$isTypeParameter(KtUserType $this$requireTypeName_u24isTypeParameter) {
            boolean bl;
            block3: {
                Sequence $this$filterIsInstance$iv = org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt.getParents((PsiElement)((PsiElement)$this$requireTypeName_u24isTypeParameter));
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Psi$requireTypeName$isTypeParameter$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                List list = ((KtClassOrObject)SequencesKt.first((Sequence)sequence)).getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeParameters(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtTypeParameter it = (KtTypeParameter)element$iv;
                        boolean bl2 = false;
                        String string = it.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        String[] stringArray = new String[]{":"};
                        String typeParameter = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null))))).toString();
                        if (!Intrinsics.areEqual((Object)typeParameter, (Object)$this$requireTypeName_u24isTypeParameter.getText())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private static final List<FqName> requireTypeName$findExtendsBound(KtUserType $this$requireTypeName_u24findExtendsBound) {
            void $this$mapNotNullTo$iv$iv;
            Sequence $this$filterIsInstance$iv = org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt.getParents((PsiElement)((PsiElement)$this$requireTypeName_u24findExtendsBound));
            boolean $i$f$filterIsInstance22 = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Psi$requireTypeName$findExtendsBound$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            List list = ((KtClassOrObject)SequencesKt.first((Sequence)sequence)).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeParameters(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$filterIsInstance22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                FqName it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtTypeParameter it = (KtTypeParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getFqName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private static final TypeName requireTypeName$requireTypeName(KtTypeElement $this$requireTypeName_u24requireTypeName, Psi this$0) {
            TypeName typeName2;
            KtTypeElement ktTypeElement = $this$requireTypeName_u24requireTypeName;
            if (ktTypeElement instanceof KtUserType) {
                ClassName className;
                try {
                    className = KotlinPoetUtilsKt.asClassName(PsiUtilsKt.requireFqName((PsiElement)$this$requireTypeName_u24requireTypeName, this$0.getModule()), this$0.getModule());
                }
                catch (Exception e) {
                    if (Psi.requireTypeName$isTypeParameter((KtUserType)$this$requireTypeName_u24requireTypeName)) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv2 = Psi.requireTypeName$findExtendsBound((KtUserType)$this$requireTypeName_u24requireTypeName);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            FqName fqName = (FqName)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(KotlinPoetUtilsKt.asClassName((FqName)it, this$0.getModule()));
                        }
                        List bounds = (List)destination$iv$iv;
                        String string = ((KtUserType)$this$requireTypeName_u24requireTypeName).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        return (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)string, (List)bounds, null, (int)4, null);
                    }
                    throw new AnvilCompilationException("Couldn't resolve fqName.", (Throwable)e, (PsiElement)$this$requireTypeName_u24requireTypeName);
                }
                ClassName className2 = className;
                KtTypeArgumentList typeArgumentList = ((KtUserType)$this$requireTypeName_u24requireTypeName).getTypeArgumentList();
                if (typeArgumentList != null) {
                    Collection<TypeName> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List list = typeArgumentList.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                    Iterable e = list;
                    ClassName className3 = className2;
                    ParameterizedTypeName.Companion companion = ParameterizedTypeName.Companion;
                    boolean $i$f$map = false;
                    void $this$map$iv2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        TypeName typeName3;
                        void typeProjection;
                        KtTypeProjection ktTypeProjection = (KtTypeProjection)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        if (typeProjection.getProjectionKind() == KtProjectionKind.STAR) {
                            typeName3 = (TypeName)TypeNames.STAR;
                        } else {
                            TypeName typeName4;
                            KtTypeReference it;
                            if (typeProjection.getTypeReference() == null) {
                                Intrinsics.checkNotNull((Object)typeProjection);
                                Psi.requireTypeName$fail((PsiElement)typeProjection);
                                throw new KotlinNothingValueException();
                            }
                            Intrinsics.checkNotNull((Object)it);
                            KtTypeReference typeReference = it;
                            TypeName typeName5 = this$0.requireTypeName(typeReference);
                            boolean bl2 = false;
                            if (!((Collection)typeReference.getAnnotationEntries()).isEmpty()) {
                                Collection<AnnotationSpec> collection2;
                                void $this$mapTo$iv$iv2;
                                void $this$map$iv3;
                                Iterable iterable = typeReference.getAnnotationEntries();
                                Collection collection3 = typeName5.getAnnotations();
                                boolean bl3 = false;
                                TypeName typeName6 = typeName5;
                                boolean $i$f$map2 = false;
                                void var23_52 = $this$map$iv3;
                                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                                boolean $i$f$mapTo2 = false;
                                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                    void annotationEntry;
                                    KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)item$iv$iv2;
                                    collection2 = destination$iv$iv2;
                                    boolean bl4 = false;
                                    collection2.add(AnnotationSpec.Companion.builder(KotlinPoetUtilsKt.asClassName(PsiUtilsKt.requireFqName((PsiElement)annotationEntry, this$0.getModule()), this$0.getModule())).build());
                                }
                                collection2 = (List)destination$iv$iv2;
                                typeName4 = TypeName.copy$default((TypeName)typeName6, (boolean)bl3, (List)CollectionsKt.plus((Collection)collection3, (Iterable)collection2), (int)1, null);
                            } else {
                                typeName4 = typeName5;
                            }
                            typeName5 = typeName4;
                            boolean bl5 = false;
                            KtModifierList modifierList = typeProjection.getModifierList();
                            typeName3 = modifierList == null ? typeName5 : (modifierList.hasModifier(KtTokens.OUT_KEYWORD) ? (TypeName)WildcardTypeName.Companion.producerOf(typeName5) : (modifierList.hasModifier(KtTokens.IN_KEYWORD) ? (TypeName)WildcardTypeName.Companion.consumerOf(typeName5) : typeName5));
                        }
                        collection.add(typeName3);
                    }
                    collection = (List)destination$iv$iv;
                    typeName2 = (TypeName)companion.get(className3, (List)collection);
                } else {
                    typeName2 = (TypeName)className2;
                }
            } else if (ktTypeElement instanceof KtFunctionType) {
                List list;
                List list2;
                LambdaTypeName.Companion companion = LambdaTypeName.Companion;
                KtFunctionTypeReceiver ktFunctionTypeReceiver = ((KtFunctionType)$this$requireTypeName_u24requireTypeName).getReceiver();
                TypeName typeName7 = ktFunctionTypeReceiver != null && (ktFunctionTypeReceiver = ktFunctionTypeReceiver.getTypeReference()) != null ? this$0.requireTypeName((KtTypeReference)ktFunctionTypeReceiver) : null;
                KtParameterList ktParameterList = ((KtFunctionType)$this$requireTypeName_u24requireTypeName).getParameterList();
                if (ktParameterList != null && (list2 = ktParameterList.getParameters()) != null) {
                    Collection<ParameterSpec> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable $i$f$map = list2;
                    TypeName typeName8 = typeName7;
                    LambdaTypeName.Companion companion2 = companion;
                    boolean $i$f$map3 = false;
                    void destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        KtTypeReference ktTypeReference;
                        void parameter;
                        KtParameter bl = (KtParameter)item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl6 = false;
                        if (parameter.getTypeReference() == null) {
                            Intrinsics.checkNotNull((Object)parameter);
                            Psi.requireTypeName$fail((PsiElement)parameter);
                            throw new KotlinNothingValueException();
                        }
                        Intrinsics.checkNotNull((Object)ktTypeReference);
                        KtTypeReference parameterReference = ktTypeReference;
                        collection.add(ParameterSpec.Companion.unnamed(this$0.requireTypeName(parameterReference)));
                    }
                    collection = (List)destination$iv$iv3;
                    companion = companion2;
                    typeName7 = typeName8;
                    list = collection;
                } else {
                    list = CollectionsKt.emptyList();
                }
                KtTypeReference ktTypeReference = ((KtFunctionType)$this$requireTypeName_u24requireTypeName).getReturnTypeReference();
                if (ktTypeReference == null) {
                    Psi.requireTypeName$fail((PsiElement)$this$requireTypeName_u24requireTypeName);
                    throw new KotlinNothingValueException();
                }
                KtModifierList ktModifierList = this$0.type.getModifierList();
                typeName2 = (TypeName)LambdaTypeName.copy$default((LambdaTypeName)companion.get(typeName7, list, this$0.requireTypeName(ktTypeReference)), (boolean)false, null, (boolean)(ktModifierList != null ? org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt.hasSuspendModifier((KtModifierList)ktModifierList) : false), null, (int)11, null);
            } else if (ktTypeElement instanceof KtNullableType) {
                KtTypeElement ktTypeElement2 = ((KtNullableType)$this$requireTypeName_u24requireTypeName).getInnerType();
                if (ktTypeElement2 == null) {
                    Psi.requireTypeName$fail((PsiElement)$this$requireTypeName_u24requireTypeName);
                    throw new KotlinNothingValueException();
                }
                typeName2 = TypeName.copy$default((TypeName)Psi.requireTypeName$requireTypeName(ktTypeElement2, this$0), (boolean)true, null, (int)2, null);
            } else {
                Psi.requireTypeName$fail((PsiElement)$this$requireTypeName_u24requireTypeName);
                throw new KotlinNothingValueException();
            }
            return typeName2;
        }

        public static final /* synthetic */ TypeName access$requireTypeName(Psi $this, KtTypeReference $receiver) {
            return $this.requireTypeName($receiver);
        }

        public static final /* synthetic */ List access$findUnwrappedTypesWithTypeAlias(Psi $this, List unwrappedTypes2) {
            return $this.findUnwrappedTypesWithTypeAlias(unwrappedTypes2);
        }
    }
}

