/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal.reference;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.internal.FqNameKt;
import com.squareup.anvil.compiler.internal.reference.AnnotationArgumentReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationArgumentReferenceKt;
import com.squareup.anvil.compiler.internal.reference.AnnotationReference;
import com.squareup.anvil.compiler.internal.reference.AnnotationReferenceKt;
import com.squareup.anvil.compiler.internal.reference.AnvilModuleDescriptor;
import com.squareup.anvil.compiler.internal.reference.ClassReference;
import com.squareup.anvil.compiler.internal.reference.ClassReferenceKt;
import com.squareup.anvil.compiler.internal.reference.TypeReference;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.MemberName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002-.B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\tJ\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u0004\u0018\u00010\tJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\b\b\u0002\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020!H\u0016J\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020\u001dJ\u0006\u0010%\u001a\u00020\u001dJ\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\b\b\u0002\u0010 \u001a\u00020!J\u0006\u0010'\u001a\u00020\tJ\u0010\u0010(\u001a\u00020\t2\b\b\u0002\u0010 \u001a\u00020!J\u0014\u0010)\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010 \u001a\u00020!H&J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u0017H\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0002/0\u00a8\u00061"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference;", "", "()V", "arguments", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationArgumentReference;", "getArguments", "()Ljava/util/List;", "classReference", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getClassReference", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "declaringClass", "getDeclaringClass", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "module", "Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "getModule", "()Lcom/squareup/anvil/compiler/internal/reference/AnvilModuleDescriptor;", "shortName", "", "getShortName", "()Ljava/lang/String;", "boundTypeOrNull", "declaringClassOrNull", "equals", "", "other", "exclude", "parameterIndex", "", "hashCode", "isDaggerScope", "isMapKey", "isQualifier", "replaces", "resolveBoundType", "scope", "scopeOrNull", "toAnnotationSpec", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "toString", "Descriptor", "Psi", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Psi;", "compiler-utils"})
@ExperimentalAnvilApi
@SourceDebugExtension(value={"SMAP\nAnnotationReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationReference.kt\ncom/squareup/anvil/compiler/internal/reference/AnnotationReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,308:1\n1855#2:309\n800#2,11:310\n1549#2:321\n1620#2,3:322\n800#2,11:327\n1856#2:338\n37#3,2:325\n*S KotlinDebug\n*F\n+ 1 AnnotationReference.kt\ncom/squareup/anvil/compiler/internal/reference/AnnotationReference\n*L\n98#1:309\n143#1:310,11\n148#1:321\n148#1:322,3\n152#1:327,11\n98#1:338\n148#1:325,2\n*E\n"})
public abstract class AnnotationReference {
    private AnnotationReference() {
    }

    @NotNull
    public abstract ClassReference getClassReference();

    @Nullable
    protected abstract ClassReference getDeclaringClass();

    @NotNull
    public final FqName getFqName() {
        return this.getClassReference().getFqName();
    }

    @NotNull
    public final String getShortName() {
        String string = this.getFqName().shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    @NotNull
    public final AnvilModuleDescriptor getModule() {
        return this.getClassReference().getModule();
    }

    @NotNull
    public abstract List<AnnotationArgumentReference> getArguments();

    @Nullable
    public final ClassReference declaringClassOrNull() {
        return this.getDeclaringClass();
    }

    @NotNull
    public ClassReference declaringClass() {
        ClassReference classReference2 = this.getDeclaringClass();
        if (classReference2 == null) {
            throw AnnotationReferenceKt.AnvilCompilationExceptionAnnotationReference$default(this, "The declaring class was null, this means the annotation wasn't used on a class.", null, 4, null);
        }
        return classReference2;
    }

    @Nullable
    public abstract ClassReference scopeOrNull(int var1);

    public static /* synthetic */ ClassReference scopeOrNull$default(AnnotationReference annotationReference, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scopeOrNull");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return annotationReference.scopeOrNull(n);
    }

    @NotNull
    public final ClassReference scope(int parameterIndex) {
        ClassReference classReference2 = this.scopeOrNull(parameterIndex);
        if (classReference2 == null) {
            throw AnnotationReferenceKt.AnvilCompilationExceptionAnnotationReference$default(this, "Couldn't find scope for " + this.getFqName() + '.', null, 4, null);
        }
        return classReference2;
    }

    public static /* synthetic */ ClassReference scope$default(AnnotationReference annotationReference, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scope");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return annotationReference.scope(n);
    }

    @Nullable
    public final ClassReference boundTypeOrNull() {
        AnnotationArgumentReference annotationArgumentReference = AnnotationReferenceKt.argumentAt(this, "boundType", 1);
        return annotationArgumentReference != null ? (ClassReference)annotationArgumentReference.value() : null;
    }

    @NotNull
    public final ClassReference resolveBoundType() {
        Object object;
        ClassReference classReference2 = this.boundTypeOrNull();
        if (classReference2 == null && (classReference2 = (object = (TypeReference)CollectionsKt.singleOrNull(this.declaringClass().directSuperTypeReferences())) != null ? ((TypeReference)object).asClassReference() : null) == null) {
            object = "Couldn't resolve bound type for " + this.getFqName();
            throw ClassReferenceKt.AnvilCompilationExceptionClassReference$default(this.declaringClass(), (String)object, null, 4, null);
        }
        return classReference2;
    }

    @NotNull
    public final List<ClassReference> replaces(int parameterIndex) {
        AnnotationArgumentReference annotationArgumentReference = AnnotationReferenceKt.argumentAt(this, "replaces", parameterIndex);
        List list = annotationArgumentReference != null ? (List)annotationArgumentReference.value() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static /* synthetic */ List replaces$default(AnnotationReference annotationReference, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replaces");
        }
        if ((n2 & 1) != 0) {
            n = AnnotationReferenceKt.access$replacesIndex(annotationReference.getFqName());
        }
        return annotationReference.replaces(n);
    }

    @NotNull
    public final List<ClassReference> exclude(int parameterIndex) {
        AnnotationArgumentReference annotationArgumentReference = AnnotationReferenceKt.argumentAt(this, "exclude", parameterIndex);
        List list = annotationArgumentReference != null ? (List)annotationArgumentReference.value() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static /* synthetic */ List exclude$default(AnnotationReference annotationReference, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exclude");
        }
        if ((n2 & 1) != 0) {
            n = AnnotationReferenceKt.access$excludeIndex(annotationReference.getFqName());
        }
        return annotationReference.exclude(n);
    }

    public final boolean isQualifier() {
        return this.getClassReference().isAnnotatedWith(FqNameKt.getQualifierFqName());
    }

    public final boolean isMapKey() {
        return this.getClassReference().isAnnotatedWith(FqNameKt.getMapKeyFqName());
    }

    public final boolean isDaggerScope() {
        return this.getClassReference().isAnnotatedWith(FqNameKt.getDaggerScopeFqName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationSpec toAnnotationSpec() {
        AnnotationSpec.Builder builder;
        AnnotationSpec.Builder $this$toAnnotationSpec_u24lambda_u242 = builder = AnnotationSpec.Companion.builder(ClassReferenceKt.asClassName(this.getClassReference()));
        boolean bl = false;
        Iterable $this$forEach$iv = this.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnnotationArgumentReference argument = (AnnotationArgumentReference)element$iv;
            boolean bl2 = false;
            Object value2 = argument.value();
            if (value2 instanceof ClassReference) {
                Object[] objectArray = new Object[]{ClassReferenceKt.asClassName((ClassReference)value2)};
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = %T::class", objectArray);
                continue;
            }
            if (value2 instanceof FqName) {
                ClassReference clazz = ClassReferenceKt.toClassReferenceOrNull((FqName)value2, this.getModule());
                if (clazz != null) {
                    ClassReference classReference2 = clazz.enclosingClass();
                    Intrinsics.checkNotNull((Object)classReference2);
                    MemberName enumMember = new MemberName(ClassReferenceKt.asClassName(classReference2), clazz.getShortName());
                    Object[] objectArray = new Object[]{enumMember};
                    $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = %M", objectArray);
                    continue;
                }
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ((FqName)value2).asString(), new Object[0]);
                continue;
            }
            if (value2 instanceof String) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = \"" + value2 + '\"', new Object[0]);
                continue;
            }
            if (value2 instanceof boolean[]) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ArraysKt.joinToString$default((boolean[])((boolean[])value2), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null), new Object[0]);
                continue;
            }
            if (value2 instanceof int[]) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ArraysKt.joinToString$default((int[])((int[])value2), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null), new Object[0]);
                continue;
            }
            if (value2 instanceof long[]) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ArraysKt.joinToString$default((long[])((long[])value2), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null), new Object[0]);
                continue;
            }
            if (value2 instanceof double[]) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ArraysKt.joinToString$default((double[])((double[])value2), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null), new Object[0]);
                continue;
            }
            if (value2 instanceof byte[]) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ArraysKt.joinToString$default((byte[])((byte[])value2), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null), new Object[0]);
                continue;
            }
            if (value2 instanceof short[]) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ArraysKt.joinToString$default((short[])((short[])value2), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null), new Object[0]);
                continue;
            }
            if (value2 instanceof float[]) {
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + ArraysKt.joinToString$default((float[])((float[])value2), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null), new Object[0]);
                continue;
            }
            if (value2 instanceof List) {
                Iterable $this$toTypedArray$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                if (((List)value2).isEmpty()) {
                    $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = []", new Object[0]);
                    continue;
                }
                if (((List)value2).get(0) instanceof ClassReference) {
                    Collection<ClassName> collection;
                    void $this$mapTo$iv$iv;
                    Collection $this$map$iv;
                    $this$filterIsInstance$iv = (Iterable)value2;
                    boolean $i$f$filterIsInstance22 = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo22 = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ClassReference)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List classes = (List)destination$iv$iv;
                    String template2 = CollectionsKt.joinToString$default((Iterable)classes, null, null, null, (int)0, null, (Function1)toAnnotationSpec.1.1.template.1.INSTANCE, (int)31, null);
                    $this$filterIsInstanceTo$iv$iv = classes;
                    String string = argument.getResolvedName() + " = [" + template2 + ']';
                    AnnotationSpec.Builder builder2 = $this$toAnnotationSpec_u24lambda_u242;
                    boolean $i$f$map = false;
                    void $i$f$filterIsInstanceTo22 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ClassReference classReference3 = (ClassReference)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(ClassReferenceKt.asClassName((ClassReference)it));
                    }
                    collection = (List)destination$iv$iv2;
                    $this$map$iv = collection;
                    boolean $i$f$toTypedArray = false;
                    Iterable thisCollection$iv = $this$toTypedArray$iv;
                    ClassName[] $i$f$filterIsInstance22 = thisCollection$iv.toArray(new ClassName[0]);
                    builder2.addMember(string, (Object[])Arrays.copyOf($i$f$filterIsInstance22, $i$f$filterIsInstance22.length));
                    continue;
                }
                if (!(((List)value2).get(0) instanceof FqName)) continue;
                $this$filterIsInstance$iv = (Iterable)value2;
                boolean $i$f$filterIsInstance = false;
                $this$toTypedArray$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof FqName)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String args2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)toAnnotationSpec.1.1.args.1.INSTANCE, (int)31, null);
                $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = [" + args2 + ']', new Object[0]);
                continue;
            }
            $this$toAnnotationSpec_u24lambda_u242.addMember(argument.getResolvedName() + " = " + value2, new Object[0]);
        }
        return builder.build();
    }

    @NotNull
    public String toString() {
        return "" + '@' + this.getFqName();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotationReference)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getFqName(), (Object)((AnnotationReference)other).getFqName())) {
            return false;
        }
        return Intrinsics.areEqual(this.getArguments(), ((AnnotationReference)other).getArguments());
    }

    public int hashCode() {
        int result = this.getFqName().hashCode();
        result = 31 * result + ((Object)this.getArguments()).hashCode();
        return result;
    }

    public /* synthetic */ AnnotationReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Descriptor;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "classReference", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lcom/squareup/anvil/compiler/internal/reference/ClassReference;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;)V", "getAnnotation", "()Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "arguments", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationArgumentReference$Descriptor;", "getArguments", "()Ljava/util/List;", "arguments$delegate", "Lkotlin/Lazy;", "getClassReference", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Descriptor;", "scope", "getScope", "scope$delegate", "scopeOrNull", "parameterIndex", "", "compiler-utils"})
    public static final class Descriptor
    extends AnnotationReference {
        @NotNull
        private final AnnotationDescriptor annotation;
        @NotNull
        private final ClassReference classReference;
        @Nullable
        private final ClassReference.Descriptor declaringClass;
        @NotNull
        private final Lazy arguments$delegate;
        @NotNull
        private final Lazy scope$delegate;

        public Descriptor(@NotNull AnnotationDescriptor annotation, @NotNull ClassReference classReference2, @Nullable ClassReference.Descriptor declaringClass) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)classReference2, (String)"classReference");
            super(null);
            this.annotation = annotation;
            this.classReference = classReference2;
            this.declaringClass = declaringClass;
            this.arguments$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationArgumentReference.Descriptor>>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationArgumentReference.Descriptor> invoke() {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = MapsKt.toList((Map)this.this$0.getAnnotation().getAllValueArguments());
                    Descriptor descriptor = this.this$0;
                    boolean $i$f$map = false;
                    void var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(AnnotationArgumentReferenceKt.toAnnotationArgumentReference(it, descriptor));
                    }
                    return (List)destination$iv$iv;
                }
            }));
            this.scope$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ClassReference>(this){
                final /* synthetic */ Descriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ClassReference invoke() {
                    Object object;
                    block2: {
                        void var3_3;
                        Iterable $this$singleOrNull$iv = this.this$0.getArguments();
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (T element$iv : $this$singleOrNull$iv) {
                            AnnotationArgumentReference.Descriptor it = (AnnotationArgumentReference.Descriptor)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"scope")) continue;
                            if (found$iv) {
                                object = null;
                                break block2;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        object = !found$iv ? null : var3_3;
                    }
                    AnnotationArgumentReference.Descriptor descriptor = (AnnotationArgumentReference.Descriptor)object;
                    return descriptor != null ? (ClassReference)descriptor.value() : null;
                }
            }));
        }

        @NotNull
        public final AnnotationDescriptor getAnnotation() {
            return this.annotation;
        }

        @Override
        @NotNull
        public ClassReference getClassReference() {
            return this.classReference;
        }

        @Override
        @Nullable
        protected ClassReference.Descriptor getDeclaringClass() {
            return this.declaringClass;
        }

        @NotNull
        public List<AnnotationArgumentReference.Descriptor> getArguments() {
            Lazy lazy = this.arguments$delegate;
            return (List)lazy.getValue();
        }

        private final ClassReference getScope() {
            Lazy lazy = this.scope$delegate;
            return (ClassReference)lazy.getValue();
        }

        @Override
        @NotNull
        public ClassReference.Descriptor declaringClass() {
            ClassReference classReference2 = super.declaringClass();
            Intrinsics.checkNotNull((Object)classReference2, (String)"null cannot be cast to non-null type com.squareup.anvil.compiler.internal.reference.ClassReference.Descriptor");
            return (ClassReference.Descriptor)classReference2;
        }

        @Override
        @Nullable
        public ClassReference scopeOrNull(int parameterIndex) {
            return this.getScope();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference$Psi;", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationReference;", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "classReference", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "declaringClass", "Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lcom/squareup/anvil/compiler/internal/reference/ClassReference;Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;)V", "getAnnotation", "()Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "arguments", "", "Lcom/squareup/anvil/compiler/internal/reference/AnnotationArgumentReference$Psi;", "getArguments", "()Ljava/util/List;", "arguments$delegate", "Lkotlin/Lazy;", "getClassReference", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference;", "getDeclaringClass", "()Lcom/squareup/anvil/compiler/internal/reference/ClassReference$Psi;", "defaultScope", "getDefaultScope", "defaultScope$delegate", "computeScope", "parameterIndex", "", "scopeOrNull", "compiler-utils"})
    public static final class Psi
    extends AnnotationReference {
        @NotNull
        private final KtAnnotationEntry annotation;
        @NotNull
        private final ClassReference classReference;
        @Nullable
        private final ClassReference.Psi declaringClass;
        @NotNull
        private final Lazy arguments$delegate;
        @NotNull
        private final Lazy defaultScope$delegate;

        public Psi(@NotNull KtAnnotationEntry annotation, @NotNull ClassReference classReference2, @Nullable ClassReference.Psi declaringClass) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)classReference2, (String)"classReference");
            super(null);
            this.annotation = annotation;
            this.classReference = classReference2;
            this.declaringClass = declaringClass;
            this.arguments$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<List<? extends AnnotationArgumentReference.Psi>>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<AnnotationArgumentReference.Psi> invoke() {
                    void $this$mapIndexedTo$iv$iv;
                    void $this$mapIndexed$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    List list = this.this$0.getAnnotation().getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                    Iterable $this$filterIsInstance$iv = list;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof KtValueArgument)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    Psi psi = this.this$0;
                    boolean $i$f$mapIndexed = false;
                    destination$iv$iv = $this$mapIndexed$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    int index$iv$iv = 0;
                    for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void index;
                        void argument;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                        int n2 = n;
                        Collection collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(AnnotationArgumentReferenceKt.toAnnotationArgumentReference((KtValueArgument)argument, psi, (int)index));
                    }
                    return (List)destination$iv$iv2;
                }
            }));
            this.defaultScope$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ClassReference>(this){
                final /* synthetic */ Psi this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final ClassReference invoke() {
                    return Psi.access$computeScope(this.this$0, 0);
                }
            }));
        }

        @NotNull
        public final KtAnnotationEntry getAnnotation() {
            return this.annotation;
        }

        @Override
        @NotNull
        public ClassReference getClassReference() {
            return this.classReference;
        }

        @Override
        @Nullable
        protected ClassReference.Psi getDeclaringClass() {
            return this.declaringClass;
        }

        @NotNull
        public List<AnnotationArgumentReference.Psi> getArguments() {
            Lazy lazy = this.arguments$delegate;
            return (List)lazy.getValue();
        }

        private final ClassReference getDefaultScope() {
            Lazy lazy = this.defaultScope$delegate;
            return (ClassReference)lazy.getValue();
        }

        @Override
        @Nullable
        public ClassReference scopeOrNull(int parameterIndex) {
            return parameterIndex == 0 ? this.getDefaultScope() : this.computeScope(parameterIndex);
        }

        private final ClassReference computeScope(int parameterIndex) {
            AnnotationArgumentReference annotationArgumentReference = AnnotationReferenceKt.argumentAt(this, "scope", parameterIndex);
            return annotationArgumentReference != null ? (ClassReference)annotationArgumentReference.value() : null;
        }

        public static final /* synthetic */ ClassReference access$computeScope(Psi $this, int parameterIndex) {
            return $this.computeScope(parameterIndex);
        }
    }
}

