/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.anvil.compiler.internal;

import com.squareup.anvil.annotations.ExperimentalAnvilApi;
import com.squareup.anvil.compiler.api.AnvilCompilationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0001H\u0007\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u0001H\u0007\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"argumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptorOrNull", "getContributedPropertyOrNull", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/name/FqName;", "compiler-utils"})
public final class DescriptorUtilsKt {
    @ExperimentalAnvilApi
    @NotNull
    public static final KotlinType argumentType(@NotNull KotlinType $this$argumentType) {
        Intrinsics.checkNotNullParameter((Object)$this$argumentType, (String)"<this>");
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.first((List)$this$argumentType.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        return kotlinType;
    }

    @ExperimentalAnvilApi
    @Nullable
    public static final ClassDescriptor classDescriptorOrNull(@NotNull KotlinType $this$classDescriptorOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$classDescriptorOrNull, (String)"<this>");
        return TypeUtils.getClassDescriptor((KotlinType)$this$classDescriptorOrNull);
    }

    @ExperimentalAnvilApi
    @NotNull
    public static final ClassDescriptor classDescriptor(@NotNull KotlinType $this$classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$classDescriptor, (String)"<this>");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.classDescriptorOrNull($this$classDescriptor);
        if (classDescriptor == null) {
            throw new AnvilCompilationException("Unable to resolve type for " + $this$classDescriptor + '.', null, null, 6, null);
        }
        return classDescriptor;
    }

    @ExperimentalAnvilApi
    @NotNull
    public static final KotlinType argumentType(@NotNull ConstantValue<?> $this$argumentType, @NotNull ModuleDescriptor module) {
        SimpleType simpleType;
        Intrinsics.checkNotNullParameter($this$argumentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        KotlinType argumentType = DescriptorUtilsKt.argumentType($this$argumentType.getType(module));
        if (!KotlinTypeKt.isError((KotlinType)argumentType)) {
            return argumentType;
        }
        Object normalClass = $this$argumentType.getValue();
        if (!(normalClass instanceof KClassValue.Value.NormalClass)) {
            return argumentType;
        }
        ClassId classId = ((KClassValue.Value.NormalClass)normalClass).getValue().getClassId();
        FqName fqName = classId.getPackageFqName();
        String string = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)module, (ClassId)new ClassId(fqName, new FqName(StringsKt.replace$default((String)string, (char)'$', (char)'.', (boolean)false, (int)4, null)), false));
        SimpleType simpleType2 = simpleType = classDescriptor != null ? classDescriptor.getDefaultType() : null;
        if (simpleType == null) {
            throw new AnvilCompilationException("Couldn't resolve class across module dependencies for class ID: " + classId, null, null, 6, null);
        }
        return (KotlinType)simpleType;
    }

    @ExperimentalAnvilApi
    @Nullable
    public static final PropertyDescriptor getContributedPropertyOrNull(@NotNull FqName $this$getContributedPropertyOrNull, @NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter((Object)$this$getContributedPropertyOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        FqName fqName = $this$getContributedPropertyOrNull.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"parent(...)");
        MemberScope memberScope = module.getPackage(fqName).getMemberScope();
        Name name = $this$getContributedPropertyOrNull.shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"shortName(...)");
        return (PropertyDescriptor)CollectionsKt.singleOrNull((Iterable)memberScope.getContributedVariables(name, (LookupLocation)NoLookupLocation.FROM_BACKEND));
    }
}

