/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.parser.manifest;

import com.springsource.util.parser.manifest.ManifestProblemKind;
import com.springsource.util.parser.manifest.internal.SourceContext;

public class ManifestProblem {
    private ManifestProblemKind problemKind;
    private SourceContext context;
    private int startoffset;
    private int endoffset;
    private String[] inserts;

    public ManifestProblem(ManifestProblemKind problem, SourceContext context, int startoffset, int endoffset, String ... inserts) {
        this.problemKind = problem;
        this.context = context;
        this.startoffset = startoffset;
        this.endoffset = endoffset;
        this.inserts = inserts;
    }

    public String toString() {
        return this.problemKind.format(this.context.getLine(this.startoffset), this.context.getColumn(this.startoffset), this.inserts);
    }

    public String toStringWithContext() {
        int relevantLine = this.context.getLine(this.startoffset);
        String relevantLineData = this.context.getLineAsString(relevantLine);
        String theMessage = this.problemKind.format(this.context.getLine(this.startoffset), this.context.getColumn(this.startoffset), this.inserts);
        StringBuilder beautifulMessage = new StringBuilder();
        beautifulMessage.append(relevantLineData);
        int scol = this.context.getColumn(this.startoffset);
        int ecol = this.context.getColumn(this.endoffset);
        int where = 0;
        where = 0;
        while (where < scol) {
            beautifulMessage.append(' ');
            ++where;
        }
        beautifulMessage.append('^');
        if (ecol != scol) {
            ++where;
            while (where < ecol) {
                beautifulMessage.append(' ');
                ++where;
            }
            beautifulMessage.append('^');
        }
        beautifulMessage.append('\n');
        beautifulMessage.append(theMessage);
        return beautifulMessage.toString();
    }

    public ManifestProblemKind getKind() {
        return this.problemKind;
    }

    public int getInsertCount() {
        return this.inserts.length;
    }

    public String getInsert(int insertIndex) {
        return this.inserts[insertIndex];
    }

    public int getStartLine() {
        return this.context.getLine(this.startoffset);
    }

    public int getEndLine() {
        return this.context.getLine(this.endoffset);
    }

    public int getStartColumn() {
        return this.context.getColumn(this.startoffset);
    }

    public int getEndColumn() {
        return this.context.getColumn(this.endoffset);
    }

    public int getStartOffset() {
        return this.startoffset;
    }

    public int getEndOffset() {
        return this.endoffset;
    }
}

