/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.app;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.spotify.sdk.android.auth.app.Sha1HashUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class Sha1HashUtilImpl
implements Sha1HashUtil {
    private final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();

    Sha1HashUtilImpl() {
    }

    @Override
    @Nullable
    public String sha1Hash(@NonNull String toHash) {
        String hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = toHash.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            bytes = digest.digest();
            hash = this.bytesToHex(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return hash;
    }

    @NonNull
    private String bytesToHex(@NonNull byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = this.HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = this.HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

