/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.browser;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.browser.RedirectUriReceiverActivity;
import java.util.ArrayList;
import java.util.List;

public final class CustomTabsSupportChecker {
    private static final String TAG = CustomTabsSupportChecker.class.getSimpleName();

    static String getPackageSupportingCustomTabs(Context context, AuthorizationRequest request) {
        String redirectUri = request.getRedirectUri();
        String packageSupportingCustomTabs = CustomTabsSupportChecker.getPackageNameSupportingCustomTabs(context.getPackageManager(), request.toUri());
        if (!redirectUri.startsWith("http") && !redirectUri.startsWith("https") && CustomTabsSupportChecker.hasBrowserSupportForCustomTabs(packageSupportingCustomTabs) && CustomTabsSupportChecker.hasRedirectUriActivity(context.getPackageManager(), redirectUri)) {
            return packageSupportingCustomTabs;
        }
        return "";
    }

    private static String getPackageNameSupportingCustomTabs(PackageManager pm, Uri uri) {
        Intent activityIntent = new Intent("android.intent.action.VIEW", uri).addCategory("android.intent.category.BROWSABLE");
        ResolveInfo defaultViewHandlerInfo = pm.resolveActivity(activityIntent, 0);
        String defaultViewHandlerPackageName = null;
        if (defaultViewHandlerInfo != null) {
            defaultViewHandlerPackageName = defaultViewHandlerInfo.activityInfo.packageName;
        }
        Log.d((String)TAG, (String)("Found default package name for handling VIEW intents: " + defaultViewHandlerPackageName));
        List resolvedActivityList = pm.queryIntentActivities(activityIntent, 0);
        ArrayList<String> packagesSupportingCustomTabs = new ArrayList<String>();
        for (ResolveInfo info : resolvedActivityList) {
            Intent serviceIntent = new Intent();
            serviceIntent.setAction("android.support.customtabs.action.CustomTabsService");
            serviceIntent.setPackage(info.activityInfo.packageName);
            if (pm.resolveService(serviceIntent, 0) == null) continue;
            Log.d((String)TAG, (String)("Adding " + info.activityInfo.packageName + " to supported packages"));
            packagesSupportingCustomTabs.add(info.activityInfo.packageName);
        }
        String packageNameToUse = null;
        if (packagesSupportingCustomTabs.size() == 1) {
            packageNameToUse = (String)packagesSupportingCustomTabs.get(0);
        } else if (packagesSupportingCustomTabs.size() > 1) {
            packageNameToUse = !TextUtils.isEmpty((CharSequence)defaultViewHandlerPackageName) && packagesSupportingCustomTabs.contains(defaultViewHandlerPackageName) ? defaultViewHandlerPackageName : (String)packagesSupportingCustomTabs.get(0);
        }
        return packageNameToUse;
    }

    private static boolean hasBrowserSupportForCustomTabs(String packageSupportingCustomTabs) {
        if (TextUtils.isEmpty((CharSequence)packageSupportingCustomTabs)) {
            Log.d((String)TAG, (String)"No package supporting CustomTabs found.");
            return false;
        }
        return true;
    }

    private static boolean hasRedirectUriActivity(PackageManager pm, String redirectUri) {
        if (pm == null) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setData(Uri.parse((String)redirectUri));
        List infoList = pm.queryIntentActivities(intent, 64);
        for (ResolveInfo info : infoList) {
            if (!RedirectUriReceiverActivity.class.getName().equals(info.activityInfo.name)) continue;
            return true;
        }
        return false;
    }
}

