/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.spotify.sdk.android.auth.AuthorizationHandler;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.AuthorizationResponse;
import com.spotify.sdk.android.auth.FallbackHandlerProvider;
import com.spotify.sdk.android.auth.LoginActivity;
import com.spotify.sdk.android.auth.PKCEInformation;
import com.spotify.sdk.android.auth.PKCEInformationFactory;
import com.spotify.sdk.android.auth.app.SpotifyAuthHandler;
import com.spotify.sdk.android.auth.app.SpotifyNativeAuthUtil;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class AuthorizationClient {
    private static final String TAG = "Spotify Auth Client";
    static final String MARKET_VIEW_PATH = "market://";
    static final String MARKET_SCHEME = "market";
    static final String MARKET_PATH = "details";
    static final String PLAY_STORE_SCHEME = "https";
    static final String PLAY_STORE_AUTHORITY = "play.google.com";
    static final String PLAY_STORE_PATH = "store/apps/details";
    static final String SPOTIFY_ID = "com.spotify.music";
    static final String SPOTIFY_SDK = "spotify-sdk";
    static final String ANDROID_SDK = "android-sdk";
    static final String DEFAULT_CAMPAIGN = "android-sdk";
    @VisibleForTesting
    static final int MIN_SPOTIFY_VERSION_FOR_TOKEN_CONVERSION = 132384743;
    private final Activity mLoginActivity;
    private boolean mAuthorizationPending;
    private AuthorizationHandler mCurrentHandler;
    private List<AuthorizationHandler> mAuthorizationHandlers = new ArrayList<AuthorizationHandler>();
    private AuthorizationClientListener mAuthorizationClientListener;

    public static void openLoginInBrowser(@NonNull Activity contextActivity, @NonNull AuthorizationRequest request) {
        Intent launchBrowser = new Intent("android.intent.action.VIEW", request.toUri());
        contextActivity.startActivity(launchBrowser);
    }

    @NonNull
    public static Intent createLoginActivityIntent(@NonNull Activity contextActivity, @NonNull AuthorizationRequest request) {
        if (contextActivity == null) {
            throw new IllegalArgumentException("Context activity cannot be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("Authorization request cannot be null");
        }
        AuthorizationRequest processedRequest = AuthorizationClient.appendPkceIfTokenRequest((Context)contextActivity, request);
        Intent intent = LoginActivity.getAuthIntent(contextActivity, processedRequest);
        intent.addFlags(0x4000000);
        return intent;
    }

    public static void openLoginActivity(@NonNull Activity contextActivity, int requestCode, @NonNull AuthorizationRequest request) {
        Intent intent = AuthorizationClient.createLoginActivityIntent(contextActivity, request);
        contextActivity.startActivityForResult(intent, requestCode);
    }

    public static void stopLoginActivity(@NonNull Activity contextActivity, int requestCode) {
        contextActivity.finishActivity(requestCode);
    }

    @NonNull
    public static AuthorizationResponse getResponse(int resultCode, @Nullable Intent intent) {
        if (resultCode == -1 && LoginActivity.getResponseFromIntent(intent) != null) {
            return LoginActivity.getResponseFromIntent(intent);
        }
        return new AuthorizationResponse.Builder().setType(AuthorizationResponse.Type.EMPTY).build();
    }

    public static void openDownloadSpotifyActivity(@NonNull Activity contextActivity) {
        AuthorizationClient.openDownloadSpotifyActivity(contextActivity, "android-sdk");
    }

    public static void openDownloadSpotifyActivity(@NonNull Activity contextActivity, @Nullable String campaign) {
        Uri.Builder uriBuilder = new Uri.Builder();
        if (AuthorizationClient.isAvailable((Context)contextActivity, new Intent("android.intent.action.VIEW", Uri.parse((String)MARKET_VIEW_PATH)))) {
            uriBuilder.scheme(MARKET_SCHEME).appendPath(MARKET_PATH);
        } else {
            uriBuilder.scheme(PLAY_STORE_SCHEME).authority(PLAY_STORE_AUTHORITY).appendEncodedPath(PLAY_STORE_PATH);
        }
        uriBuilder.appendQueryParameter("id", SPOTIFY_ID);
        Uri.Builder referrerBuilder = new Uri.Builder();
        referrerBuilder.appendQueryParameter("utm_source", SPOTIFY_SDK).appendQueryParameter("utm_medium", "android-sdk");
        if (TextUtils.isEmpty((CharSequence)campaign)) {
            referrerBuilder.appendQueryParameter("utm_campaign", "android-sdk");
        } else {
            referrerBuilder.appendQueryParameter("utm_campaign", campaign);
        }
        uriBuilder.appendQueryParameter("referrer", referrerBuilder.build().getEncodedQuery());
        contextActivity.startActivity(new Intent("android.intent.action.VIEW", uriBuilder.build()));
    }

    public static boolean isAvailable(@NonNull Context ctx, @NonNull Intent intent) {
        PackageManager mgr = ctx.getPackageManager();
        List list = mgr.queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public AuthorizationClient(@NonNull Activity activity) {
        this.mLoginActivity = activity;
        this.mAuthorizationHandlers.add(new SpotifyAuthHandler());
        this.mAuthorizationHandlers.add(new FallbackHandlerProvider().provideFallback());
    }

    void setOnCompleteListener(AuthorizationClientListener listener) {
        this.mAuthorizationClientListener = listener;
    }

    void authorize(AuthorizationRequest request) {
        if (this.mAuthorizationPending) {
            return;
        }
        this.mAuthorizationPending = true;
        AuthorizationRequest processedRequest = this.validateAndConvertTokenRequest(request);
        for (AuthorizationHandler authHandler : this.mAuthorizationHandlers) {
            if (!this.tryAuthorizationHandler(authHandler, processedRequest)) continue;
            this.mCurrentHandler = authHandler;
            break;
        }
    }

    private static AuthorizationRequest appendPkceIfTokenRequest(Context context, AuthorizationRequest request) {
        boolean hasSpotifyVersionWithoutPKCESupportInstalled;
        boolean isTokenRequest = AuthorizationResponse.Type.TOKEN.toString().equals(request.getResponseType());
        boolean isSpotifyInstalled = SpotifyNativeAuthUtil.isSpotifyInstalled(context);
        boolean isPKCESpotifyVersion = SpotifyNativeAuthUtil.isSpotifyVersionAtLeast(context, 132384743);
        boolean bl = hasSpotifyVersionWithoutPKCESupportInstalled = isSpotifyInstalled && !isPKCESpotifyVersion;
        if (!isTokenRequest || hasSpotifyVersionWithoutPKCESupportInstalled) {
            return request;
        }
        try {
            PKCEInformation pkceInfo = PKCEInformationFactory.create();
            return new AuthorizationRequest.Builder(request.getClientId(), AuthorizationResponse.Type.TOKEN, request.getRedirectUri()).setState(request.getState()).setScopes(request.getScopes()).setCampaign(request.getCampaign()).setPkceInformation(pkceInfo).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to generate PKCE information: " + e.getMessage(), e);
        }
    }

    private AuthorizationRequest validateAndConvertTokenRequest(AuthorizationRequest request) {
        boolean shouldConvert;
        boolean hasPkce;
        boolean isTokenRequest = AuthorizationResponse.Type.TOKEN.toString().equals(request.getResponseType());
        boolean bl = hasPkce = request.getPkceInformation() != null;
        if (!isTokenRequest || !hasPkce) {
            return request;
        }
        boolean isSpotifyInstalled = SpotifyNativeAuthUtil.isSpotifyInstalled((Context)this.mLoginActivity);
        boolean isPKCESpotifyVersion = SpotifyNativeAuthUtil.isSpotifyVersionAtLeast((Context)this.mLoginActivity, 132384743);
        boolean bl2 = shouldConvert = !isSpotifyInstalled || isPKCESpotifyVersion;
        if (!shouldConvert) {
            return request;
        }
        return new AuthorizationRequest.Builder(request.getClientId(), AuthorizationResponse.Type.CODE, request.getRedirectUri()).setState(request.getState()).setScopes(request.getScopes()).setCampaign(request.getCampaign()).setPkceInformation(request.getPkceInformation()).build();
    }

    void cancel() {
        if (!this.mAuthorizationPending) {
            return;
        }
        this.mAuthorizationPending = false;
        this.closeAuthorizationHandler(this.mCurrentHandler);
        if (this.mAuthorizationClientListener != null) {
            this.mAuthorizationClientListener.onClientCancelled();
            this.mAuthorizationClientListener = null;
        }
    }

    void complete(AuthorizationResponse response) {
        this.sendComplete(this.mCurrentHandler, response);
    }

    private void sendComplete(AuthorizationHandler authHandler, AuthorizationResponse response) {
        this.mAuthorizationPending = false;
        this.closeAuthorizationHandler(authHandler);
        if (this.mAuthorizationClientListener != null) {
            this.mAuthorizationClientListener.onClientComplete(response);
            this.mAuthorizationClientListener = null;
        } else {
            Log.w((String)TAG, (String)"Can't deliver the Spotify Auth response. The listener is null");
        }
    }

    private boolean tryAuthorizationHandler(final AuthorizationHandler authHandler, AuthorizationRequest request) {
        authHandler.setOnCompleteListener(new AuthorizationHandler.OnCompleteListener(){

            @Override
            public void onComplete(AuthorizationResponse response) {
                Log.i((String)AuthorizationClient.TAG, (String)String.format("Spotify auth response:%s", response.getType().name()));
                AuthorizationClient.this.sendComplete(authHandler, response);
            }

            @Override
            public void onCancel() {
                Log.i((String)AuthorizationClient.TAG, (String)"Spotify auth response: User cancelled");
                AuthorizationResponse response = new AuthorizationResponse.Builder().setType(AuthorizationResponse.Type.EMPTY).build();
                AuthorizationClient.this.sendComplete(authHandler, response);
            }

            @Override
            public void onError(Throwable error) {
                Log.e((String)AuthorizationClient.TAG, (String)"Spotify auth Error", (Throwable)error);
                AuthorizationResponse response = new AuthorizationResponse.Builder().setType(AuthorizationResponse.Type.ERROR).setError(error.getMessage()).build();
                AuthorizationClient.this.sendComplete(authHandler, response);
            }
        });
        if (!authHandler.start(this.mLoginActivity, request)) {
            this.closeAuthorizationHandler(authHandler);
            return false;
        }
        return true;
    }

    private void closeAuthorizationHandler(AuthorizationHandler authHandler) {
        if (authHandler != null) {
            authHandler.setOnCompleteListener(null);
            authHandler.stop();
        }
    }

    void notifyInCaseUserCanceledAuth() {
        if (this.mCurrentHandler != null && this.mCurrentHandler.isAuthInProgress()) {
            Log.i((String)TAG, (String)"Spotify auth response: User cancelled");
            AuthorizationResponse response = new AuthorizationResponse.Builder().setType(AuthorizationResponse.Type.EMPTY).build();
            this.complete(response);
        }
    }

    void clearAuthInProgress() {
        if (this.mCurrentHandler != null) {
            Log.d((String)TAG, (String)"Clearing auth in progress state");
            this.mCurrentHandler.stop();
            this.mCurrentHandler = null;
        }
    }

    static interface AuthorizationClientListener {
        public void onClientComplete(AuthorizationResponse var1);

        public void onClientCancelled();
    }

    static final class PlayStoreParams {
        public static final String ID = "id";
        public static final String REFERRER = "referrer";
        public static final String UTM_SOURCE = "utm_source";
        public static final String UTM_MEDIUM = "utm_medium";
        public static final String UTM_CAMPAIGN = "utm_campaign";

        PlayStoreParams() {
        }
    }
}

