/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.spotify.sdk.android.auth.AuthorizationResponse;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationRequest
implements Parcelable {
    static final String ACCOUNTS_SCHEME = "https";
    static final String ACCOUNTS_AUTHORITY = "accounts.spotify.com";
    static final String ACCOUNTS_PATH = "authorize";
    static final String SCOPES_SEPARATOR = " ";
    static final String SPOTIFY_SDK = "spotify-sdk";
    static final String ANDROID_SDK = "android-sdk";
    private final String mClientId;
    private final String mResponseType;
    private final String mRedirectUri;
    private final String mState;
    private final String[] mScopes;
    private final boolean mShowDialog;
    private final Map<String, String> mCustomParams;
    private final String mCampaign;
    public static final Parcelable.Creator<AuthorizationRequest> CREATOR = new Parcelable.Creator<AuthorizationRequest>(){

        public AuthorizationRequest createFromParcel(Parcel source) {
            return new AuthorizationRequest(source);
        }

        public AuthorizationRequest[] newArray(int size) {
            return new AuthorizationRequest[size];
        }
    };

    public AuthorizationRequest(Parcel source) {
        this.mClientId = source.readString();
        this.mResponseType = source.readString();
        this.mRedirectUri = source.readString();
        this.mState = source.readString();
        this.mScopes = source.createStringArray();
        this.mShowDialog = source.readByte() == 1;
        this.mCustomParams = new HashMap<String, String>();
        this.mCampaign = source.readString();
        Bundle bundle = source.readBundle(this.getClass().getClassLoader());
        for (String key : bundle.keySet()) {
            this.mCustomParams.put(key, bundle.getString(key));
        }
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getResponseType() {
        return this.mResponseType;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public String getState() {
        return this.mState;
    }

    public String[] getScopes() {
        return this.mScopes;
    }

    public String getCustomParam(String key) {
        return this.mCustomParams.get(key);
    }

    public String getCampaign() {
        return TextUtils.isEmpty((CharSequence)this.mCampaign) ? ANDROID_SDK : this.mCampaign;
    }

    private AuthorizationRequest(String clientId, AuthorizationResponse.Type responseType, String redirectUri, String state, String[] scopes, boolean showDialog, Map<String, String> customParams, String campaign) {
        this.mClientId = clientId;
        this.mResponseType = responseType.toString();
        this.mRedirectUri = redirectUri;
        this.mState = state;
        this.mScopes = scopes;
        this.mShowDialog = showDialog;
        this.mCustomParams = customParams;
        this.mCampaign = campaign;
    }

    public Uri toUri() {
        Uri.Builder uriBuilder = new Uri.Builder();
        uriBuilder.scheme(ACCOUNTS_SCHEME).authority(ACCOUNTS_AUTHORITY).appendPath(ACCOUNTS_PATH).appendQueryParameter("client_id", this.mClientId).appendQueryParameter("response_type", this.mResponseType).appendQueryParameter("redirect_uri", this.mRedirectUri).appendQueryParameter("show_dialog", String.valueOf(this.mShowDialog)).appendQueryParameter("utm_source", SPOTIFY_SDK).appendQueryParameter("utm_medium", ANDROID_SDK).appendQueryParameter("utm_campaign", this.getCampaign());
        if (this.mScopes != null && this.mScopes.length > 0) {
            uriBuilder.appendQueryParameter("scope", this.scopesToString());
        }
        if (this.mState != null) {
            uriBuilder.appendQueryParameter("state", this.mState);
        }
        if (this.mCustomParams.size() > 0) {
            for (Map.Entry<String, String> entry : this.mCustomParams.entrySet()) {
                uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        return uriBuilder.build();
    }

    private String scopesToString() {
        StringBuilder concatScopes = new StringBuilder();
        for (String scope : this.mScopes) {
            concatScopes.append(scope);
            concatScopes.append(SCOPES_SEPARATOR);
        }
        return concatScopes.toString().trim();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mClientId);
        dest.writeString(this.mResponseType);
        dest.writeString(this.mRedirectUri);
        dest.writeString(this.mState);
        dest.writeStringArray(this.mScopes);
        dest.writeByte((byte)(this.mShowDialog ? 1 : 0));
        dest.writeString(this.mCampaign);
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : this.mCustomParams.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        dest.writeBundle(bundle);
    }

    public static class Builder {
        private final String mClientId;
        private final AuthorizationResponse.Type mResponseType;
        private final String mRedirectUri;
        private String mState;
        private String[] mScopes;
        private boolean mShowDialog;
        private String mCampaign;
        private final Map<String, String> mCustomParams = new HashMap<String, String>();

        public Builder(String clientId, AuthorizationResponse.Type responseType, String redirectUri) {
            if (clientId == null) {
                throw new IllegalArgumentException("Client ID can't be null");
            }
            if (responseType == null) {
                throw new IllegalArgumentException("Response type can't be null");
            }
            if (redirectUri == null || redirectUri.length() == 0) {
                throw new IllegalArgumentException("Redirect URI can't be null or empty");
            }
            this.mClientId = clientId;
            this.mResponseType = responseType;
            this.mRedirectUri = redirectUri;
        }

        public Builder setState(String state) {
            this.mState = state;
            return this;
        }

        public Builder setScopes(String[] scopes) {
            this.mScopes = scopes;
            return this;
        }

        public Builder setShowDialog(boolean showDialog) {
            this.mShowDialog = showDialog;
            return this;
        }

        public Builder setCustomParam(String key, String value) {
            if (key == null || key.isEmpty()) {
                throw new IllegalArgumentException("Custom parameter key can't be null or empty");
            }
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("Custom parameter value can't be null or empty");
            }
            this.mCustomParams.put(key, value);
            return this;
        }

        public Builder setCampaign(String campaign) {
            this.mCampaign = campaign;
            return this;
        }

        public AuthorizationRequest build() {
            return new AuthorizationRequest(this.mClientId, this.mResponseType, this.mRedirectUri, this.mState, this.mScopes, this.mShowDialog, this.mCustomParams, this.mCampaign);
        }
    }
}

