/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class WebengineHolder {
    private static final PatchLogger logger = PatchLogger.getLogger(WebengineHolder.class.getName());
    public static final AtomicReference<String> webengineName = new AtomicReference();
    public static final AtomicReference<String> webengineVersion = new AtomicReference();

    public static void trySetName(String name) {
        if (!webengineName.compareAndSet(null, name) && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Trying to re-set webengine name from {0} to {1}", new Object[]{webengineName.get(), name});
        }
    }

    public static void trySetVersion(String version) {
        if (!webengineVersion.compareAndSet(null, version) && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Trying to re-set webengine version from {0} to {1}", new Object[]{webengineVersion.get(), version});
        }
    }
}

