/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.runtime.compute.ToEnum;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToString;
import java.util.Objects;
import java.util.function.Function;

public final class ToEnumImpl<T, E extends Enum<E>>
implements ToEnum<T, E> {
    private final Class<E> enumClass;
    private final Function<T, E> inner;

    public ToEnumImpl(Class<E> enumClass, Function<T, E> inner) {
        this.enumClass = Objects.requireNonNull(enumClass);
        this.inner = Objects.requireNonNull(inner);
    }

    @Override
    public Class<E> enumClass() {
        return this.enumClass;
    }

    @Override
    public E apply(T t) {
        return (E)((Enum)this.inner.apply(t));
    }

    @Override
    public ToInt<T> asOrdinal() {
        return object -> ((Enum)this.apply(object)).ordinal();
    }

    @Override
    public ToString<T> asName() {
        return object -> ((Enum)this.apply(object)).name();
    }

    @Override
    public long hash(T object) {
        return object.hashCode();
    }

    @Override
    public int compare(T first, T second) {
        return Integer.compare(((Enum)this.apply((Object)first)).ordinal(), ((Enum)this.apply((Object)second)).ordinal());
    }
}

