/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.common.function.BooleanToDoubleFunction;
import com.speedment.common.function.BooleanUnaryOperator;
import com.speedment.runtime.compute.ToBoolean;
import com.speedment.runtime.compute.ToBooleanNullable;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.expression.NullableExpression;
import java.util.Objects;
import java.util.function.Predicate;

public final class ToBooleanNullableImpl<T>
implements NullableExpression<T, ToBoolean<T>>,
ToBooleanNullable<T> {
    private final ToBoolean<T> original;
    private final Predicate<T> isNull;

    public ToBooleanNullableImpl(ToBoolean<T> original, Predicate<T> isNull) {
        this.original = Objects.requireNonNull(original);
        this.isNull = Objects.requireNonNull(isNull);
    }

    @Override
    public ToBoolean<T> inner() {
        return this.original;
    }

    @Override
    public Predicate<T> isNullPredicate() {
        return this.isNull;
    }

    @Override
    public Boolean apply(T t) {
        return this.isNull.test(t) ? null : Boolean.valueOf(this.original.applyAsBoolean(t));
    }

    @Override
    public boolean applyAsBoolean(T t) {
        return this.original.applyAsBoolean(t);
    }

    @Override
    public ToBoolean<T> orThrow() {
        return this.original;
    }

    @Override
    public ToBoolean<T> orElseGet(ToBoolean<T> getter) {
        return t -> this.isNull.test(t) ? getter.applyAsBoolean(t) : this.original.applyAsBoolean(t);
    }

    @Override
    public ToBoolean<T> orElse(Boolean value) {
        return t -> this.isNull.test(t) ? value.booleanValue() : this.original.applyAsBoolean(t);
    }

    @Override
    public ToDoubleNullable<T> mapToDoubleIfPresent(BooleanToDoubleFunction mapper) {
        return t -> this.isNull.test(t) ? null : Double.valueOf(mapper.applyAsDouble(this.original.applyAsBoolean(t)));
    }

    @Override
    public ToBooleanNullable<T> mapIfPresent(BooleanUnaryOperator mapper) {
        return t -> this.isNull.test(t) ? null : Boolean.valueOf(mapper.applyAsBoolean(this.original.applyAsBoolean(t)));
    }

    @Override
    public long hash(T object) {
        if (this.isNull.test(object)) {
            return 2L;
        }
        return this.original.applyAsBoolean(object) ? 1L : 0L;
    }

    @Override
    public int compare(T first, T second) {
        boolean f = this.isNull(first);
        boolean s = this.isNull(second);
        if (f && s) {
            return 0;
        }
        if (f) {
            return 1;
        }
        if (s) {
            return -1;
        }
        return Boolean.compare(this.original.applyAsBoolean(first), this.original.applyAsBoolean(second));
    }

    @Override
    public boolean isNull(T object) {
        return this.isNull.test(object);
    }

    @Override
    public boolean isNotNull(T object) {
        return !this.isNull.test(object);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NullableExpression)) {
            return false;
        }
        NullableExpression that = (NullableExpression)o;
        return Objects.equals(this.original, that.inner()) && Objects.equals(this.isNull, that.isNullPredicate());
    }

    public int hashCode() {
        return Objects.hash(this.original, this.isNull);
    }
}

