/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.ConstantDoubleImpl;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasDivide;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import com.speedment.runtime.compute.trait.HasMinus;
import com.speedment.runtime.compute.trait.HasMultiply;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasPlus;
import com.speedment.runtime.compute.trait.HasPow;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

@FunctionalInterface
public interface ToDouble<T>
extends Expression<T>,
ToDoubleFunction<T>,
HasAsDouble<T>,
HasAsInt<T>,
HasAsLong<T>,
HasAbs<ToDouble<T>>,
HasSign<ToByte<T>>,
HasSqrt<ToDouble<T>>,
HasNegate<ToDouble<T>>,
HasPow<T>,
HasPlus<T>,
HasMinus<T>,
HasMultiply<T>,
HasDivide<T>,
HasMap<T, DoubleUnaryOperator, ToDouble<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToDouble<T> of(ToDoubleFunction<T> lambda) {
        if (lambda instanceof ToDouble) {
            return (ToDouble)lambda;
        }
        return lambda::applyAsDouble;
    }

    public static <T> ToDouble<T> constant(double value) {
        return new ConstantDoubleImpl(value);
    }

    @Override
    public double applyAsDouble(T var1);

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.DOUBLE;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return this;
    }

    @Override
    default public ToInt<T> asInt() {
        return CastUtil.castDoubleToInt(this);
    }

    @Override
    default public ToLong<T> asLong() {
        return CastUtil.castDoubleToLong(this);
    }

    @Override
    default public ToDouble<T> map(DoubleUnaryOperator operator) {
        return MapperUtil.mapDouble(this, operator);
    }

    @Override
    default public ToDouble<T> abs() {
        return Expressions.abs(this);
    }

    @Override
    default public ToByte<T> sign() {
        return Expressions.sign(this);
    }

    @Override
    default public ToDouble<T> sqrt() {
        return Expressions.sqrt(this);
    }

    @Override
    default public ToDouble<T> negate() {
        return Expressions.negate(this);
    }

    @Override
    default public ToDouble<T> pow(int power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(double power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToInt<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToDouble<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> plus(byte other) {
        return Expressions.plus(this, (int)other);
    }

    @Override
    default public ToDouble<T> plus(ToByte<T> other) {
        return Expressions.plus(this, other.asDouble());
    }

    @Override
    default public ToDouble<T> plus(int other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(ToInt<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(long other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(ToLong<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(double other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(ToDouble<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> minus(byte other) {
        return Expressions.minus(this, (int)other);
    }

    @Override
    default public ToDouble<T> minus(ToByte<T> other) {
        return Expressions.minus(this, other.asDouble());
    }

    @Override
    default public ToDouble<T> minus(int other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(ToInt<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(long other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(ToLong<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(double other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(ToDouble<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> multiply(byte other) {
        return Expressions.multiply(this, (int)other);
    }

    @Override
    default public ToDouble<T> multiply(ToByte<T> other) {
        return Expressions.multiply(this, other.asDouble());
    }

    @Override
    default public ToDouble<T> multiply(int other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(ToInt<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(long other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(ToLong<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(double other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(ToDouble<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> divide(int divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToInt<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(long divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToLong<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(double divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToDouble<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public long hash(T object) {
        long l = Double.doubleToLongBits(this.applyAsDouble(object));
        return (int)(l ^ l >>> 32);
    }

    @Override
    default public int compare(T first, T second) {
        return Double.compare(this.applyAsDouble(first), this.applyAsDouble(second));
    }

    @Override
    default public <V> ToDoubleNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToDouble(casted, this);
    }
}

