/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.HashUtil;
import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.JavadocTag;
import com.speedment.common.codegen.model.trait.HasJavadoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class JavadocImpl
implements Javadoc {
    private HasJavadoc<?> parent;
    private String text;
    private final List<Import> imports;
    private final List<JavadocTag> tags;

    public JavadocImpl() {
        this.text = "";
        this.tags = new ArrayList<JavadocTag>();
        this.imports = new ArrayList<Import>();
    }

    public JavadocImpl(String text) {
        this.text = Objects.requireNonNull(text);
        this.tags = new ArrayList<JavadocTag>();
        this.imports = new ArrayList<Import>();
    }

    protected JavadocImpl(Javadoc prototype) {
        this.text = Objects.requireNonNull(prototype).getText();
        this.tags = Copier.copy(prototype.getTags());
        this.imports = Copier.copy(prototype.getImports());
    }

    @Override
    public Javadoc setParent(HasJavadoc<?> parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Optional<HasJavadoc<?>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Javadoc setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public List<JavadocTag> getTags() {
        return this.tags;
    }

    @Override
    public JavadocImpl copy() {
        return new JavadocImpl(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + HashUtil.identityHashForParent(this);
        hash = 29 * hash + Objects.hashCode(this.text);
        hash = 29 * hash + Objects.hashCode(this.imports);
        hash = 29 * hash + Objects.hashCode(this.tags);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavadocImpl other = (JavadocImpl)obj;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.text, other.text)) {
            return false;
        }
        if (!Objects.equals(this.imports, other.imports)) {
            return false;
        }
        return Objects.equals(this.tags, other.tags);
    }
}

