/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.model.Value;
import com.speedment.common.codegen.model.trait.HasClasses;
import com.speedment.common.codegen.model.trait.HasCode;
import com.speedment.common.codegen.model.trait.HasConstructors;
import com.speedment.common.codegen.model.trait.HasFields;
import com.speedment.common.codegen.model.trait.HasInitializers;
import com.speedment.common.codegen.model.trait.HasJavadoc;
import com.speedment.common.codegen.model.trait.HasMethods;
import com.speedment.common.codegen.model.value.ReferenceValue;
import com.speedment.common.codegen.util.Formatting;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AlignTabs<T>
implements Consumer<T> {
    @Override
    public void accept(T model) {
        Object casted;
        if (model instanceof HasCode) {
            casted = (HasCode)model;
            Formatting.alignTabs(casted.getCode());
        }
        if (model instanceof HasClasses) {
            casted = (HasClasses)model;
            casted.getClasses().forEach(c -> c.call(new AlignTabs()));
        }
        if (model instanceof HasMethods) {
            casted = (HasMethods)model;
            casted.getMethods().forEach(c -> c.call(new AlignTabs()));
        }
        if (model instanceof HasConstructors) {
            casted = (HasConstructors)model;
            casted.getConstructors().forEach(c -> c.call(new AlignTabs()));
        }
        if (model instanceof HasInitializers) {
            casted = (HasInitializers)model;
            casted.getInitializers().forEach(c -> c.call(new AlignTabs()));
        }
        if (model instanceof HasFields) {
            casted = (HasFields)model;
            AlignTabs.alignTabs(casted.getFields(), field -> field.getValue().filter(ReferenceValue.class::isInstance).map(ReferenceValue.class::cast).map(Value::getValue).orElse(null), (field, value) -> ((ReferenceValue)field.getValue().orElseThrow(NoSuchElementException::new)).setValue(value));
        }
        if (model instanceof HasJavadoc) {
            casted = (HasJavadoc)model;
            casted.getJavadoc().ifPresent(javadoc -> {
                List<String> rows = Stream.of(javadoc.getText().split(Formatting.nl())).collect(Collectors.toList());
                Formatting.alignTabs(rows);
                javadoc.setText(rows.stream().collect(Collectors.joining(Formatting.nl())));
            });
        }
    }

    private static <T> void alignTabs(List<T> models, Function<T, String> getRow, BiConsumer<T, String> setRow) {
        AtomicInteger maxIndex = new AtomicInteger(-1);
        block0: while (true) {
            maxIndex.set(-1);
            models.forEach(model -> {
                String row = (String)getRow.apply(model);
                AlignTabs.updateMaxIndex(maxIndex, row);
            });
            if (maxIndex.get() <= -1) break;
            Iterator<T> iterator = models.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                T model2 = iterator.next();
                String row = getRow.apply(model2);
                if (row == null) continue;
                int index = row.indexOf(9);
                AlignTabs.replaceTabWithSpace(setRow, maxIndex, model2, row, index);
            }
            break;
        }
    }

    private static <T> void replaceTabWithSpace(BiConsumer<T, String> setRow, AtomicInteger maxIndex, T model, String row, int index) {
        if (index > -1) {
            setRow.accept(model, row.replaceFirst("\t", Formatting.repeat(" ", maxIndex.get() - index)));
        }
    }

    private static void updateMaxIndex(AtomicInteger maxIndex, String row) {
        int index;
        if (row != null && (index = row.indexOf(9)) > maxIndex.get()) {
            maxIndex.set(index);
        }
    }
}

