/*
 * Decompiled with CFR 0.152.
 */
package spark.template.thymeleaf;

import java.util.Locale;
import java.util.Map;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import spark.ModelAndView;
import spark.TemplateEngine;

public class ThymeleafTemplateEngine
extends TemplateEngine {
    private static final String DEFAULT_PREFIX = "templates/";
    private static final String DEFAULT_SUFFIX = ".html";
    private static final long DEFAULT_CACHE_TTL_MS = 3600000L;
    private org.thymeleaf.TemplateEngine templateEngine;

    public ThymeleafTemplateEngine() {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX);
    }

    public ThymeleafTemplateEngine(String prefix, String suffix) {
        ITemplateResolver defaultTemplateResolver = ThymeleafTemplateEngine.createDefaultTemplateResolver(prefix, suffix);
        this.initialize(defaultTemplateResolver);
    }

    public ThymeleafTemplateEngine(ITemplateResolver templateResolver) {
        this.initialize(templateResolver);
    }

    private static ITemplateResolver createDefaultTemplateResolver(String prefix, String suffix) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setPrefix(prefix != null ? prefix : DEFAULT_PREFIX);
        templateResolver.setSuffix(suffix != null ? suffix : DEFAULT_SUFFIX);
        templateResolver.setCacheTTLMs(Long.valueOf(3600000L));
        return templateResolver;
    }

    private void initialize(ITemplateResolver templateResolver) {
        this.templateEngine = new org.thymeleaf.TemplateEngine();
        this.templateEngine.setTemplateResolver(templateResolver);
        this.templateEngine.addDialect((IDialect)new Java8TimeDialect());
    }

    public String render(ModelAndView modelAndView) {
        return this.render(modelAndView, Locale.getDefault());
    }

    public String render(ModelAndView modelAndView, Locale locale) {
        Object model = modelAndView.getModel();
        if (model instanceof Map) {
            Context context = new Context(locale);
            context.setVariables((Map)model);
            return this.templateEngine.process(modelAndView.getViewName(), (IContext)context);
        }
        throw new IllegalArgumentException("modelAndView.getModel() must return a java.util.Map");
    }
}

