/*
 * Decompiled with CFR 0.152.
 */
package spark.template.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jetty.io.RuntimeIOException;
import spark.ModelAndView;
import spark.TemplateEngine;

public class MustacheTemplateEngine
extends TemplateEngine {
    private MustacheFactory mustacheFactory;

    public MustacheTemplateEngine() {
        this.mustacheFactory = new DefaultMustacheFactory("templates");
    }

    public MustacheTemplateEngine(String resourceRoot) {
        this.mustacheFactory = new DefaultMustacheFactory(resourceRoot);
    }

    public MustacheTemplateEngine(MustacheFactory mustacheFactory) {
        this.mustacheFactory = mustacheFactory;
    }

    public String render(ModelAndView modelAndView) {
        String viewName = modelAndView.getViewName();
        Mustache mustache = this.mustacheFactory.compile(viewName);
        StringWriter stringWriter = new StringWriter();
        try {
            mustache.execute((Writer)stringWriter, modelAndView.getModel()).close();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        return stringWriter.toString();
    }
}

