/*
 * Decompiled with CFR 0.152.
 */
package spark.template.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import spark.ModelAndView;
import spark.TemplateEngine;

public class FreeMarkerEngine
extends TemplateEngine {
    private Configuration configuration;

    public FreeMarkerEngine() {
        this.configuration = this.createDefaultConfiguration();
    }

    public FreeMarkerEngine(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String render(ModelAndView modelAndView) {
        try {
            StringWriter stringWriter = new StringWriter();
            Template template = this.configuration.getTemplate(modelAndView.getViewName());
            template.process(modelAndView.getModel(), stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TemplateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private Configuration createDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(FreeMarkerEngine.class, "");
        return configuration;
    }
}

