/*
 * Decompiled with CFR 0.152.
 */
package spark.debug;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import freemarker.template.Configuration;
import freemarker.template.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import spark.ExceptionHandler;
import spark.Request;
import spark.Response;
import spark.Spark;
import spark.debug.FileSearchSourceLocator;
import spark.debug.Iterables;
import spark.debug.SourceLocator;
import spark.template.freemarker.FreeMarkerEngine;

public class DebugScreen
implements ExceptionHandler {
    protected final FreeMarkerEngine templateEngine = new FreeMarkerEngine();
    protected final Configuration templateConfig = new Configuration(new Version(2, 3, 23));
    protected final SourceLocator[] sourceLocators;

    public DebugScreen() {
        this(new FileSearchSourceLocator("./src/main/java"), new FileSearchSourceLocator("./src/test/java"));
    }

    public DebugScreen(SourceLocator ... sourceLocators) {
        this.templateConfig.setClassForTemplateLoading(this.getClass(), "/");
        this.templateEngine.setConfiguration(this.templateConfig);
        this.sourceLocators = sourceLocators;
    }

    public static void enableDebugScreen() {
        Spark.exception(Exception.class, new DebugScreen());
    }

    public static void enableDebugScreen(SourceLocator ... sourceLocators) {
        Spark.exception(Exception.class, new DebugScreen(sourceLocators));
    }

    @Override
    public final void handle(Exception exception, Request request, Response response) {
        this.handleThrowable(exception, request, response);
    }

    public final void handleThrowable(Throwable throwable, Request request, Response response) {
        response.status(500);
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        try {
            List<Map<String, Object>> frames = this.parseFrames(throwable);
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            model.put("message", Optional.fromNullable(throwable.getMessage()).or(""));
            model.put("plain_exception", ExceptionUtils.getStackTrace(throwable));
            model.put("frames", frames);
            model.put("name", throwable.getClass().getCanonicalName().split("\\."));
            model.put("basic_type", throwable.getClass().getSimpleName());
            model.put("type", throwable.getClass().getCanonicalName());
            LinkedHashMap<String, Map<String, ? extends Object>> tables = new LinkedHashMap<String, Map<String, ? extends Object>>();
            this.installTables(tables, request);
            model.put("tables", tables);
            response.body(this.templateEngine.render(Spark.modelAndView(model, "debugscreen.ftl")));
        }
        catch (Exception e) {
            response.body("<html>  <head>    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">  </head>  <body>    <h1>Caught Exception:</h1>    <pre>" + ExceptionUtils.getStackTrace(throwable) + "</pre>" + "    <h1>Caught Exception Rendering DebugScreen:</h1>" + "    <pre>" + ExceptionUtils.getStackTrace(e) + "</pre>" + "  </body>" + "</html>");
        }
    }

    protected void installTables(LinkedHashMap<String, Map<String, ? extends Object>> tables, Request request) {
        tables.put("Headers", this.setToLinkedHashMap(request.headers(), h -> h, request::headers));
        tables.put("Spark Request properties", this.getRequestInfo(request));
        tables.put("Route Parameters", request.params());
        tables.put("Query Parameters", this.setToLinkedHashMap(request.queryParams(), p -> p, request::queryParams));
        tables.put("Session Attributes", this.setToLinkedHashMap(request.session().attributes(), a -> a, request.session()::attribute));
        tables.put("Request Attributes", this.setToLinkedHashMap(request.attributes(), a -> a, request::attribute));
        tables.put("Cookies", request.cookies());
        tables.put("Environment", this.getEnvironmentInfo());
    }

    private LinkedHashMap<String, String> setToLinkedHashMap(Set<String> set, Function<String, String> keyMapper, Function<String, String> valueMapper) {
        return set.stream().collect(Collectors.toMap(keyMapper, valueMapper, (k, v) -> k, LinkedHashMap::new));
    }

    private LinkedHashMap<String, Object> getEnvironmentInfo() {
        LinkedHashMap<String, Object> environment = new LinkedHashMap<String, Object>();
        environment.put("Thread ID", Thread.currentThread().getId());
        return environment;
    }

    private LinkedHashMap<String, Object> getRequestInfo(Request request) {
        LinkedHashMap<String, Object> req = new LinkedHashMap<String, Object>();
        req.put("URL", Optional.fromNullable(request.url()).or("-"));
        req.put("Scheme", Optional.fromNullable(request.scheme()).or("-"));
        req.put("Method", Optional.fromNullable(request.requestMethod()).or("-"));
        req.put("Protocol", Optional.fromNullable(request.protocol()).or("-"));
        req.put("Remote IP", Optional.fromNullable(request.ip()).or("-"));
        return req;
    }

    private List<Map<String, Object>> parseFrames(Throwable e) {
        ImmutableList.Builder frames = ImmutableList.builder();
        for (StackTraceElement frame : e.getStackTrace()) {
            frames.add(this.parseFrame(frame));
        }
        return frames.build();
    }

    private Map<String, Object> parseFrame(StackTraceElement sframe) {
        SourceLocator locator;
        ImmutableMap.Builder<String, Object> frame = ImmutableMap.builder();
        frame.put("file", Optional.fromNullable(sframe.getFileName()).or("<#unknown>"));
        frame.put("class", Optional.fromNullable(sframe.getClassName()).or(""));
        frame.put("line", Optional.fromNullable(Integer.toString(sframe.getLineNumber())).or(""));
        frame.put("function", Optional.fromNullable(sframe.getMethodName()).or(""));
        frame.put("comments", ImmutableList.of());
        Optional<File> file = Optional.absent();
        SourceLocator[] sourceLocatorArray = this.sourceLocators;
        int n = sourceLocatorArray.length;
        for (int i = 0; i < n && !(file = (locator = sourceLocatorArray[i]).findFileForFrame(sframe)).isPresent(); ++i) {
        }
        Optional<Map<Integer, String>> codeLines = this.fetchFileLines(file, sframe);
        if (codeLines.isPresent()) {
            frame.put("code_start", Iterables.reduce(codeLines.get().keySet(), Integer.MAX_VALUE, Math::min) + 1);
            frame.put("code", Joiner.on("\n").join(Iterables.map(codeLines.get().values(), x -> x.length() == 0 ? " " : x)));
            try {
                frame.put("canonical_path", file.get().getPath());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return frame.build();
    }

    private Optional<Map<Integer, String>> fetchFileLines(Optional<File> file, StackTraceElement frame) {
        if (!file.isPresent() || frame.getLineNumber() == -1) {
            return Optional.absent();
        }
        ImmutableMap.Builder<Integer, String> lines = ImmutableMap.builder();
        int start = Math.max(frame.getLineNumber() - 10, 0);
        int end = start + 20;
        int current = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(file.get()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (current < start) {
                    ++current;
                    continue;
                }
                if (current > end) {
                    break;
                }
                lines.put(current, line);
                ++current;
            }
        }
        catch (Exception e) {
            return Optional.absent();
        }
        return Optional.of(lines.build());
    }
}

